import * as kwt from 'kiteclib';
export class WRichGraphics extends kwt.AbstractRichGraphics {
    constructor() {
        super();
    }
    setColor(color) {
        if (color instanceof kwt.KColor) {
            let c = color.css();
            this.ctx.fillStyle = c;
            this.ctx.strokeStyle = c;
        }
    }
    setStroke(lt) {
        if (!lt)
            lt = kwt.IRichGraphicsConst.LINE_1;
        var w = 0;
        if (lt.widthType === kwt.KLineType.TYPE_DEVICE)
            w = lt.width;
        else if (lt.widthType === kwt.KLineType.TYPE_DRAWING)
            w = lt.width * this.mDotPerLen;
        this.ctx.lineWidth = w;
    }
    setQuality(quality) {
        this.quality = quality;
    }
    getQuality() {
        return this.quality;
    }
    setClipArea(x1, y1, x2, y2) { }
    releaseClipArea() { }
    drawCircle(x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    }
    drawEllipse(x1, y1, x2, y2, p4, p5, lt) {
        console.warn("Unimplemented " + arguments);
    }
    drawFillCircle(x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    }
    drawFillEllipse(x1, y1, x2, y2, p4, p5, lt) {
        console.warn("Unimplemented " + arguments);
    }
    drawFillRect(x1, y1, x2, y2, lt) {
        this.setStroke(lt);
        var xa = this.realToDevXd(x1);
        var ya = this.realToDevYd(y1);
        var xb = this.realToDevXd(x2);
        var yb = this.realToDevYd(y2);
        if (xa > xb) {
            let tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            let tmp = ya;
            ya = yb;
            yb = tmp;
        }
        this.ctx.fillRect(xa, ya, xb - xa, yb - ya);
    }
    drawFillRoundRect(x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    }
    drawImageId(img, id, x1, y1, x2, y2) {
        console.warn("Unimplemented " + arguments);
    }
    drawImagePrefixId(img, prefix, id, x1, y1, x2, y2) {
        console.warn("Unimplemented " + arguments);
    }
    drawImagePosition(img, x1, y1, x2, y2) {
        console.warn("Unimplemented " + arguments);
    }
    drawImageRect(img, cx, cy, width, height, angle) {
        console.warn("Unimplemented " + arguments);
    }
    drawLine(x1, y1, x2, y2, lt) {
        var xa = this.realToDevXd(x1);
        var ya = this.realToDevYd(y1);
        var xb = this.realToDevXd(x2);
        var yb = this.realToDevYd(y2);
        this.setStroke(lt);
        this.ctx.beginPath();
        this.ctx.moveTo(xa, ya);
        this.ctx.lineTo(xb, yb);
        this.ctx.stroke();
    }
    drawMark(x1, y1, x2, y2) {
        console.warn("Unimplemented " + arguments);
    }
    drawRect(x1, y1, x2, y2, lt) {
        this.setStroke(lt);
        var xa = this.realToDevXd(x1);
        var ya = this.realToDevYd(y1);
        var xb = this.realToDevXd(x2);
        var yb = this.realToDevYd(y2);
        if (xa > xb) {
            let tmp = xa;
            xa = xb;
            xb = tmp;
        }
        if (ya < yb) {
            let tmp = ya;
            ya = yb;
            yb = tmp;
        }
        this.ctx.strokeRect(xa, ya, xb - xa, yb - ya);
    }
    drawRoundRect(x1, y1, x2, y2, p4, lt) {
        console.warn("Unimplemented " + arguments);
    }
    drawText(text, x, y, fontname, fonttype, size, angle) {
        var xx = this.realToDevXd(x);
        var yy = this.realToDevYd(y);
        var tsize = this.mDotPerLen * size;
        this.ctx.font = tsize + "px '" + fontname + "'";
        if (angle == 0) {
            this.ctx.fillText(text, xx, yy);
        }
        else {
            this.ctx.fillText(text + "<<TODO " + angle + ">>", xx, yy);
        }
    }
    fillPath(lt) {
        this.setStroke(lt);
        if (this.fillRule === kwt.IRichGraphicsConst.WIND_EVEN_ODD)
            this.ctx.fill("evenodd");
        else if (this.fillRule === kwt.IRichGraphicsConst.WIND_NON_ZERO)
            this.ctx.fill("nonzero");
        else
            this.ctx.fill();
    }
    drawPath(lt) {
        this.setStroke(lt);
        this.ctx.stroke();
    }
    pathClear() {
        this.ctx.beginPath();
    }
    pathClose() {
        this.ctx.closePath();
    }
    pathInit(w) {
        this.fillRule = w;
        this.ctx.beginPath();
    }
    pathLineTo(x, y, la) {
        var xx = this.getx(x, y, la);
        var yy = this.gety(x, y, la);
        this.ctx.lineTo(xx, yy);
    }
    pathMoveTo(x, y, la) {
        var xx = this.getx(x, y, la);
        var yy = this.gety(x, y, la);
        this.ctx.moveTo(xx, yy);
    }
    pathQuadTo(x1, y1, x2, y2, la) {
        var xa = this.getx(x1, y1, la);
        var ya = this.gety(x1, y1, la);
        var xb = this.getx(x2, y2, la);
        var yb = this.gety(x2, y2, la);
        this.ctx.quadraticCurveTo(xa, ya, xb, yb);
    }
    pathCurveTo(x1, y1, x2, y2, x3, y3, la) {
        var xa = this.getx(x1, y1, la);
        var ya = this.gety(x1, y1, la);
        var xb = this.getx(x2, y2, la);
        var yb = this.gety(x2, y2, la);
        var xc = this.getx(x3, y3, la);
        var yc = this.gety(x3, y3, la);
        this.ctx.bezierCurveTo(xa, ya, xb, yb, xc, yc);
    }
}
//# sourceMappingURL=WRichGraphics.js.map