//module nethome.ui.command
/**
 * ドキュメント操作クラス<br> <br> サブクラスでアプリケーション特有の操作処理を実装する。<br> <br> [注意事項]<br> ・ドキュメント状態の表示とその操作に特化する。<br> ・<B>このクラスが無くてもドキュメントを再現出来ることが必要</B><br>　あくまでもMVCモデルのC(コントローラ）であることを厳守する。<br>
 * 　一時的なものであり、このサブクラスが存在しなくても操作が出来なくなるだけで、ドキュメントを構成する<br>
 * 　要素でな無いことに最大限注意する。<br>・ドキュメントはMainComponentのインスタンスから取得する。<br> MainComponent mc = MainComponent.getInstance();<br> MainApplication app = mc.getApplication();<br>
 * @author kawae
 * @version 1.0
**/
export class Command {
    /**
     * コンストラクタ
     **/
    constructor() {
    }
    /**
     * コマンドの引き続き有効モードの設定
     * @param b
    **/
    //setContinue(b: boolean): void {
    //    this.mContinue = b;
    //}
    /**
     * フレームが閉じられた場合の処理**/
    //frameClosing(): void {
    //}
    /**
     * コールバックリスナの設定
     * @param l
    **/
    //addCallBackListener(l: CallBackListener): void {
    //    mCallBack = l;
    //}
    /**
     * コンテキストメニューアイテムの設定**/
    //setContextMenu(c: IContextMenu): void {
    //    mContextMenu = c;
    //}
    /**
     * コンテキストメニューの取得**/
    //getContextMenu(): IContextMenu {
    //    return mContextMenu;
    //}
    /**
     * 初期処理<BR> 単一動作時は処理自体を、継続動作時は初期化処理を行うことを推奨。
     * @author kawae
     * @since 2004/01/01
    **/
    play() {
    }
    /**
     * 終了時処理
     * @author kawae
     * @since 2004/01/01
    **/
    end() {
    }
    /**
     * ユーザーインターフェースの更新
     * @author kawae
     * @since 2004/01/01
    **/
    updateInterface() {
    }
    /**
     * ユーザーインターフェースの初期化
     * @author kawae
     * @since 2004/01/01
    **/
    initInterface() {
    }
    /**
     * UIの作成
     * @param info	コマンド属性情報
     * @return　UIコンポーネント
     * @author kawae
     * @since 2004/10/02
    **/
    createComponent(info) {
        this.mCommandInfo = info;
        return null;
    }
    /**
     * @return
     * @author kawae
     * @since 2005/09/06
    **/
    //getCommandInfo(): ICommandInfo {
    //    return mCommandInfo;
    //}
    /**
     * 別コマンドが実行された場合の後始末。
     * @author kawae
     * @since 2003/01/01
    **/
    restoration() {
    }
    /**
     * コンポーネントの取得
     * @return
    **/
    getComponent() {
        return this.mComponent;
    }
    /**
     * コンポーネントの設定**/
    setComponent(c) {
        this.mComponent = c;
    }
    ///**
    // * マウス移動処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    // * @author kawae
    // * @since 2003/01/01
    // * @see nethome.ui.command.Command#mouseMove(int,int,int)
    //**/
    //mouseMove(x: number, y: number, mod: number): void {
    //}
    ///**
    // * マウスボタンプレス処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    // * @author kawae
    // * @since 2003/01/01
    // * @see nethome.ui.command.Command#mousePress(int,int,int)
    //**/
    //mousePress(x: number, y: number, mod: number): void {
    //}
    ///**
    // * マウスドラッグ処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    // * @author kawae
    // * @since 2003/01/01
    // * @see nethome.ui.command.Command#mousePress(int,int,int)
    //**/
    //mouseDrag(x: number, y: number, mod: number): void {
    //}
    ///**
    // * マウスボタンリリース処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    // * @author kawae
    // * @since 2003/01/01
    // * @see nethome.ui.command.Command#mousePress(int,int,int)
    //**/
    //mouseRelease(x: number, y: number, mod: number): void {
    //}
    ///**
    // * マウスボタンダブルクリック処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    // * @author kawae
    // * @since 2003/01/01
    // * @see nethome.ui.command.Command#mousePress(int,int,int)
    //**/
    //mouseDoubleClicked(x: number, y: number, mod: number): void {
    //}
    ///**
    // * キャンバスにマウスカーソルが入ったときの処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    //**/
    //mouseEntered(x: number, y: number, mod: number): void {
    //}
    ///**
    // * キャンバスにマウスカーソルが出たときの処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    //**/
    //mouseExited(x: number, y: number, mod: number): void {
    //}
    ///**
    // * マウスホイール上回転処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    // * @author kawae
    // * @since 2003/01/01
    // * @see nethome.ui.command.Command#mousePress(int,int,int)
    //**/
    //wheelUp(x: number, y: number, mod: number): void {
    //}
    ///**
    // * マウスホイール下回転処理
    // * @param x	デバイス上のX座標
    // * @param y	デバイス上のY座標
    // * @param mod	修飾子フラグ
    // * @author kawae
    // * @since 2003/01/01
    // * @see nethome.ui.command.Command#mousePress(int,int,int)
    //**/
    //wheelDown(x: number, y: number, mod: number): void {
    //}
    ///**
    // * キープレス処理
    // * @param i	キーコード
    // * @param m	修飾子
    // * @author kawae
    // * @since 2003/01/01
    //**/
    //keyPress(i: number, m: number): boolean {
    //    return false;
    //}
    ///**
    // * キーリリース処理
    // * @param i	キーコード
    // * @param m	修飾子
    // * @author kawae
    // * @since 2003/01/01
    //**/
    //keyReleased(i: number, m: number): void {
    //}
    ///**
    // * アクセラレーションキー等のイベントハンドラ
    // * @author kawae
    // * @since 2003/01/01
    //**/
    //accelerate(): void {
    //    this.play();
    //}
    /**
     * コマンドの描画
     * @param rg	描画コンテキスト
     * @author kawae
     * @since 2003/01/01//	 * @since 2004/09/22
     * @see nethome.ui.command.Command#drawCommand(jp.kitec.kwt.IRichGraphics)
    **/
    drawCommand(d) {
    }
}
//# sourceMappingURL=Command.js.map