import { Command } from './Command';
import { Canvas2D } from '../Canvas2D';
//import { CommandUtil } from './CommandUtil'
//module nethome.ui.command
/**
 * 画面移動コマンドクラス
 * @author 未入力
 * @version 1.0
**/
export class ComViewMove extends Command {
    constructor() {
        super();
        this.mPres = false;
        //mouseMove(x: number, y: number, mod: number): void {
        //}
        this.onmousedown = (ev) => {
            //mousePress(x: number, y: number, mod: number): void {
            let x = ev.offsetX;
            let y = ev.offsetY;
            this.mPres = true;
            let can = this.canvas;
            if (can == null)
                return;
            this.mX = x;
            this.mY = y;
            this.mCx = can.getViewPort().getCx();
            this.mCy = can.getViewPort().getCy();
            //can.setDrawMode(Canvas2D.DRAW_LINE);
            can.updateImage();
            can.repaint();
        };
        this.onmousemove = (ev) => {
            let x = ev.offsetX;
            let y = ev.offsetY;
            if (ev.buttons === 0)
                return;
            //mouseDrag(x: number, y: number, mod: number): void {
            let can = this.canvas;
            if (can == null)
                return;
            can.setCursor(Canvas2D.MOUSE_MOVE);
            let xx = can.devToRealX(x);
            let yy = can.devToRealY(y);
            can.getViewPort().setViewCenter(this.mCx - (xx - can.devToRealX(this.mX)), this.mCy - (yy - can.devToRealY(this.mY)));
            can.updateImage();
            can.repaint();
            can.updateViewControl();
        };
        this.onmouseup = (ev) => {
            let x = ev.offsetX;
            let y = ev.offsetY;
            //mouseRelease(x: number, y: number, mod: number): void {
            if (!this.mPres)
                return;
            let can = this.canvas;
            if (can == null)
                return;
            //can.setDrawMode(Canvas2D.DRAW_FULL);
            can.updateImage();
            this.mPres = false;
            //if (!this.mContinue)
            //    can.setMouseCommand(null);
            can.repaint();
        };
    }
    play() {
        //CommandUtil.setActiveUI(this.mComponent, true);
        let can = this.canvas;
        if (can == null)
            return;
        can.setCursor(Canvas2D.MOUSE_MOVE);
    }
    end() {
        //CommandUtil.setActiveUI(this.mComponent, false);
        let can = this.canvas;
        if (can == null)
            return;
        if (this.mPres) {
            this.mPres = false;
            //can.setDrawMode(Canvas2D.DRAW_FULL);
            can.updateImage();
            can.repaint();
        }
        can.setCursor(Canvas2D.MOUSE_DEF);
    }
}
//# sourceMappingURL=ComViewMove.js.map