import { IRichGraphics } from 'kiteclib';
/**
 * UI要素をもたないコントローラ
 * @author kawae
**/
export declare abstract class AbstSubCommand {
    static MOUSE_MOVE: number;
    static MOUSE_DRAG: number;
    static EDIT_NEW: number;
    static EDIT_EDIT: number;
    /**
     * マウスの動作モード MOUSE_MOVE:移動時 MOUSE_DRAG:ドラッグ時**/
    mMouseMode: number;
    /**
     * 編集モード EDIT_NEW:新規作成時 EDIT_EDIT:編集時**/
    mEditMode: number;
    /**
     * コンストラクタ
     * @author kawae
     * @since 2004/01/01
    **/
    constructor();
    /**
     * ターゲットのセット
     * @param o1	ターゲット１汎用オブジェクト
     * @param o2	ターゲット２汎用オブジェクト
     * @param mode	モード汎用フラグ
     * @param editmode	編集汎用フラグ
     * @author kawae
     * @since 2003/01/01
     * @see nethome.ui.command.SubCommand#setTarget(java.lang.Object,java.lang.Object,short,short)
    **/
    setTarget(o1: Object, o2: Object, mode: number, editmode: number): void;
    /**
     * コマンド初期化処理
     * @author kawae
     * @since 2003/01/01
     * @see nethome.ui.command.Command#play()
    **/
    play(): void;
    /**
     * コマンド終了処理
     * @author kawae
     * @since 2003/01/01
     * @see nethome.ui.command.SubCommand#play()
    **/
    end(): void;
    onclick: (ev: MouseEvent) => any;
    ondblclick: (ev: MouseEvent) => any;
    onmousedown: (ev: MouseEvent) => any;
    onmouseenter: (ev: MouseEvent) => any;
    onmouseleave: (ev: MouseEvent) => any;
    onmousemove: (ev: MouseEvent) => any;
    onmouseout: (ev: MouseEvent) => any;
    onmouseover: (ev: MouseEvent) => any;
    onmouseup: (ev: MouseEvent) => any;
    onmousewheel: (ev: MouseWheelEvent) => any;
    onkeydown: (ev: KeyboardEvent) => any;
    onkeypress: (ev: KeyboardEvent) => any;
    onkeyup: (ev: KeyboardEvent) => any;
    /**
     * コマンドの描画
     * @param rg	描画コンテキスト
     * @author kawae
     * @since 2003/01/01
     * @see nethome.ui.command.SubCommand#drawCommand(jp.kitec.kwt.IRichGraphics)
    **/
    drawCommand(d: IRichGraphics): void;
}
