//module nethome.ui
/**
 * マスクコマンド
 * @author kawae
**/
export class MaskCommand {
    constructor(c, mod) {
        this.mCom = c;
        this.mMod = mod;
    }
    matchMask(mod) {
        return this.mMod === mod;
    }
    get command() {
        return this.mCom;
    }
}
export const SHIFT_MASK = 1 << 0;
export const CTRL_MASK = 1 << 1;
export const META_MASK = 1 << 2;
export const ALT_MASK = 1 << 3;
export function getModifiers(ev) {
    let mod = 0;
    if (ev.shiftKey)
        mod |= SHIFT_MASK;
    if (ev.ctrlKey)
        mod |= CTRL_MASK;
    if (ev.metaKey)
        mod |= META_MASK;
    if (ev.altKey)
        mod |= ALT_MASK;
    return mod;
}
//# sourceMappingURL=MaskCommand.js.map