//module nethome.ui
export class DefaultDrawData {
    constructor() {
        /**
         * シンプル表示フラグ **/
        this.mDrawMode = DefaultDrawData.DRAW_FULL;
        this.mAdditionalDrawGeoms = [];
        this.mOptionalDrawElement = [];
    }
    /**
     * オプショナル描画オブジェクト群の取得**/
    getOptionalDrawList() {
        return this.mOptionalDrawElement;
    }
    /**
     * オプショナル描画オブジェクトの追加**/
    addOptionalDrawObject(o) {
        if (this.mOptionalDrawElement.indexOf(o) >= 0)
            return;
        this.mOptionalDrawElement.push(o);
    }
    /**
     * オプショナル描画オブジェクトの削除**/
    removeOptionalDrawObject(o) {
        var i = this.mOptionalDrawElement.indexOf(o);
        if (i < 0)
            return;
        this.mOptionalDrawElement.splice(i, 1);
    }
    addAdditionalDrawingGeometry(g) {
        if (this.mAdditionalDrawGeoms.indexOf(g) >= 0)
            return;
        this.mAdditionalDrawGeoms.push(g);
    }
    removeAdditionalDrawingGeometry(g) {
        var i = this.mAdditionalDrawGeoms.indexOf(g);
        if (i < 0)
            return;
        this.mAdditionalDrawGeoms.splice(i, 1);
    }
    removeAllAdditionalDrawingGeometry() {
        this.mAdditionalDrawGeoms = [];
    }
    /**
     * @param dispGrid the dispGrid to set**/
    setDispGrid(dispGrid) {
        this.mDispGrid = dispGrid;
    }
    /**
     * @return the dispGrid**/
    isDispGrid() {
        return this.mDispGrid;
    }
    setDrawMode(b) {
        this.mDrawMode = b;
    }
    getDrawMode() {
        return this.mDrawMode;
    }
}
DefaultDrawData.DRAW_FULL = 0;
DefaultDrawData.DRAW_SIMPLE = 1;
DefaultDrawData.DRAW_LINE = 2;
//# sourceMappingURL=DefaultDrawData.js.map