import * as k from 'kiteclib';
import { Canvas2D } from './Canvas2D';
//module nethome.ui
export class DefaultCanvasDrawer {
    constructor() {
        this.gridColor1 = k.KColor.LIGHT_GRAY;
        this.gridColor2 = k.KColor.MORELIGHT_GRAY;
    }
    /**
     * 表示
     * @param g グラフィックスコンテキスト
    **/
    draw(data, rg) {
        this.drawGrid(data, rg);
        this.drawPlan(data, rg);
    }
    /**
     * 追加表示
     * @param g
    **/
    //protected drawAdditional(o: Project, g: IRichGraphics): void {
    //    let data = o as DefaultDrawData;
    //    data.mAdditionalDrawGeoms.forEach(geom => {
    //        geom.drawGeom(g);
    //    });
    //}
    /**
     * グリッドの表示
     * @param g グラフィックスコンテキスト
    **/
    drawGrid(data, rg) {
        let l = data.getCurrentLayer();
        if (!l)
            return;
        let ws = l.getWorkSheet();
        let area = ws.getArea();
        let minx, miny, maxx, maxy;
        if (rg instanceof k.AbstractRichGraphics) {
            let vp = rg.getViewPort();
            let size = rg.getSize();
            minx = vp.devToRealX(size, 0);
            miny = vp.devToRealY(size, 0);
            maxx = vp.devToRealX(size, size.width);
            maxy = vp.devToRealY(size, size.height);
        }
        else {
            minx = area.minX;
            miny = area.minY;
            maxx = area.maxX;
            maxy = area.maxY;
        }
        let xx = ws.getGridCenterX();
        let yy = ws.getGridCenterY();
        let minxc = ws.getNearNotExtraGrid(minx, xx, ws.getCurrentGrid()) - 1;
        let minyc = ws.getNearNotExtraGrid(maxy, yy, ws.getCurrentGrid()) - 1;
        let maxxc = ws.getNearNotExtraGrid(maxx, xx, ws.getCurrentGrid()) + 1;
        let maxyc = ws.getNearNotExtraGrid(miny, yy, ws.getCurrentGrid()) + 1;
        minx = xx + minxc * ws.getCurrentGrid();
        miny = yy + minyc * ws.getCurrentGrid();
        maxx = xx + maxxc * ws.getCurrentGrid();
        maxy = yy + maxyc * ws.getCurrentGrid();
        rg.setColor(k.KColor.WHITE);
        //if (fill)
        rg.drawFillRect(area.minX, area.minY, area.maxX, area.maxY, k.IRichGraphicsConst.LINE_1);
        let mDrawMode = data.getProjectInfo("DRAW_MODE");
        if (mDrawMode === undefined)
            mDrawMode = Canvas2D.DRAW_FULL;
        let dispgrid = data.getProjectInfo("DISP_GRID");
        if (dispgrid === undefined)
            dispgrid = true;
        let mc = this.gridColor1;
        let sc = this.gridColor2;
        let dash = false;
        if ((mDrawMode === Canvas2D.DRAW_LINE || mDrawMode === Canvas2D.DRAW_FULL) && dispgrid) {
            for (let i = minxc; i <= maxxc; i++) {
                let x = xx + i * ws.getCurrentGrid();
                let ddd = Math.abs((x - ws.getGridCenterX()) % ws.getModule());
                if (ddd < 1e-3 || Math.abs(ddd - ws.getModule()) < 1e-3) {
                    rg.setColor(mc);
                    if (!dash)
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_DASH_1);
                }
                else {
                    rg.setColor(sc);
                    if (!dash)
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_DASH_1);
                }
            }
            for (let i = minyc; i < maxyc; i++) {
                let y = yy + i * ws.getCurrentGrid();
                let ddd = Math.abs((y - ws.getGridCenterY()) % ws.getModule());
                if (ddd < 1e-3 || Math.abs(ddd - ws.getModule()) < 1e-3) {
                    rg.setColor(mc);
                    if (!dash)
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_DASH_1);
                }
                else {
                    rg.setColor(sc);
                    if (!dash)
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_1);
                    else
                        rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_DASH_1);
                }
            }
            let exX = ws.getExtraGridX();
            if (exX != null) {
                rg.setColor(mc);
                for (let i = 0; i < exX.length; i++) {
                    let x = exX[i];
                    if (x > minx && x < maxx) {
                        if (!dash)
                            rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_1);
                        else
                            rg.drawLine(x, miny, x, maxy, k.IRichGraphicsConst.LINE_DASH_1);
                    }
                }
            }
            let exY = ws.getExtraGridY();
            if (exY != null) {
                rg.setColor(mc);
                for (let i = 0; i < exY.length; i++) {
                    let y = exY[i];
                    if (y > miny && y < maxy) {
                        if (!dash)
                            rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_1);
                        else
                            rg.drawLine(minx, y, maxx, y, k.IRichGraphicsConst.LINE_DASH_1);
                    }
                }
            }
        }
    }
    //protected drawPreGridObject(data: Project, g: IRichGraphics): void {
    //}
    //protected drawPostGridObject(data: Project, g: IRichGraphics): void {
    //}
    /**
     * Projectの表示
     * @param g グラフィックスコンテキスト
    **/
    drawPlan(data, rg) {
        let l = data.getCurrentLayer();
        if (!l)
            return;
        for (let g of l.getPrims()) {
            g.drawGeom(rg);
        }
    }
    drawDynamic(data, rg) {
        //this.drawAdditional(data, rg);
        //this.drawOptionalObject(data, rg);
        this.drawSelectedObject(data, rg);
    }
    //protected drawOptionalObject(obj: Project, rg: IRichGraphics): void {
    //    var data = obj as DefaultDrawData;
    //    for (var i: number = 0; i < data.mOptionalDrawElement.length; i++) {
    //        var o = data.mOptionalDrawElement[i];
    //        if (o instanceof Geometry)
    //            o.drawGeom(g);
    //    }
    //}
    /**
     * 選択されたオブジェクトの描画**/
    drawSelectedObject(data, rg) {
        let l = data.getCurrentLayer();
        if (!l)
            return;
        for (let g of l.getSelectBuffer()) {
            g.drawHighLight(rg, k.KColor.GREEN, true);
        }
    }
}
//# sourceMappingURL=DefaultCanvasDrawer.js.map