import { MaskCommand, getModifiers } from './MaskCommand';
//module nethome.ui
/**
 * @author matsuzaki**/
export class CommandManager {
    /****/
    constructor() {
        this.mMaskCommands = [];
        this.mCommandCollection = [];
        //this.mKeyCommand = new ArrayList<AccelKey>();
    }
    /**
     * アクセラレーションコレクション **/
    //protected mKeyCommand: AccelKey[];
    static getInstance() {
        return CommandManager.mInstance;
    }
    /**
     * マスクイベントの設定
     * @param m
     * @param i
    **/
    registerMaskEvent(m, i) {
        this.mMaskCommands.push(new MaskCommand(m, i));
    }
    getMaskCommand(mod) {
        let m = getModifiers(mod);
        for (let i = 0, size = this.mMaskCommands.length; i < size; i++) {
            let mc = this.mMaskCommands[i];
            if (mc.matchMask(m))
                return mc.command;
        }
        return null;
    }
    /**
     * ユーザインターフェースのコレクションの取得
     * @return
    **/
    getCommandCollection() {
        return this.mCommandCollection;
    }
    /**
     * 特定のコマンドの取得
     * @param c
     * @return
     * @author kawae
     * @since 2004/10/17
    **/
    getCommand(c) {
        for (let i = 0; i < this.mCommandCollection.length; i++) {
            let com = this.mCommandCollection[i];
            if (com.constructor === c)
                return com;
        }
        return null;
    }
    /**
     * UIの初期化（主にファイルを読み込んだタイミング）**/
    initUserInterface() {
        this.mCommandCollection.forEach(cm => cm.initInterface());
    }
    /**
     * UIの更新（主に操作後のタイミング）**/
    updateUserInterface() {
        this.mCommandCollection.forEach(cm => cm.updateInterface());
    }
}
CommandManager.mInstance = new CommandManager();
//# sourceMappingURL=CommandManager.js.map