import { CommandManager } from './CommandManager';
//module nethome.ui
/**
 * 各種イベントをコマンドに振り分ける
 * @author matsuzaki
**/
export class CanvasCommandDispatcher {
    /****/
    constructor(can) {
        /**
         * アクティブなコマンド **/
        this.mActiveCommand = null;
        /**
         * アクティブなマスクコマンド **/
        this.mActiveMaskCommand = null;
        /**
         * 矢印キーコマンド **/
        this.mArrowCommand = null;
        /**
         * オペレーションが無い場合のコマンド **/
        this.mNullCommand = null;
        this.mCanvas = can;
        let dom = can.domElement;
        //dom.onbeforecopy = this.onbeforecopy.bind(this);
        //dom.onbeforecut = this.onbeforecut.bind(this);
        //dom.ondrag = this.ondrag.bind(this);
        //dom.ondragend = this.ondragend.bind(this);
        //dom.ondragenter = this.ondragenter.bind(this);
        //dom.ondragleave = this.ondragleave.bind(this);
        //dom.ondragover = this.ondragover.bind(this);
        //dom.ondragstart = this.ondragstart.bind(this);
        //dom.ondrop = this.ondrop.bind(this);
        //dom.onpaste = this.onpaste.bind(this);
        dom.onclick = this.onclick.bind(this);
        dom.ondblclick = this.ondblclick.bind(this);
        dom.onmousedown = this.onmousedown.bind(this);
        dom.onmouseenter = this.onmouseenter.bind(this);
        dom.onmouseleave = this.onmouseleave.bind(this);
        dom.onmousemove = this.onmousemove.bind(this);
        dom.onmouseout = this.onmouseout.bind(this);
        dom.onmouseover = this.onmouseover.bind(this);
        dom.onmouseup = this.onmouseup.bind(this);
        dom.onmousewheel = this.onmousewheel.bind(this);
        dom.onkeydown = this.onkeydown.bind(this);
        dom.onkeypress = this.onkeypress.bind(this);
        dom.onkeyup = this.onkeyup.bind(this);
    }
    /**
     * 現在アクティブなマスクコマンドの取得
     * @return the activeMaskCommand
    **/
    getActiveMaskCommand() {
        return this.mActiveMaskCommand;
    }
    /**
     * マスクコマンドをクリア**/
    clearMaskCommand() {
        this.mActiveMaskCommand = null;
    }
    /**
     * 現在アクティブなコマンドの取得
     * @return
     * @author kawae
    **/
    getMouseCommand() {
        return this.mActiveCommand;
    }
    /**
     * オペレーションが無い場合のコマンド**/
    setNullCommand(c) {
        this.mNullCommand = c;
        this.setMouseCommand(c);
    }
    /**
     * 矢印キーコマンドの設定**/
    setArrowKeyCommand(m) {
        this.mArrowCommand = m;
    }
    /**
     * ビューコントロールコマンドの設定
     * @param c
    **/
    setViewControlCommand(c) {
        this.mViewControlCommand = c;
    }
    /**
     * ビューコントロールコマンドの取得
     * @return
    **/
    getViewControlCommand() {
        return this.mViewControlCommand;
    }
    /**
     * ビューコントロールコマンドの更新**/
    updateViewControl() {
        if (this.mViewControlCommand != null)
            this.mViewControlCommand.updateInterface();
    }
    /**
     * アクティブコマンドの設定
     * @param c
    **/
    setMouseCommand(c) {
        if (this.mActiveCommand != null)
            this.mActiveCommand.end();
        if (c == null) {
            this.mActiveCommand = this.mNullCommand;
            if (this.mNullCommand != null) {
                this.mNullCommand.updateInterface();
                this.mNullCommand.play();
            }
        }
        else {
            this.mActiveCommand = c;
        }
        if (this.mActiveCommand != null) {
            this.mActiveCommand.canvas = this.mCanvas;
        }
        this.mCanvas.repaint();
    }
    /*
    onbeforecopy(ev: DragEvent): any {
    }
    onbeforecut(ev: DragEvent): any {
    }
    ondrag(ev: DragEvent): any {
    }
    ondragend(ev: DragEvent): any {
    }
    ondragenter(ev: DragEvent): any {
    }
    ondragleave(ev: DragEvent): any {
    }
    ondragover(ev: DragEvent): any {
    }
    ondragstart(ev: DragEvent): any {
    }
    ondrop(ev: DragEvent): any {
    }
    onpaste(ev: DragEvent): any {
    }
    */
    onclick(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onclick)
                this.mActiveMaskCommand.onclick(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onclick)
                this.mActiveCommand.onclick(ev);
        }
    }
    ondblclick(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.ondblclick)
                this.mActiveMaskCommand.ondblclick(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.ondblclick)
                this.mActiveCommand.ondblclick(ev);
        }
    }
    onmousedown(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmousedown)
                this.mActiveMaskCommand.onmousedown(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmousedown)
                this.mActiveCommand.onmousedown(ev);
        }
    }
    onmouseenter(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseenter)
                this.mActiveMaskCommand.onmouseenter(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseenter)
                this.mActiveCommand.onmouseenter(ev);
        }
    }
    onmouseleave(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseleave)
                this.mActiveMaskCommand.onmouseleave(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseleave)
                this.mActiveCommand.onmouseleave(ev);
        }
    }
    onmousemove(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmousemove)
                this.mActiveMaskCommand.onmousemove(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmousemove)
                this.mActiveCommand.onmousemove(ev);
        }
    }
    onmouseout(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseout)
                this.mActiveMaskCommand.onmouseout(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseout)
                this.mActiveCommand.onmouseout(ev);
        }
    }
    onmouseover(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseover)
                this.mActiveMaskCommand.onmouseover(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseover)
                this.mActiveCommand.onmouseover(ev);
        }
    }
    onmouseup(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmouseup)
                this.mActiveMaskCommand.onmouseup(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmouseup)
                this.mActiveCommand.onmouseup(ev);
        }
    }
    onmousewheel(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onmousewheel)
                this.mActiveMaskCommand.onmousewheel(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onmousewheel)
                this.mActiveCommand.onmousewheel(ev);
        }
    }
    onkeydown(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onkeydown)
                this.mActiveMaskCommand.onkeydown(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onkeydown)
                this.mActiveCommand.onkeydown(ev);
        }
        if (ev.defaultPrevented)
            return;
        let cm = CommandManager.getInstance();
        let c = cm.getMaskCommand(ev);
        if (c != this.mActiveMaskCommand) {
            if (this.mActiveMaskCommand)
                this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = c;
            if (this.mActiveMaskCommand) {
                if (this.mActiveCommand)
                    this.mActiveCommand.restoration();
                this.mActiveMaskCommand.canvas = this.mCanvas;
                this.mActiveMaskCommand.play();
            }
        }
    }
    onkeypress(ev) {
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onkeypress)
                this.mActiveMaskCommand.onkeypress(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onkeypress)
                this.mActiveCommand.onkeypress(ev);
        }
    }
    onkeyup(ev) {
        if (this.mActiveMaskCommand != null) {
            this.mActiveMaskCommand.end();
            this.mActiveMaskCommand = null;
        }
        if (this.mActiveMaskCommand != null) {
            if (this.mActiveMaskCommand.onkeyup)
                this.mActiveMaskCommand.onkeyup(ev);
        }
        else if (this.mActiveCommand != null) {
            if (this.mActiveCommand.onkeyup)
                this.mActiveCommand.onkeyup(ev);
        }
    }
}
//# sourceMappingURL=CanvasCommandDispatcher.js.map