import { KCursor } from 'kiteclib';
import { KDimension } from 'kiteclib';
import { KPoint2d } from 'kiteclib';
import { KColor } from 'kiteclib';
import { DefaultCanvasDrawer } from './DefaultCanvasDrawer';
import { CanvasCommandDispatcher } from './CanvasCommandDispatcher';
import { WRichGraphics } from '../web/WRichGraphics';
//module nethome.ui
/**
 * 描画クラス**/
export class Canvas2D {
    /**
     * コンストラクタ
     * @author kawae
     **/
    constructor(canvas) {
        //static MOUSE_CROSS = KCursor.CURSOR_HAIR;//: Cursor = new Cursor(Cursor.CROSSHAIR_CURSOR);
        /**
         * ドキュメント **/
        this.mDoc = null;
        /**
         * コマンドとイベント処理 **/
        this.mCommandDispatcher = null;
        //static mDefFont: KFont = KFont.getFont("Dialog", KFont.PLAIN, 12);
        /**
         * 背景色 **/
        this.mBackColor = KColor.SUPERLIGHT_GRAY;
        /**
         * 抽象キャンバス
         **/
        this.mAbstCanvas = new WRichGraphics();
        /**
         * ポップアップの位置
         **/
        //private mPopUpPos: Point;
        /**
         * 再描画の必要有り
         **/
        this.mNeedImageUpdate = true;
        this.domElement = canvas;
        this.mContext2D = this.domElement.getContext("2d");
        this.mCommandDispatcher = new CanvasCommandDispatcher(this);
        //this.setBackground(java.awt.Color.white);
        //this.addMouseListener(this);
        //this.addMouseMotionListener(this);
        //mPopup = new KPopupMenu();
        //mPopUpPos = new Point(0, 0);
        this.mCurrentMouse = new KPoint2d();
        //this.setFocusable(true);
        this.mDrawer = new DefaultCanvasDrawer();
        //this.mDrawData = new DefaultDrawData();
    }
    setEventHandler(c) {
        c.addEventListener("click", this.mCommandDispatcher.onclick);
    }
    getSize() {
        return new KDimension(this.domElement.clientWidth, this.domElement.clientHeight);
    }
    /**
     * 現在アクティブなコマンドの取得
     * @return
     * @author kawae
     **/
    getMouseCommand() {
        return this.mCommandDispatcher.getMouseCommand();
    }
    /**
     * オペレーションが無い場合のコマンド
     **/
    setNullCommand(c) {
        this.mCommandDispatcher.setNullCommand(c);
    }
    /**
     * 矢印キーコマンドの設定
     **/
    setArrowKeyCommand(m) {
        this.mCommandDispatcher.setArrowKeyCommand(m);
    }
    /**
     * ライブラリの整合性のため、マスクをクリア
     **/
    clearMaskCommand() {
        this.mCommandDispatcher.clearMaskCommand();
    }
    /**
     * ビューコントロールコマンドの設定
     * @param c
     **/
    setViewControlCommand(c) {
        this.mCommandDispatcher.setViewControlCommand(c);
    }
    /**
     * ビューコントロールコマンドの取得
     * @return
     **/
    getViewControlCommand() {
        return this.mCommandDispatcher.getViewControlCommand();
    }
    /**
     * ビューコントロールコマンドの更新
     **/
    updateViewControl() {
        this.mCommandDispatcher.updateViewControl();
    }
    /**
     * アクティブコマンドの設定
     * @param c
     **/
    setMouseCommand(c) {
        this.mCommandDispatcher.setMouseCommand(c);
        this.repaint();
    }
    getXdotlength(dot) {
        return dot / this.mAbstCanvas.getDotPerLen();
    }
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevX(x) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevX(this.getSize(), x);
    }
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevY(y) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevY(this.getSize(), y);
    }
    /**
     * 実座標から画面座標へ（ｘ）
     * @param x	実座標値
     * @return	デバイス座標値
    **/
    realToDevXd(x) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevXd(this.getSize(), x);
    }
    /**
     * 実座標から画面座標へ（ｙ）
     * @param y	実座標値
     * @return	デバイス座標値
    **/
    realToDevYd(y) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().realToDevYd(this.getSize(), y);
    }
    /**
     * 画面座標から実座標へ（ｘ）
     * @param x	デバイス座標値
     * @return		実座標値
    **/
    devToRealX(x) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().devToRealX(this.getSize(), x);
    }
    /**
     * 画面座標から実座標へ（ｙ）
     * @param y	デバイス座標値
     * @return		実座標値
    **/
    devToRealY(y) {
        //if (this.getSize() == null) return 0;
        return this.getViewPort().devToRealY(this.getSize(), y);
    }
    /**
     * ドキュメントのセット
     * @param d	ドキュメント
     **/
    setDocument(d) {
        this.mDoc = d;
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.resetView();
        d.addDocumentListener(this);
    }
    /**
     * ドキュメントの取得
     **/
    getDocument() {
        return this.mDoc;
    }
    /**
     * プロジェクトの取得
     **/
    getProject() {
        return this.mDoc.getProject();
    }
    setCursor(c) {
        //super.setCursor(CursorManager.getInstance().getCursor(c));
    }
    /**
     * コンテキストの現在の表示ステータス
     **/
    //private mDispContext: boolean = false;
    /**
     * コンテキストメニューを表示
     * @param x
     * @param y
    **/
    //showContext(x: number, y: number): void {
    //    let pi: KPopupMenu = this.getPopupMenu();
    //    mPopUpPos.setLocation(x, y);
    //    if (pi != null) pi.show(this, x, y);
    //    mDispContext = true;
    //}
    /**
     * コンテキストメニューの取得
     * @return
    **/
    //getPopupMenu(): KPopupMenu {
    //    return mPopup;
    //}
    /**
     * ポップアップの位置の取得
     * @return
     * @author kawae
     * @since 2005/03/23
    **/
    //getPopupPos(): KPoint2d {
    //    return this.mPopUpPos;
    //}
    //endContext(): void {
    //    this.mDispContext = false;
    //    this.requestFocus();
    //}
    /**
     * コンテキストメニューが表示されているかを確認
     * @return　表示:true
     * 　　　　　非表示:false
    **/
    //isShowContext(): boolean {
    //    return mDispContext;
    //}
    //getKSize(): KDimension {
    //    return new KDimension(this.getSize().width, this.getSize().height);
    //}
    save(of) {
    }
    load(of) {
    }
    /**
     * ビューの更新
     * @author kawae
     * @since 2004/10/02
    **/
    updateView() {
        this.mAbstCanvas.setViewPort(this.getViewPort());
        this.updateImage();
        this.repaint();
    }
    /**
     * ビューポートの取得**/
    getViewPort() {
        return this.mAbstCanvas.getViewPort();
    }
    /**
     * スケールの設定
     * @param f　対象スケール(%指定。100が標準)
    **/
    setZoomAsScale(f) {
        let prj = this.mDoc.getProject();
        let vp = this.mAbstCanvas.getViewPort();
        let size = this.mAbstCanvas.getSize();
        if (vp != null && size != null) {
            let module = prj.getCurrentLayer().getWorkSheet().getModule();
            let a = prj.getCurrentLayer().getWorkSheet().getArea();
            let defw = ((a.maxX + module) - (a.minX - module));
            let defh = ((a.maxY + module) - (a.minY - module));
            let rw = defw / size.width;
            let rh = defh / size.height;
            let wx = module / 10;
            let wy = module / 10;
            if (rw > rh) {
                wx = defw * 100 / f / 2;
            }
            else {
                wy = defh * 100 / f / 2;
            }
            this.mAbstCanvas.setView(vp.getCx() - wx, vp.getCy() - wy, vp.getCx() + wx, vp.getCy() + wy);
        }
    }
    /**
     * 現在のズームレシオの取得
     * @return	表示％
     **/
    getZoomRatio() {
        let vp = this.getViewPort();
        if (vp == null)
            return 0;
        let prj = this.mDoc.getProject();
        let size = this.mAbstCanvas.getSize();
        if (size == null)
            return 100;
        let a = prj.getCurrentLayer().getWorkSheet().getArea();
        let module = prj.getCurrentLayer().getWorkSheet().getModule();
        let defw = (a.maxX + module) - (a.minX - module);
        let defh = (a.maxY + module) - (a.minY - module);
        let rw = defw / size.width;
        let rh = defh / size.height;
        let cp;
        let len;
        if (rw > rh) {
            let x1 = this.mAbstCanvas.devToRealX(0);
            let x2 = this.mAbstCanvas.devToRealX(size.width);
            len = x2 - x1;
            cp = defw;
        }
        else {
            let y1 = this.mAbstCanvas.devToRealY(size.height);
            let y2 = this.mAbstCanvas.devToRealY(0);
            len = y2 - y1;
            cp = defh;
        }
        return (cp / len) * 100;
    }
    /**
     * ワークシートの取得
     * @return
    **/
    getWorkSheet() {
        let prj = this.mDoc.getProject();
        if (prj != null)
            return prj.getCurrentLayer().getWorkSheet();
        return null;
    }
    /**
     * 描画のリセット**/
    resetView() {
        let vp = this.getViewPort();
        if (vp != null) {
            let prj = this.mDoc.getProject();
            let l = prj.getCurrentLayer();
            if (l) {
                let module = l.getWorkSheet().getModule();
                let a = prj.getCurrentLayer().getWorkSheet().getArea();
                vp.resetViewPort(a.minX, a.minY, a.maxX, a.maxY, module);
                this.mAbstCanvas.setView(vp.getX1(), vp.getY1(), vp.getX2(), vp.getY2(), this.mAbstCanvas.getSize());
            }
            this.updateImage();
            this.repaint();
        }
    }
    //setDispGrid(b: boolean): void {
    //    this.mDispGrid = b;
    //    this.updateImage();
    //    this.repaint();
    //}
    //displaysGrid(): boolean {
    //    return this.mDispGrid;
    //}
    ///**
    // * シンプル表示フラグ
    // **/
    //private mDrawMode: number = Canvas2D.DRAW_FULL;
    //setDrawMode(b: number): void {
    //    this.mDrawMode = b;
    //}
    //getDrawMode(): number {
    //    return this.mDrawMode;
    //}
    /**
     * 前回描画からCanvasサイズが更新されているか確認
     * @return 変更有:true　変更無:false
    **/
    isChangeCanvasSize() {
        if (this.mBufferImage == null || this.mBufferGraphics == null)
            return true;
        else if (this.mAbstCanvas.getSize().width != this.mBufferImage.width
            || this.mAbstCanvas.getSize().height != this.mBufferImage.height)
            return true;
        return false;
    }
    paintComponent() {
        if (this.mDoc == null)
            return;
        this.createOffGraphics();
        if (this.mNeedImageUpdate || this.isChangeCanvasSize()) {
            this.updateImageBuffer();
            this.mNeedImageUpdate = false;
        }
        this.mAbstCanvas.updateViewScale(this.mAbstCanvas.getSize());
        this.mContext2D.clearRect(0, 0, this.domElement.width, this.domElement.height);
        this.drawPlan();
        this.mAbstCanvas.ctx = this.mContext2D;
        if (this.mCommandDispatcher.getActiveMaskCommand() != null)
            this.mCommandDispatcher.getActiveMaskCommand().drawCommand(this.mAbstCanvas);
        if (this.mCommandDispatcher.getMouseCommand() != null)
            this.mCommandDispatcher.getMouseCommand().drawCommand(this.mAbstCanvas);
        //super.paintComponent(this.mOffGraphics);
        this.mAbstCanvas.ctx = null;
        //g.drawImage(this.mContext2D, 0, 0);
    }
    /**
     * バッファの内容と、その他状況依存描画オブジェクトの描画。
     **/
    drawPlan() {
        this.mAbstCanvas.ctx = this.mContext2D;
        this.mContext2D.drawImage(this.mBufferImage, 0, 0);
        this.mDrawer.drawDynamic(this.mDoc.getProject(), this.mAbstCanvas);
        this.mAbstCanvas.ctx = null;
    }
    /**
     * オフスクリーングラフィックスの作成 オフイメージがnull,又はオフイメージと現在のサイズに 変化があった場合、オフイメージ、オフグラフィックスを 再作成する。
     **/
    createOffGraphics() {
        this.mAbstCanvas.setSize(this.getSize().width, this.getSize().height);
        // let size: KDimension = this.mAbstCanvas.getSize();
        // if (this.mOffImage == null) {
        //     this.mOffImage = document.createElement("canvas");
        // }
        // if (this.mOffImage.width != size.width || this.mOffImage.height != size.height) {
        //     this.mOffImage.width = size.width;
        //     this.mOffImage.height = size.height;
        //     this.mOffGraphics = this.mOffImage.getContext("2d");
        // }
    }
    /**
     * 再作図を要求する。 再作図フラグを立て、次回描画時に実際の処理。**/
    updateImage() {
        this.mNeedImageUpdate = true;
    }
    /****/
    updateImageBuffer() {
        let size = this.mAbstCanvas.getSize();
        this.mAbstCanvas.updateViewScale(size);
        //if (this.mBufferImage != null && this.mBufferGraphics != null) {
        //    let w: number = this.mBufferImage.getWidth(this);
        //    let h: number = this.mBufferImage.getHeight(this);
        //    if (size.width != w || size.height != h) {
        //        this.mBufferImage.flush();
        //        this.mBufferGraphics.dispose();
        //        this.mBufferGraphics = null;
        //        this.mBufferImage = null;
        //    }
        //}
        if (this.mBufferImage == null) {
            this.mBufferImage = document.createElement("canvas");
            this.mBufferGraphics = this.mBufferImage.getContext("2d");
        }
        this.mBufferImage.width = size.width;
        this.mBufferImage.height = size.height;
        this.mBufferGraphics.clearRect(0, 0, size.width, size.height);
        this.mAbstCanvas.ctx = this.mBufferGraphics;
        this.mAbstCanvas.setColor(this.mBackColor);
        let x1 = this.mAbstCanvas.devToRealX(-1);
        let y1 = this.mAbstCanvas.devToRealY(-1);
        let x2 = this.mAbstCanvas.devToRealX(size.width + 2);
        let y2 = this.mAbstCanvas.devToRealY(size.height + 2);
        this.mAbstCanvas.drawFillRect(x1, y1, x2, y2, null);
        //this.mDrawData.setDispGrid(this.mDispGrid);
        //this.mDrawData.setDrawMode(this.mDrawMode);
        this.mDrawer.draw(this.mDoc.getProject(), this.mAbstCanvas);
        this.mAbstCanvas.ctx = null;
    }
    /**
     * 強制描画
     * @param g
    **/
    //protected paintCurrentBuffer(g: WRichGraphics): void {
    //    g.drawBufferImage(this.mBufferImage);
    //}
    /**
     * カレントのマウス位置の取得**/
    getCurrentMousePos() {
        return this.mCurrentMouse;
    }
    //mouseWheelMoved(e: MouseWheelEvent): void {
    //    if (e.getUnitsToScroll() < 0)
    //        mCommandDispatcher.mouseWheelUp(e.getX(), e.getY(), e.getModifiers());
    //    else
    //        mCommandDispatcher.mouseWheelDown(e.getX(), e.getY(), e.getModifiers());
    //}
    /**
     * 現在のマウス座標の設定
     * @param e	マウスイベント
    **/
    updateCurrentMousePos(x, y, modifiers) {
        this.mCurrentMouse.x = x;
        this.mCurrentMouse.y = y;
    }
    //mouseClicked(e: MouseEvent): void {
    //    this.requestFocusInWindow();
    //    mCommandDispatcher.mouseClicked(e.getX(), e.getY(), e.getModifiers());
    //}
    //mousePressed(e: MouseEvent): void {
    //    mCommandDispatcher.mousePressed(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseReleased(e: MouseEvent): void {
    //    mCommandDispatcher.mouseReleased(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseDragged(e: MouseEvent): void {
    //    mCommandDispatcher.mouseDragged(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseMoved(e: MouseEvent): void {
    //    mCommandDispatcher.mouseMoved(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseEntered(e: MouseEvent): void {
    //    mCommandDispatcher.mouseEntered(e.getX(), e.getY(), e.getModifiers());
    //}
    //mouseExited(e: MouseEvent): void {
    //    mCommandDispatcher.mouseExited(e.getX(), e.getY(), e.getModifiers());
    //}
    //keyPress(e: KeyEvent): void {
    //    mCommandDispatcher.keyPress(e.getKeyCode(), e.getModifiers());
    //}
    //keyRelease(e: KeyEvent): void {
    //    mCommandDispatcher.keyRelease(e.getKeyCode(), e.getModifiers());
    //}
    documentChanged(e) {
        this.updateImage();
        this.repaint();
    }
    repaint() {
        this.paintComponent();
    }
}
Canvas2D.DRAW_FULL = 0;
Canvas2D.DRAW_SIMPLE = 1;
Canvas2D.DRAW_LINE = 2;
Canvas2D.MOUSE_DEF = KCursor.CURSOR_DEF; //: Cursor = new Cursor(Cursor.DEFAULT_CURSOR);
Canvas2D.MOUSE_WAIT = KCursor.CURSOR_WAIT; //: Cursor = new Cursor(Cursor.WAIT_CURSOR);
Canvas2D.MOUSE_MOVE = KCursor.CURSOR_MOVE; //: Cursor = new Cursor(Cursor.MOVE_CURSOR);
Canvas2D.MOUSE_HAND = KCursor.CURSOR_HAND; //: Cursor = new Cursor(Cursor.HAND_CURSOR);
//# sourceMappingURL=Canvas2D.js.map