import { FileSystem } from 'kiteclib';
import { DocumentFactory } from '../doc/DocumentFactory';
export interface ApplicationCore {
    /**
     * ファイルシステムの取得
     * @param s	取得するパス
     * @param types 取得する拡張子群
    **/
    getResourceFileSystem(s: string, types: string[]): FileSystem;
    /**
     * アプリケーション起動パラメータの取得
     * @param s
     * @return
     * @author kawae
     * @since 2004/10/15
    **/
    getApplicationParameter(s: string): string;
    /**
     * ドキュメントファクトリーの取得
     * @return
    **/
    getDocumentFactory(): DocumentFactory;
}
