//module nethome.ui
export class AbstractNethomeRuntime {
    constructor() {
        this.mLibrary = new Map();
    }
    /**
     * ユーザファイルシステムの設定
     **/
    setFileSystem(fs) {
        this.mFileSystem = fs;
    }
    /**
     * ユーザファイルシステムの取得
     * @return
     **/
    getFileSystem() {
        return this.mFileSystem;
    }
    /**
     * ライブラリの登録
     * @param key
     * @param lib
     **/
    registerLibrary(key, lib) {
        if (key != null && lib != null)
            this.mLibrary.set(key, lib);
    }
    /**
     * ライブラリの取得
     * @param key
     * @return
     **/
    getLibrary(key) {
        return this.mLibrary.get(key);
    }
}
//# sourceMappingURL=AbstractNethomeRuntime.js.map