import { ObjectNode } from 'kiteclib';
import { KFont } from 'kiteclib';
import { KColor } from 'kiteclib';
import { UtilString } from 'kiteclib';
import { NethomeCoreResource } from '../../NethomeCoreResource';
//module nethome.geom.rich
/**
 * テキストの最小単位
 * @author kawae
 * @since 2004/11/13
**/
export class KTextElement {
    /**
     * コンストラクタ
     * @author kawae
     * @since 2004/11/14
    **/
    constructor() {
    }
    /**
     * テキストの設定
     * @param text
     * @author kawae
     * @since 2004/11/13
    **/
    setText(text) {
        this.mText = UtilString.tab2space(text);
    }
    getText() {
        return this.mText;
    }
    getBackColor() {
        return this.mBackColor;
    }
    getFontName() {
        return this.mFontname;
    }
    getFontSize() {
        return this.mFontsize;
    }
    getFontStyle() {
        return this.mFontstyle;
    }
    getTextColor() {
        return this.mTextColor;
    }
    isSameTextFormat(tf) {
        if (UtilString.isDiff(this.getFontName(), tf.getFontName()))
            return false;
        if (this.getFontStyle() != tf.getFontStyle())
            return false;
        if (Math.abs(this.getFontSize() - tf.getFontSize()) > 1e-3)
            return false;
        if (KColor.isDiff(this.getTextColor(), tf.getTextColor()))
            return false;
        if (KColor.isDiff(this.getBackColor(), tf.getBackColor()))
            return false;
        if (this.isUnderLine() != tf.isUnderLine())
            return false;
        return true;
    }
    isUnderLine() {
        return this.mIsUnderline;
    }
    setBackColor(c) {
        this.mBackColor = c;
    }
    setFontName(s) {
        this.mFontname = s;
    }
    setFontSize(f) {
        this.mFontsize = f;
    }
    setFontStyle(style) {
        this.mFontstyle = style;
    }
    setFormat(f) {
        this.setBackColor(f.getBackColor());
        this.setTextColor(f.getTextColor());
        this.setFontName(f.getFontName());
        this.setFontSize(f.getFontSize());
        this.setFontStyle(f.getFontStyle());
        this.setUnderLine(f.isUnderLine());
    }
    setTextColor(c) {
        this.mTextColor = c;
    }
    setUnderLine(flag) {
        this.mIsUnderline = flag;
    }
    /**
     * 保存
     * @param savenode
     * @author kawae
     * @since 2004/11/17
     * @see nethome.text.ITextFormat#save(jp.kitec.lib.util.tree.ObjectFolder)
    **/
    save(savenode) {
        if (savenode == null)
            return;
        savenode.setName(KTextElement.GEOMNAME);
        savenode.addNode("text", this.mText);
        savenode.addNode("textsize", this.mFontsize);
        savenode.addNode("textfont", this.mFontname);
        savenode.addNode("textstyle", this.mFontstyle);
        savenode.addNode("underline", this.mIsUnderline);
        if (this.mTextColor != null)
            savenode.addChild(new ObjectNode("textcolor", KColor.getColorRGBString(this.mTextColor)));
        if (this.mBackColor != null)
            savenode.addChild(new ObjectNode("backcolor", KColor.getColorRGBString(this.mBackColor)));
    }
    /**
     * 読み込み
     * @param of
     * @param tl
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    static readData(of, tl) {
        var on = null;
        if (ObjectNode.isStringObject(on = of.getNode("text")))
            tl.mText = UtilString.tab2space(ObjectNode.getNodeString(on));
        if (ObjectNode.isStringObject(on = of.getNode("textfont")))
            tl.mFontname = ObjectNode.getNodeString(on);
        if (ObjectNode.isFloatObject(on = of.getNode("textsize")))
            tl.mFontsize = ObjectNode.getNodeFloat(on);
        if (ObjectNode.isBoolObject(on = of.getNode("underline")))
            tl.mIsUnderline = ObjectNode.getNodeBool(on);
        if (ObjectNode.isIntObject(on = of.getNode("textstyle")))
            tl.mFontstyle = on.getInt();
        if ((on = of.getNode("textcolor")) != null)
            tl.mTextColor = KColor.getColorFromRGBString(on.getString());
        if ((on = of.getNode("backcolor")) != null)
            tl.mBackColor = KColor.getColorFromRGBString(on.getString());
        return tl;
    }
    /**
     * フォントの取得
     * @return
     * @author kawae
     * @since 2004/11/17
    **/
    getFont() {
        return KFont.getFont(this.getFontName(), this.getFontStyle(), this.getFontSize());
    }
    /**
     * 最大幅の取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/14
     * @version 2006/01/05縦書き対応
    **/
    getMaxWidth(hor, dpi) {
        var total = 0;
        var str = this.getText();
        var f = KFont.getFont(this.getFontName(), this.getFontStyle(), dpi.getDpiScaleSize(this.getFontSize()));
        var fm = f.getFontMetrics(null);
        if (hor) {
            return (Math.ceil(fm.stringWidth(str) * 1000) / 1000);
        }
        else {
            for (var i = 0; i < str.length; i++) {
                var s = str.substring(i, i + 1);
                var ww = 0;
                if (NethomeCoreResource.TATE_STRING.indexOf(s) >= 0)
                    ww = (Math.ceil((fm.getDescent() + fm.getAscent()) * 1000) / 1000);
                else
                    ww = (Math.ceil(fm.stringWidth(s) * 1000) / 1000);
                total = total < ww ? ww : total;
            }
        }
        return total;
    }
    /**
     * 最大高さの取得
     * @param hor
     * @return
     * @author kawae
     * @since 2004/11/14
     * @version 2006/01/05縦書き対応
    **/
    getMaxHeight(hor, dpi) {
        var height = 0;
        var dpiScaleSize = dpi.getDpiScaleSize(this.getFontSize());
        var f = KFont.getFont(this.getFontName(), this.getFontStyle(), dpiScaleSize);
        var fm = f.getFontMetrics(null);
        if (hor) {
            height = Math.ceil((fm.getDescent() + fm.getAscent()) * 1000) / 1000;
            if (height < dpiScaleSize / 5) {
                height = dpiScaleSize;
            }
        }
        else {
            var str = this.getText();
            for (var i = 0; i < str.length; i++) {
                var s = str.substring(i, i + 1);
                if (NethomeCoreResource.TATE_STRING.indexOf(s) >= 0)
                    height += (Math.ceil(fm.stringWidth(s) * 1000) / 1000);
                else
                    height += (Math.ceil((fm.getDescent() + fm.getAscent()) * 1000) / 1000);
            }
        }
        return height;
    }
    getCopy() {
        var c = new KTextElement();
        c.mText = this.mText;
        c.mFontname = this.mFontname;
        c.mFontsize = this.mFontsize;
        c.mIsUnderline = this.mIsUnderline;
        ;
        c.mFontstyle = this.mFontstyle;
        c.mTextColor = this.mTextColor;
        c.mBackColor = this.mBackColor;
        return c;
    }
}
KTextElement.GEOMNAME = "TEXT_ELEMENT";
//# sourceMappingURL=KTextElement.js.map