//module nethome.geom.primitive
/**
 * 移動拡大のみのlocalAxis
 * @since 2007/10/12
 * @author kamimura
 * @version 2007/10/12
**/
export class LocalAxis2dfs {
    /**
     * コンストラクタ.
     * @since 2007/10/12
     * @author kamimura
    **/
    constructor() {
        this.mKx = this.mKy = 1;
        this.mMx = this.mMy = 0;
    }
    /**
     * @param kx
     * @param ky
     * @param mx
     * @param my
     * @since 2007/10/12
     * @author kamimura
     * @version 2007/10/12
    **/
    setCoordinates(kx, ky, mx, my) {
        this.mKx = kx;
        this.mKy = ky;
        this.mMx = mx;
        this.mMy = my;
    }
    /**
     * @param x
     * @param y
     * @since 2007/10/12
     * @author kamimura
     * @version 2007/10/12
    **/
    setMXY(x, y) {
        this.mMx = x;
        this.mMy = y;
    }
    getKx() {
        return this.mKx;
    }
    getKy() {
        return this.mKy;
    }
    getMx() {
        return this.mMx;
    }
    getMy() {
        return this.mMy;
    }
    getGlobalX(x, y) {
        return this.mKx * x + this.mMx;
    }
    getGlobalY(x, y) {
        return this.mKy * y + this.mMy;
    }
    getLocalX(x, y) {
        return (x - this.mMx) / this.mKx;
    }
    getLocalY(x, y) {
        return (y - this.mMy) / this.mKy;
    }
    getGlobalAngl(rad) {
        return 0;
    }
}
//# sourceMappingURL=LocalAxis2dfs.js.map