import { KArea } from 'kiteclib';
import { KColor } from 'kiteclib';
import { KLineType } from 'kiteclib';
import { IRichGraphics } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { Ltype } from '../Ltype';
import { GeomParser } from '../GeomParser';
import { GPoint2Df } from './GPoint2Df';
import { LocalAxis2Df } from '../LocalAxis2Df';
import { AreaControl } from '../AreaControl';
/**
 * すべての幾何オブジェクトの基底クラス
 * @author kawae
**/
export declare abstract class Geometry {
    /**
     * 通常移動ステータス **/
    static CTRL_NODE_STATE_DEF: number;
    /**
     * フリー移動ステータス **/
    static CTRL_NODE_STATE_FREE: number;
    /**
     * 幾何ID **/
    mGid: number;
    /**
     * 幾何名
     **/
    private mGeomName;
    /**
     * 線種 **/
    lineType: Ltype;
    /**
     * 形状色 **/
    mGeomColor: KColor;
    /**
     * 領域 **/
    area: KArea;
    /**
     * 領域のコントロールオブジェクト **/
    areaControl: AreaControl;
    /**
     * X方向へのスケーリングの許可 **/
    scaleEnX: boolean;
    /**
     * Y方向へのスケーリングの許可 **/
    scaleEnY: boolean;
    /**
     * アスペクト比一定のフラグ **/
    mKeepAspect: boolean;
    /**
     * スケーリングの基点X **/
    scaleBaseX: number;
    /**
     * スケーリングの基点Y **/
    scaleBaseY: number;
    /**
     * コンストラクタ**/
    constructor(geomName?: string);
    /**
     * 幾何名の取得
     * @return Returns the mGeomName.
     * @author kawae
     * @since 2003/01/01
    **/
    getGeomName(): string;
    setGeomName(name: string): void;
    /**
     * 幾何IDの設定
     * @author kawae
     * @since 2003/01/01
    **/
    setID(id: number): void;
    /**
     * 幾何IDの取得
     * @author kawae
     * @since 2003/01/01
    **/
    getID(): number;
    /**
     * エリアの取得
     * @author kawae
     * @since 2003/01/01
    **/
    getArea(): KArea;
    /**
     * 最大・最小領域の更新
     * @author kawae
     * @since 2003/01/01
    **/
    updateMinMax(area: KArea): void;
    /**
     * エリアコントロールの取得
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    getAreaControl(): AreaControl;
    /**
     * コピーインスタンスの取得
     * @author kawae
     * @since 2003/01/01
    **/
    copy(): Geometry;
    /**
     * コピーインスタンスの取得
     * 引数インスタンスに対し属性をコピーする
     * @param g　コピー属性設定対象オブジェクト
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    copyTo(g: Geometry): Geometry;
    /**
     * 一番近い構成点の取得
     * @param x	対象計測点X座標
     * @param y	対象計測点Y座標
     * @author kawae
     * @since 2003/01/01
    **/
    getNearNode(x: number, y: number): GPoint2Df;
    /**
     * 幾何形状までの距離の取得
     * @param x	距離計測点X座標
     * @param y	距離計測点Y座標
     * @return	幾何形状までの距離。計測不能な場合は負を返す
     * @author kawae
     * @since 2003/01/01
    **/
    getDistanceToPoint(x: number, y: number): number;
    /**
     * 幾何データ共通属性データの読み込み
     * @param datanode		読み込み対象ノード
     * @param geom			設定対象幾何インスタンス
     * @throws Exception
     * @author kawae
     * @since 2003/01/01
    **/
    static readData(datanode: ObjectFolder, geom: Geometry, ps: GeomParser): void;
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    save(savenode: ObjectFolder): void;
    /**
     * 幾何の移動
     * @param x	X方向移動量
     * @param y	Y方向移動量
     * @author kawae
     * @since 2003/01/01
    **/
    offset(x: number, y: number): void;
    /**
     * 幾何の回転
     * @param xc		回転中心X座標
     * @param yc		回転中心Y座標
     * @param angl	回転角度
     * @author kawae
     * @since 2003/01/01
    **/
    rotate(xc: number, yc: number, angl: number): void;
    /**
     * 幾何の回転
     * @param xc		回転中心X座標
     * @param yc		回転中心Y座標
     * @param ofsx
     * @param ofsy
     * @param angl	回転角度
     * @author kawae
     * @since 2003/01/01
    **/
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
    /**
     * X軸方向反転
     * @param x		反転軸X座標
     * @param ofsx
     * @author kawae
     * @since 2003/01/01
    **/
    flipx(x: number, ofsx: number): void;
    /**
     * Y軸方向反転
     * @param y		反転軸Y座標
     * @param ofsx
     * @author kawae
     * @since 2003/01/01
    **/
    flipy(y: number, ofsy: number): void;
    /**
     * 領域内に幾何が存在するか確認
     * @param minx	領域左下X座標
     * @param miny	領域左下Y座標
     * @param maxx	領域右上X座標
     * @param maxy	領域右上Y座標
     * @author kawae
     * @since 2003/01/01
    **/
    isInner(minx: number, miny: number, maxx: number, maxy: number): boolean;
    /**
     * 形状色の設定
     * @param c	設定する色
     * @author kawae
     * @since 2003/01/01
    **/
    setGeomColor(c: KColor): void;
    /**
     * 形状色の取得
     * @return		幾何色
     * @author kawae
     * @since 2003/01/01
    **/
    getGeomColor(): KColor;
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    /**
     * 指定色で描画
     * @param d	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @author kawae
     * @since 2003/01/01
    **/
    drawGeom(d: IRichGraphics, fore?: KColor, back?: KColor): void;
    /**
     * ローカル座標系での通常描画
     * @param d	描画インターフェース
     * @param la	描画座標
     * @author kawae
     * @since 2004/09/24
    **/
    /**
     * 最終描画
     * @param d	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @param la	描画座標
     * @author kawae
     * @since 2004/09/24
    **/
    drawAbstDevice(d: IRichGraphics, fore?: KColor, back?: KColor, la?: LocalAxis2Df): void;
    /**
     * ハイライト描画
     * @param rg	描画インターフェース
     * @param c		幾何描画色
     * @author kawae
     * @since 2003/01/01
    **/
    drawHighLight(rg: IRichGraphics, c: KColor, outline: boolean): void;
    /**
     * 遷移状態の描画
     * @param rg	描画インターフェース
     * @param lt	描画座標
     * @author kawae
     * @since 2003/01/01
    **/
    drawTransition(rg: IRichGraphics, col: KColor, lt: KLineType): void;
    /**
     * タイトルの描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    /**
     * 指定色でタイトルを描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    drawTitle(d: IRichGraphics, c?: KColor): void;
    /**
     * ローカル座標系での描画
     * @param rg	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @param la	描画座標
     * @author kawae
     * @since 2003/01/01
    **/
    drawAlias(rg: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    /**
     * 幾何形状の更新
     * @author kawae
     * @since 2003/01/01
    **/
    updateShape(): void;
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
     * @author kawae
     * @since 2003/01/01
    **/
    getNearControlPoint(x: number, y: number): Object;
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
     * @author kawae
     * @since 2003/01/01
    **/
    moveControlPoint(cp: Object, x: number, y: number): void;
    /**
     * コントロールノードのステータスの取得
     * @param o
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    getCtrlNodeStatus(o: Object): number;
}
