import { KColor } from 'kiteclib';
import { MathUtil } from 'kiteclib';
import { GPoint2Df } from './GPoint2Df';
import { Geometry } from './Geometry';
import { NethomeCoreResource } from '../../NethomeCoreResource';
//module nethome.geom.primitive
export class GText extends Geometry {
    /**
     * コンストラクタ**/
    //constructor() {
    //    super();
    //}
    /**
     * コンストラクタ
     * @param p1
     * @param scaleFontLabel
     * @param text
     * @param angl
     * @param size
     * @param bold
    **/
    constructor(p1 = null, scaleFontLabel = null, text = "", angl = 0, size = 0, bold = false) {
        super(GText.GEOMNAME);
        /**
         * 描画方向 (true:横)
         **/
        this.mDir = true;
        /**
         * 背景の塗り潰しモード
         **/
        this.mFillBack = false;
        /**
         * 太字
         **/
        this.mBold = false;
        this.mCp = new GPoint2Df();
        if (p1)
            this.mCp.setXY(p1.x, p1.y);
        this.mAngl = angl;
        this.mText = text;
        this.mSize = size;
        this.mScaleFontName = scaleFontLabel;
        this.mBold = bold;
        this.mGeomColor = KColor.BLACK;
    }
    /**
     * 塗り潰しモードの指定
     * @param fill
     * @param fillColor
    **/
    setFillMode(fill, fillColor) {
        this.mFillBack = fill;
        this.mFillColor = fillColor;
    }
    /****/
    updateMinMax(area) {
        area.updateMinMax(this.mMinx, this.mMiny);
        area.updateMinMax(this.mMaxx, this.mMaxy);
    }
    copy() {
        return this.copyTo(new GText());
    }
    copyTo(g) {
        if (g == null || !(g instanceof GText))
            return null;
        var gt = (g);
        super.copyTo(gt);
        gt.mCp = this.mCp.copy();
        gt.mAngl = this.mAngl;
        gt.mText = this.mText;
        gt.mSize = this.mSize;
        gt.mScaleFontName = this.mScaleFontName;
        gt.mBold = this.mBold;
        gt.setFillMode(this.mFillBack, this.mFillColor);
        gt.mDir = this.mDir;
        return gt;
    }
    getDistanceToPoint(x, y) {
        if (x > this.mMinx && x < this.mMaxx && y > this.mMiny && y < this.mMaxy)
            return 0;
        var len = Number.MAX_VALUE;
        var tmp;
        tmp = MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMinx, this.mMiny, this.mMaxx, this.mMiny);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        tmp = MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMaxx, this.mMiny, this.mMaxx, this.mMaxy);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        tmp = MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMaxx, this.mMaxy, this.mMinx, this.mMaxy);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        tmp = MathUtil.getLengthLimitLineToPoint2D(x, y, this.mMinx, this.mMaxy, this.mMinx, this.mMiny);
        if (tmp >= 0)
            len = Math.min(tmp, len);
        return len;
    }
    offset(x, y) {
        this.mMinx += x;
        this.mMiny += y;
        this.mMaxx += x;
        this.mMaxy += y;
        this.mCp.x += x;
        this.mCp.y += y;
    }
    rotate(xc, yc, angl) {
        this.mCp.rotate(xc, yc, angl);
        this.mAngl += angl;
    }
    isInner(minx, miny, maxx, maxy) {
        if (this.mMinx >= minx && this.mMaxx <= maxx && this.mMiny >= miny && this.mMaxy <= maxy)
            return true;
        return false;
    }
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    return ToolPolygon.isInnerPolygon(v, this.mMinx, this.mMiny) && ToolPolygon.isInnerPolygon(v, this.mMaxx, this.mMaxy);
    //}
    /**
     * 描画方向の設定**/
    setDir(dir) {
        this.mDir = dir;
    }
    isDir() {
        return this.mDir;
    }
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode) {
        if (savenode == null)
            return;
        super.save(savenode);
        savenode.addNode("x", this.mCp.x);
        savenode.addNode("y", this.mCp.y);
        savenode.addNode("scalefontname", this.mScaleFontName);
        savenode.addNode("string", this.mText);
        savenode.addNode("angl", this.mAngl);
        savenode.addNode("textsize", this.mSize);
        savenode.addNode("dir", this.mDir);
        savenode.addNode("fillback", this.mFillBack);
        savenode.addNode("bold", this.mBold);
    }
    drawHighLight(d, c, outline) {
        GPoint2Df.drawHighLight(d, c, this.mMinx, this.mMiny);
        GPoint2Df.drawHighLight(d, c, this.mMaxx, this.mMiny);
        GPoint2Df.drawHighLight(d, c, this.mMaxx, this.mMaxy);
        GPoint2Df.drawHighLight(d, c, this.mMinx, this.mMaxy);
    }
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, this.mGeomColor, this.mFillColor);
    //}
    drawGeom(d, fore, back) {
        if (fore == null)
            fore = this.mGeomColor;
        if (back == null)
            back = this.mFillColor;
        this.drawAbstDevice(d, fore, back, null);
    }
    drawAlias(d, fore, back, la) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    }
    drawAbstDevice(d, fore, back, la) {
        this.update();
        if (this.mFillBack) {
            d.setColor(back);
            d.drawFillRect(this.mMinx, this.mMiny, this.mMaxx, this.mMaxy, null);
        }
        var scaleFont = NethomeCoreResource.getScaleFont(this.mScaleFontName);
        var scale = this.mSize / NethomeCoreResource.SCALEFONTSIZE;
        var _tmpf = new Array(2);
        if (this.mDir) {
            var cx = this.mCp.x;
            var cy = this.mCp.y;
            var angl = this.mAngl;
            var textw = scaleFont.stringWidth(this.mText) * scale;
            var size = this.mSize;
            var x;
            var y;
            if (la != null) {
                angl += la.mRot * 180 / Math.PI;
                var tx = la.getGlobalX(cx, cy, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                var ty = la.getGlobalY(cx, cy, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                cx = tx;
                cy = ty;
                size = this.mSize * la.getScaleX();
                if (la.getFlipY())
                    angl += 180.0;
                MathUtil.rotation2D(0, 0, angl * MathUtil.D2R, -textw / 2, -((scaleFont.ascent - scaleFont.descent) * scale) / 2 * 1, _tmpf);
                x = cx + _tmpf[0] * la.getScaleX();
                y = cy + _tmpf[1] * la.getScaleX();
            }
            else {
                MathUtil.rotation2D(0, 0, angl * MathUtil.D2R, -textw / 2, -((scaleFont.ascent - scaleFont.descent) * scale) / 2 * 1, _tmpf);
                x = cx + _tmpf[0];
                y = cy + _tmpf[1];
            }
            d.setColor(fore);
            d.drawText(this.mText, x, y, scaleFont.name, scaleFont.style, size, angl);
        }
        else {
            for (var i = 0; i < this.mText.length; i++) {
                var ss = this.mText.substring(i, i + 1);
                var wid = (scaleFont.stringWidth(ss) * scale);
                var hei = (scaleFont.height * scale);
                var size = (scaleFont.descent + scaleFont.ascent) * scale;
                var x1 = this.mCp.x - wid / 2;
                var y1 = this.mMaxy - size * (i + 1);
                var x2 = x1 + wid;
                var y2 = y1 + hei;
                var cx = (x1 + x2) / 2;
                var cy = (y1 + y2) / 2;
                var ofs = scaleFont.descent * scale;
                d.setColor(fore);
                if (NethomeCoreResource.TATE_STRING.indexOf(ss) >= 0) {
                    d.drawText(ss, cx - hei / 2 + ofs, cy + wid / 2, scaleFont.name, scaleFont.style, this.mSize, (this.mAngl - 90));
                }
                else {
                    d.drawText(ss, cx - wid / 2, cy - hei / 2 + ofs, scaleFont.name, scaleFont.style, this.mSize, this.mAngl);
                }
            }
        }
    }
    update() {
        var scaleFont = NethomeCoreResource.getScaleFont(this.mScaleFontName);
        var scale = this.mSize / scaleFont.size;
        var size = 0;
        if (this.mDir) {
            size = scaleFont.descent + scaleFont.ascent;
            let width = scaleFont.stringWidth(this.mText);
            let w = width * scale / 2;
            this.mMinx = this.mCp.x - w - size / 10 * scale;
            this.mMaxx = this.mCp.x + w + size / 10 * scale;
            this.mMiny = this.mCp.y - size / 2 * scale;
            this.mMaxy = this.mCp.y + size / 2 * scale;
        }
        else {
            let w = 0;
            for (var i = 0; i < this.mText.length; i++) {
                var ss = this.mText.substring(i, i + 1);
                var tw = scaleFont.stringWidth(ss) / 2;
                w = Math.max(w, tw);
            }
            this.mMinx = this.mCp.x - w * scale;
            this.mMaxx = this.mCp.x + w * scale;
            size = scaleFont.descent + scaleFont.ascent;
            let h = this.mText.length * size * scale / 2;
            this.mMiny = this.mCp.y - h;
            this.mMaxy = this.mCp.y + h;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * @return String
     **/
    getText() {
        return this.mText;
    }
    setText(s) {
        this.mText = s;
        this.update();
    }
    /**
     * @return double
     **/
    getSize() {
        return this.mSize;
    }
    /**
     * Sets the mSize.
     * @param mSize The mSize to set
    **/
    setSize(mSize) {
        this.mSize = mSize;
    }
    flipx(x, ofsx) {
        this.mCp.flipx(x, ofsx);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * 縦反転**/
    flipy(y, ofsy) {
        this.mCp.flipy(y, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rot(x, y, ofsx, ofsy) {
        this.mCp.rot(x, y, ofsx, ofsy);
        this.mDir = !this.mDir;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
}
GText.GEOMNAME = "TEXT";
//# sourceMappingURL=GText.js.map