import { KColor } from 'kiteclib';
import { KArea } from 'kiteclib';
import { IRichGraphics } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { LocalAxis2Df } from '../LocalAxis2Df';
import { GPoint2Df } from './GPoint2Df';
import { Geometry } from './Geometry';
export declare class GText extends Geometry {
    static GEOMNAME: string;
    /**
     * 中心座標 **/
    mCp: GPoint2Df;
    /**
     * 角度 **/
    mAngl: number;
    /**
     * サイズ
     **/
    protected mSize: number;
    /**
     * 文字列
     **/
    protected mText: string;
    /**
     * 最大・最小値 **/
    mMinx: number;
    mMiny: number;
    mMaxx: number;
    mMaxy: number;
    /**
     * スケールフォント名
     **/
    protected mScaleFontName: string;
    /**
     * 描画方向 (true:横)
     **/
    protected mDir: boolean;
    /**
     * 背景の塗り潰しモード
     **/
    protected mFillBack: boolean;
    /**
     * 塗りつぶし色
     **/
    protected mFillColor: KColor;
    /**
     * 太字
     **/
    protected mBold: boolean;
    /**
     * コンストラクタ**/
    /**
     * コンストラクタ
     * @param p1
     * @param scaleFontLabel
     * @param text
     * @param angl
     * @param size
     * @param bold
    **/
    constructor(p1?: GPoint2Df, scaleFontLabel?: string, text?: string, angl?: number, size?: number, bold?: boolean);
    /**
     * 塗り潰しモードの指定
     * @param fill
     * @param fillColor
    **/
    setFillMode(fill: boolean, fillColor: KColor): void;
    /****/
    updateMinMax(area: KArea): void;
    copy(): Geometry;
    copyTo(g: Geometry): Geometry;
    getDistanceToPoint(x: number, y: number): number;
    offset(x: number, y: number): void;
    rotate(xc: number, yc: number, angl: number): void;
    isInner(minx: number, miny: number, maxx: number, maxy: number): boolean;
    /**
     * 描画方向の設定**/
    setDir(dir: boolean): void;
    isDir(): boolean;
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode: ObjectFolder): void;
    drawHighLight(d: IRichGraphics, c: KColor, outline: boolean): void;
    drawGeom(d: IRichGraphics, fore: KColor, back: KColor): void;
    drawAlias(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawAbstDevice(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    update(): void;
    /**
     * @return String
     **/
    getText(): string;
    setText(s: string): void;
    /**
     * @return double
     **/
    getSize(): number;
    /**
     * Sets the mSize.
     * @param mSize The mSize to set
    **/
    setSize(mSize: number): void;
    flipx(x: number, ofsx: number): void;
    /**
     * 縦反転**/
    flipy(y: number, ofsy: number): void;
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
}
