import { Geometry } from './Geometry';
//module nethome.geom.primitive
/**
 * @author matsuzaki**/
export class GScalableGeometry extends Geometry {
    constructor(...args) {
        super(...args);
        /**
         * X方向へのスケーリングの許可 **/
        this.scaleEnX = false;
        /**
         * Y方向へのスケーリングの許可 **/
        this.scaleEnY = false;
        /**
         * アスペクト比一定のフラグ **/
        this.mKeepAspect = false;
        /**
         * スケーリングの基点X **/
        this.scaleBaseX = 0;
        /**
         * スケーリングの基点Y **/
        this.scaleBaseY = 0;
    }
    /**
     * コピーインスタンスの取得
     * 引数インスタンスに対し属性をコピーする
     * @param g　コピー属性設定対象オブジェクト
     * @return
     * @author kawae
     * @since 2003/01/01
    **/
    copyTo(g) {
        if (g == null)
            return null;
        super.copyTo(g);
        var s = (g);
        s.scaleEnX = this.scaleEnX;
        s.scaleEnY = this.scaleEnY;
        s.scaleBaseX = this.scaleBaseX;
        s.scaleBaseY = this.scaleBaseY;
        s.mKeepAspect = this.mKeepAspect;
        return g;
    }
    isScaleEnX() {
        return this.scaleEnX;
    }
    setScaleEnX(scaleEnX) {
        this.scaleEnX = scaleEnX;
    }
    isScaleEnY() {
        return this.scaleEnY;
    }
    setScaleEnY(scaleEnY) {
        this.scaleEnY = scaleEnY;
    }
    getScaleBaseX() {
        return this.scaleBaseX;
    }
    setScaleBaseX(scaleBaseX) {
        this.scaleBaseX = scaleBaseX;
    }
    getScaleBaseY() {
        return this.scaleBaseY;
    }
    setScaleBaseY(scaleBaseY) {
        this.scaleBaseY = scaleBaseY;
    }
    /**
     * アスペクト比を固定するか
     * @return the keepAspect
    **/
    isKeepAspect() {
        return this.mKeepAspect;
    }
    /**
     * アスペクト比を固定するかどうかを設定
     * @param keepAspect the keepAspect to set
    **/
    setKeepAspect(keepAspect) {
        this.mKeepAspect = keepAspect;
    }
}
//# sourceMappingURL=GScalableGeometry.js.map