import { KColor } from 'kiteclib';
import { MathUtil } from 'kiteclib';
import { Geometry } from './Geometry';
import { GPoint2Df } from './GPoint2Df';
import { GLine } from './GLine';
//module nethome.geom.primitive
/**
 * <p>タイトル: </p>
 * <p>説明: </p>
 * <p>著作権: Copyright (c) 2002</p>
 * <p>会社名: </p>
 * @author 未入力
 * @version 1.0
**/
export class GPolygon extends Geometry {
    /**
     * コンストラクタ**/
    //public constructor() {
    //    thisconstructor(new RefList<GPoint2Df>(), 0);
    //}
    /**
     * コンストラクタ**/
    constructor(p1, smooth = 0) {
        super();
        /**
         * 塗りつぶしオプション **/
        this.mFill = false;
        this.mPoints = p1 || [];
        this.mSmooth = smooth;
        this.mGeomColor = KColor.BLACK;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    getSnapNode(x1, y1, gx, gy, min, res, eps, limit) {
        return false;
    }
    getSnapLoop(v) {
        for (var i = 0; i <= this.mPoints.length; i++)
            v.push(this.mPoints[i]);
    }
    getCenter(p) {
        var x = 0;
        var y = 0;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            x += p1.x;
            y += p1.y;
        }
        p.x = x / this.mPoints.length;
        p.y = y / this.mPoints.length;
    }
    getNearNodeOnLine(p1, p2, eps) {
        var len;
        var min = Number.MAX_VALUE;
        var res = null;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            if ((len = MathUtil.getLengthLimitLineToPoint2D(pa.x, pa.y, p1.x, p1.y, p2.x, p2.y)) >= 0 && len < eps && len < min) {
                min = len;
                res = pa;
            }
        }
        return res;
    }
    getNearLine(x, y, eps, pts) {
        var len;
        var exist = false;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            var pb = this.mPoints[(k + 1) % this.mPoints.length];
            if ((len = MathUtil.getLengthLimitLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y)) >= 0 && len < eps) {
                pts[0] = pa;
                pts[1] = pb;
                exist = true;
            }
        }
        return exist;
    }
    getRotbasePoint() {
        return this.mPoints[0];
    }
    updateMinMax(area) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            area.updateMinMax(p.x, p.y);
        }
    }
    copy() {
        return this.copyTo(new GPolygon());
    }
    copyTo(g) {
        if (g == null || !(g instanceof GPolygon))
            return null;
        var np = (g);
        super.copyTo(g);
        var v = [];
        for (var i = 0; i < this.mPoints.length; i++)
            v.push(this.mPoints[i].copy());
        np.mPoints = v;
        np.mFill = this.mFill;
        np.setFillColor(this.mFillColor);
        np.setGeomColor(this.mGeomColor);
        np.mSmooth = this.mSmooth;
        np.area.maximize();
        np.updateMinMax(np.area);
        return np;
    }
    /**
     * 一番近くの構成点を探す
     * @param x
     * @param y
     * @return
    **/
    getNearNode(x, y) {
        var min = Number.MAX_VALUE;
        var gp = null;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            var len = MathUtil.getLength2D(x, y, p1.x, p1.y);
            if (len < min) {
                min = len;
                gp = p1;
            }
        }
        return gp;
    }
    /**
     * 指定点までの距離距離
     * @param x　指定点X座標
     * @param y　指定点Y座標
     * @return 指定点までの距離
    **/
    getDistanceToPoint(x, y) {
        var min = Number.MAX_VALUE;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.getPointAt(i);
            var p2 = this.getPointAt(i + 1);
            var len = MathUtil.getLengthLimitLineToPoint2D(x, y, p1.x, p1.y, p2.x, p2.y);
            if (len < 0)
                continue;
            else if (len < min)
                min = len;
        }
        return min;
    }
    offset(x, y) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].offset(x, y);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rotate(xc, yc, angl) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].rotate(xc, yc, angl);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * 矩形の中に全て入っているか判定
     * @param minx　矩形最小X値
     * @param miny　矩形最小Y値
     * @param maxx　矩形最大X値
     * @param maxy　矩形最大Y値
     * @return 矩形内:true
     * 　　　　 矩形外:false
    **/
    isInner(minx, miny, maxx, maxy) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.getPointAt(i);
            var p2 = this.getPointAt(i + 1);
            var b1 = false;
            var b2 = false;
            if (p1.x > minx && p1.x < maxx && p1.y > miny && p1.y < maxy)
                b1 = true;
            if (p2.x > minx && p2.x < maxx && p2.y > miny && p2.y < maxy)
                b2 = true;
            if (!b1 || !b2)
                return false;
        }
        return true;
    }
    /**
     * ポリゴンの中に全て入っているか判定
     * @param v　ポリゴン
     * @return 　ポリゴン内:true
     * 　　　　　ポリゴン外:false
    **/
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    for (var i: number = 0; i < this.mPoints.length; i++) {
    //        var p1: GPoint2Df = this.getPointAt(i);
    //        var p2: GPoint2Df = this.getPointAt(i + 1);
    //        var b1: boolean = ToolPolygon.isInnerPolygon(v, p1.x, p1.y);
    //        var b2: boolean = ToolPolygon.isInnerPolygon(v, p2.x, p2.y);
    //        if (!b1 || !b2) return false;
    //    }
    //    return true;
    //}
    getPoints() {
        return this.mPoints;
    }
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode) {
        if (savenode == null)
            return;
        super.save(savenode);
        savenode.addNode("smooth", this.mSmooth);
        savenode.addNode("fill", this.mFill);
        savenode.addNode("pointsize", this.mPoints.length);
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = (this.mPoints[i]);
            savenode.addNode("x" + (i + 1), p.x);
            savenode.addNode("y" + (i + 1), p.y);
        }
    }
    //drawGeom(d: IRichGraphics): void {
    //    this.drawAbstDevice(d, this.mGeomColor, this.mFillColor, null);
    //}
    drawGeom(dr, fore, back) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(dr, fore, back, null);
    }
    drawAlias(d, fore, back, la) {
        if (fore == null)
            fore = this.mGeomColor;
        if (back == null)
            back = this.mFillColor;
        this.drawAbstDevice(d, fore, back, la);
    }
    drawAbstDevice(d, fore, back, la) {
        var poly = null;
        if (la != null) {
            let _pbuf = [];
            for (var i = 0; i < this.mPoints.length; i++) {
                var p1 = (this.mPoints[i]);
                var x1 = la.getGlobalX(p1.x, p1.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                var y1 = la.getGlobalY(p1.x, p1.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
                _pbuf.push(new GPoint2Df(x1, y1));
            }
            poly = _pbuf;
        }
        else {
            poly = this.mPoints;
        }
        var samecolor = false;
        if (fore != null && back != null) {
            if (fore.getRed() == back.getRed() && fore.getGreen() == back.getGreen() && fore.getBlue() == back.getBlue())
                samecolor = true;
        }
        if (poly.length > 1) {
            if (this.mFill && back != null) {
                d.setColor(back);
                d.drawFillPolygon(poly, null);
            }
            if (this.mFill && samecolor)
                return;
            if (fore != null) {
                d.setColor(fore);
                d.drawPolygon(poly, null);
            }
        }
    }
    drawHighLight(d, c, outline) {
        if (outline) {
            var f = this.mFill;
            this.mFill = false;
            this.drawAbstDevice(d, c, c, null);
            this.mFill = f;
        }
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].drawHighLight(d, c, false);
    }
    /**
     * ポリラインの構成点列をLineとして、一番近いものを取得
     * @param x
     * @param y
     * @return
    **/
    getNearAsLine(x, y) {
        var min = Number.MAX_VALUE;
        var pa = null;
        var pb = null;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.getPointAt(i);
            var p2 = this.getPointAt(i + 1);
            var len = MathUtil.getLengthLimitLineToPoint2D(x, y, p1.x, p1.y, p2.x, p2.y);
            if (len < 0)
                continue;
            if (len < min) {
                min = len;
                pa = p1;
                pb = p2;
            }
        }
        if (pa != null && pb != null)
            return new GLine(pa, pb);
        return null;
    }
    flipx(x, ofsx) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipx(x, ofsx);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    flipy(y, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipy(y, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rot(x, y, ofsx, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].rot(x, y, ofsx, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * 塗り潰しモードの設定**/
    setFillMode(flag) {
        this.mFill = flag;
    }
    isFillMode() {
        return this.mFill;
    }
    /**
     * @return Returns the mFillColor.**/
    getFillColor() {
        return this.mFillColor;
    }
    /**
     * @param fillColor The mFillColor to set.**/
    setFillColor(fillColor) {
        this.mFillColor = fillColor;
    }
    getPointAt(n) {
        if (n == this.mPoints.length)
            return this.mPoints[0];
        else
            return this.mPoints[n];
    }
}
//# sourceMappingURL=GPolygon.js.map