import { KColor } from 'kiteclib';
import { IRichGraphicsConst } from 'kiteclib';
import { MathUtil } from 'kiteclib';
import { Geometry } from './Geometry';
import { GPoint2Df } from './GPoint2Df';
//module nethome.geom.primitive
export class GPolyLine extends Geometry {
    /**
     * コンストラクタ**/
    //public constructor() {
    //    thisconstructor(new RefList<GPoint2Df>(), 0, 0);
    //}
    /**
     * コンストラクタ
     * @param p1		ポリライン構成点コレクション
     * @param type	始点X座標
     * @param c		描画色
    **/
    constructor(p1, type = 0, smooth = 0) {
        super();
        this.mGeomColor = KColor.BLACK;
        this.mPoints = p1 || [];
        this.mType = type;
        this.mSmooth = smooth;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    addPoint(p) {
        this.mPoints.push(p);
        if (this.areaControl != null)
            this.areaControl.setArea(this.mPoints);
    }
    getSnapNode(x1, y1, gx, gy, min, res, eps, limit) {
        return false;
    }
    getSnapLoop(v) {
        for (var i = 0; i < this.mPoints.length; i++)
            v.push(this.mPoints[i]);
    }
    getCenter(p) {
        var x = 0;
        var y = 0;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            x += p1.x;
            y += p1.y;
        }
        p.x = x / this.mPoints.length;
        p.y = y / this.mPoints.length;
    }
    getNearNodeOnLine(p1, p2, eps) {
        var len;
        var min = Number.MAX_VALUE;
        var res = null;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            if ((len = MathUtil.getLengthLimitLineToPoint2D(pa.x, pa.y, p1.x, p1.y, p2.x, p2.y)) >= 0 && len < eps && len < min) {
                min = len;
                res = pa;
            }
        }
        return res;
    }
    getNearLine(x, y, eps, pts) {
        var len;
        var exist = false;
        for (var k = 0; k < this.mPoints.length; k++) {
            var pa = this.mPoints[k];
            var pb = this.mPoints[(k + 1) % this.mPoints.length];
            if ((len = MathUtil.getLengthLimitLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y)) >= 0 && len < eps) {
                pts[0] = pa;
                pts[1] = pb;
                exist = true;
            }
        }
        return exist;
    }
    getRotbasePoint() {
        return this.mPoints[0];
    }
    updateMinMax(area) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            area.updateMinMax(p.x, p.y);
        }
    }
    copy() {
        return this.copyTo(new GPolyLine());
    }
    copyTo(g) {
        if (g == null || !(g instanceof GPolyLine))
            return null;
        var np = (g);
        super.copyTo(np);
        var v = [];
        for (var i = 0; i < this.mPoints.length; i++)
            v.push(this.mPoints[i].copy());
        np.mPoints = v;
        np.mType = this.mType;
        np.mSmooth = this.mSmooth;
        np.area.maximize();
        np.updateMinMax(np.area);
        return np;
    }
    getNearNode(x, y) {
        var min = Number.MAX_VALUE;
        var gp = null;
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1 = this.mPoints[i];
            var len = MathUtil.getLength2D(x, y, p1.x, p1.y);
            if (len < min) {
                min = len;
                gp = p1;
            }
        }
        return gp;
    }
    getDistanceToPoint(x, y) {
        var min = Number.MAX_VALUE;
        for (var i = 0; i < this.mPoints.length - 1; i++) {
            var p1 = this.mPoints[i];
            var p2 = this.mPoints[(i + 1) % this.mPoints.length];
            var len = MathUtil.getLengthLimitLineToPoint2D(x, y, p1.x, p1.y, p2.x, p2.y);
            if (len < 0)
                continue;
            else if (len < min)
                min = len;
        }
        return min;
    }
    offset(x, y) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].offset(x, y);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rotate(xc, yc, angl) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].rotate(xc, yc, angl);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    isInner(minx, miny, maxx, maxy) {
        for (var i = 0; i < this.mPoints.length; i++) {
            var p1;
            var p2;
            p1 = this.mPoints[i];
            if (i == this.mPoints.length - 1)
                p2 = this.mPoints[0];
            else
                p2 = this.mPoints[i + 1];
            var b1 = false;
            var b2 = false;
            if (p1.x > minx && p1.x < maxx && p1.y > miny && p1.y < maxy)
                b1 = true;
            if (p2.x > minx && p2.x < maxx && p2.y > miny && p2.y < maxy)
                b2 = true;
            if (!b1 || !b2)
                return false;
        }
        return true;
    }
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    for (var i: number = 0; i < this.mPoints.length; i++) {
    //        var p1: GPoint2Df; var p2: GPoint2Df;
    //        p1 = (this.mPoints.[i]) as GPoint2Df;
    //        if (i == this.mPoints.length - 1) p2 = (this.mPoints.elementAt(0)) as GPoint2Df; else p2 = (this.mPoints.elementAt(i + 1)) as GPoint2Df;
    //        var b1: boolean = ToolPolygon.isInnerPolygon(v, p1.x, p1.y);
    //        var b2: boolean = ToolPolygon.isInnerPolygon(v, p2.x, p2.y);
    //        if (!b1 || !b2) return false;
    //    }
    //    return true;
    //}
    getPoints() {
        return this.mPoints;
    }
    static readData(of, g, ps) {
        var on;
        var gp = null;
        if (!(g instanceof GPolyLine))
            return;
        Geometry.readData(of, g, ps);
        gp = (g);
        gp.mPoints = [];
        var num = 0;
        if ((on = of.getNode("smooth")) != null)
            gp.mSmooth = on.getInt();
        if ((on = of.getNode("type")) != null)
            gp.mType = on.getInt();
        if ((on = of.getNode("pointsize")) != null)
            num = on.getInt();
        for (var i = 0; i < num; i++) {
            var x = 0;
            var y = 0;
            if ((on = of.getNode("x" + (i + 1))) != null)
                x = on.getFloat();
            if ((on = of.getNode("y" + (i + 1))) != null)
                y = on.getFloat();
            gp.mPoints.push(new GPoint2Df(x, y));
        }
    }
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode) {
        if (savenode == null)
            return;
        super.save(savenode);
        savenode.addNode("smooth", this.mSmooth);
        savenode.addNode("type", this.mType);
        savenode.addNode("pointsize", this.mPoints.length);
        for (var i = 0; i < this.mPoints.length; i++) {
            var p = this.mPoints[i];
            savenode.addNode("x" + (i + 1), p.x);
            savenode.addNode("y" + (i + 1), p.y);
        }
    }
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, null, null);
    //}
    drawGeom(d, fore, back) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, null);
    }
    drawHighLight(d, c, outline) {
        if (outline) {
            d.setColor(c);
            d.drawPolyLine(this.mPoints, IRichGraphicsConst.LINE_DASH_1);
        }
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].drawHighLight(d, c, false);
    }
    drawAlias(d, fore, back, la) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    }
    drawAbstDevice(d, fore, back, la) {
        var poly = null;
        if (la != null) {
            let _pbuf = [];
            for (var i = 0; i < this.mPoints.length; i++) {
                var p = this.mPoints[i];
                _pbuf.push(new GPoint2Df(la.getGlobalX(p.x, p.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY), la.getGlobalY(p.x, p.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY)));
            }
            poly = _pbuf;
        }
        else {
            poly = this.mPoints;
        }
        d.setColor(fore);
        d.drawPolyLine(poly, null);
    }
    flipx(x, ofsx) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipx(x, ofsx);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    flipy(y, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].flipy(y, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rot(x, y, ofsx, ofsy) {
        for (var i = 0; i < this.mPoints.length; i++)
            this.mPoints[i].rot(x, y, ofsx, ofsy);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
}
//# sourceMappingURL=GPolyLine.js.map