import { KArea } from 'kiteclib';
import { KColor } from 'kiteclib';
import { ObjectFolder } from 'kiteclib';
import { IRichGraphics } from 'kiteclib';
import { Primitive } from './Primitive';
import { LocalAxis2Df } from '../LocalAxis2Df';
import { Geometry } from './Geometry';
import { GeomParser } from '../GeomParser';
import { GPoint2Df } from './GPoint2Df';
export declare class GPolyLine extends Geometry implements Primitive {
    /**
     * 構成点コレクション **/
    protected mPoints: GPoint2Df[];
    /**
     * 描画用ポイントバッファ **/
    /**
     * 線の幅 **/
    mLineWidth: number;
    /**
     * 線種 **/
    mType: number;
    /**
     * スムーズオプション **/
    mSmooth: number;
    /**
     * コンストラクタ**/
    /**
     * コンストラクタ
     * @param p1		ポリライン構成点コレクション
     * @param type	始点X座標
     * @param c		描画色
    **/
    constructor(p1?: GPoint2Df[], type?: number, smooth?: number);
    addPoint(p: GPoint2Df): void;
    getSnapNode(x1: number, y1: number, gx: number, gy: number, min: number[], res: number[], eps: number, limit: number): boolean;
    getSnapLoop(v: GPoint2Df[]): void;
    getCenter(p: GPoint2Df): void;
    getNearNodeOnLine(p1: GPoint2Df, p2: GPoint2Df, eps: number): GPoint2Df;
    getNearLine(x: number, y: number, eps: number, pts: GPoint2Df[]): boolean;
    getRotbasePoint(): GPoint2Df;
    updateMinMax(area: KArea): void;
    copy(): Geometry;
    copyTo(g: Geometry): Geometry;
    getNearNode(x: number, y: number): GPoint2Df;
    getDistanceToPoint(x: number, y: number): number;
    offset(x: number, y: number): void;
    rotate(xc: number, yc: number, angl: number): void;
    isInner(minx: number, miny: number, maxx: number, maxy: number): boolean;
    getPoints(): GPoint2Df[];
    static readData(of: ObjectFolder, g: Geometry, ps: GeomParser): void;
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode: ObjectFolder): void;
    drawGeom(d: IRichGraphics, fore: KColor, back: KColor): void;
    drawHighLight(d: IRichGraphics, c: KColor, outline: boolean): void;
    drawAlias(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    drawAbstDevice(d: IRichGraphics, fore: KColor, back: KColor, la: LocalAxis2Df): void;
    flipx(x: number, ofsx: number): void;
    flipy(y: number, ofsy: number): void;
    rot(x: number, y: number, ofsx: number, ofsy: number): void;
}
