import { IRichGraphicsConst } from 'kiteclib';
import { KColor } from 'kiteclib';
import { K2DFigureType } from 'kiteclib';
import { MathUtil } from 'kiteclib';
import { NethomeCoreResource } from '../../NethomeCoreResource';
import { Geometry } from './Geometry';
//module nethome.geom.primitive
/**
 * @author kawae**/
export class GPoint2Df extends Geometry {
    /**
     * コンストラクタ
     * @param x
     * @param y
    **/
    constructor(x = 0, y = 0) {
        super(GPoint2Df.GEOMNAME);
        this.x = x;
        this.y = y;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    getType() {
        return K2DFigureType.POINT;
    }
    /**
     * 座標地のセット**/
    setXY(x, y) {
        this.x = x;
        this.y = y;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#getX()
    **/
    getX() {
        return this.x;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#getY()
    **/
    getY() {
        return this.y;
    }
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#setX(double)
    **/
    setX(x) {
        this.x = x;
    }
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigurePoint#setY(double)
    **/
    setY(y) {
        this.y = y;
    }
    /**
     * 座標地のセット
     * @param p
    **/
    setPoint(p) {
        this.setXY(p.getX(), p.getY());
    }
    /**
     * 最大・最小値の更新**/
    updateMinMax(area) {
        area.updateMinMax(this.x, this.y);
    }
    /**
     * コピーインスタンスの取得**/
    copy() {
        return this.copyTo(new GPoint2Df());
    }
    /**
     * コピーインスタンスの取得**/
    copyTo(g) {
        if (g == null || !(g instanceof GPoint2Df))
            return null;
        var p = (g);
        super.copyTo(p);
        p.setPoint(this);
        p.area.maximize();
        p.updateMinMax(p.area);
        return p;
    }
    getNearNode(x, y) {
        return this;
    }
    getDistanceToPoint(x, y) {
        return MathUtil.getLength2D(x, y, this.x, this.y);
    }
    offset(dx, dy) {
        this.x += dx;
        this.y += dy;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rotate(xc, yc, angl) {
        var _tmpf = new Array(2);
        MathUtil.rotation2D(xc, yc, angl, this.x, this.y, _tmpf);
        _tmpf[0] = (Math.round(_tmpf[0] * 1000) / 1000);
        _tmpf[1] = (Math.round(_tmpf[1] * 1000) / 1000);
        this.x = this.area.minX = this.area.maxX = _tmpf[0];
        this.y = this.area.minY = this.area.maxY = _tmpf[1];
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    drawHighLight(d, c, outline) {
        GPoint2Df.drawHighLight(d, c, this.x, this.y);
    }
    static drawHighLight(d, c, x, y) {
        d.setColor(c);
        d.drawMark(x, y, NethomeCoreResource.MARKER_SIZE, IRichGraphicsConst.MARK_REC_FILL);
        d.setColor(KColor.BLACK);
        d.drawMark(x, y, NethomeCoreResource.MARKER_SIZE, IRichGraphicsConst.MARK_REC);
    }
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    save(savenode) {
        if (savenode == null)
            return;
        super.save(savenode);
        savenode.addNode("x", this.x);
        savenode.addNode("y", this.y);
    }
    flipx(x, ofsx) {
        this.x = x - (this.x - x) + ofsx;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    flipy(y, ofsy) {
        this.y = y - (this.y - y) + ofsy;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rot(x, y, ofsx, ofsy) {
        var tmpx;
        var tmpy;
        tmpx = this.x;
        tmpy = this.y;
        this.x = x - (tmpy - y) + ofsy;
        this.y = y + (tmpx - x);
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    drawGeom(d) {
    }
}
GPoint2Df.GEOMNAME = "POINT";
//# sourceMappingURL=GPoint2Df.js.map