import { KColor } from 'kiteclib';
import { MathUtil } from 'kiteclib';
import { K2DFigureType } from 'kiteclib';
import { Geometry } from './Geometry';
import { GPoint2Df } from './GPoint2Df';
//module nethome.geom.primitive
export class GLine extends Geometry {
    constructor(x1OrP1, y1OrP2, x2OrLtype, y2) {
        super(GLine.GEOMNAME);
        var p1;
        var p2;
        var ltype;
        if (x1OrP1 === undefined) {
            p1 = new GPoint2Df();
            p2 = new GPoint2Df();
            ltype = null;
        }
        else {
            if (typeof x1OrP1 === "number") {
                p1 = new GPoint2Df(x1OrP1, y1OrP2);
                p2 = new GPoint2Df(x2OrLtype, y2);
                ltype = null;
            }
            else {
                p1 = x1OrP1;
                p2 = y1OrP2;
                ltype = x2OrLtype;
            }
        }
        this.mGeomColor = KColor.BLACK;
        this.pA = p1;
        this.pB = p2;
        this.lineType = ltype;
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    getSnapNode(x1, y1, gx, gy, min, res, eps, limit) {
        return false;
    }
    getSnapLoop(v) {
        v.push(this.pA);
        v.push(this.pB);
    }
    getCenter(p) {
        p.x = (this.pA.x + this.pB.x) / 2;
        p.y = (this.pA.y + this.pB.y) / 2;
    }
    getNearNodeOnLine(p1, p2, eps) {
        var len;
        var min = Number.MAX_VALUE;
        var res = null;
        for (var k = 0; k < 2; k++) {
            var pa = k == 0 ? this.pA : this.pB;
            if ((len = MathUtil.getLengthLimitLineToPoint2D(pa.x, pa.y, p1.x, p1.y, p2.x, p2.y)) >= 0 && len < eps && len < min) {
                min = len;
                res = pa;
            }
        }
        return res;
    }
    getNearLine(x, y, eps, pts) {
        var len;
        var pa = this.pA;
        var pb = this.pB;
        if ((len = MathUtil.getLengthLimitLineToPoint2D(x, y, pa.x, pa.y, pb.x, pb.y)) >= 0 && len < eps) {
            pts[0] = pa;
            pts[1] = pb;
            return true;
        }
        return false;
    }
    getRotbasePoint() {
        return this.pA;
    }
    updateMinMax(area) {
        area.updateMinMax(this.pA.x, this.pA.y);
        area.updateMinMax(this.pB.x, this.pB.y);
    }
    copy() {
        return this.copyTo(new GLine());
    }
    copyTo(g) {
        if (g == null || !(g instanceof GLine))
            return null;
        var gl = g;
        super.copyTo(gl);
        gl.pA.setPoint(this.pA);
        gl.pB.setPoint(this.pB);
        gl.area.maximize();
        gl.updateMinMax(gl.area);
        return gl;
    }
    /**
     * 一番近くの構成点を探す
     * @param x
     * @param y
     * @return
    **/
    getNearNode(x, y) {
        var min = Number.MAX_VALUE;
        var gp = null;
        var tmp;
        if ((tmp = MathUtil.getLength2D(x, y, this.pA.x, this.pA.y)) < min) {
            gp = this.pA;
            min = tmp;
        }
        if ((tmp = MathUtil.getLength2D(x, y, this.pB.x, this.pB.y)) < min)
            gp = this.pB;
        return gp;
    }
    getDistanceToPoint(x, y) {
        var len;
        len = MathUtil.getLengthLimitLineToPoint2D(x, y, this.pA.x, this.pA.y, this.pB.x, this.pB.y);
        if (len < 0)
            return -1;
        return len;
    }
    offset(x, y) {
        this.pA.x += x;
        this.pA.y += y;
        this.pB.x += x;
        this.pB.y += y;
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rotate(xc, yc, angl) {
        this.pA.rotate(xc, yc, angl);
        this.pB.rotate(xc, yc, angl);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    isInner(minx, miny, maxx, maxy) {
        var p1 = false;
        var p2 = false;
        if (this.pA.x > minx && this.pA.x < maxx && this.pA.y > miny && this.pA.y < maxy)
            p1 = true;
        if (this.pB.x > minx && this.pB.x < maxx && this.pB.y > miny && this.pB.y < maxy)
            p2 = true;
        return p1 && p2;
    }
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    return ToolPolygon.isInnerPolygon(v, this.pA.x, this.pA.y) && ToolPolygon.isInnerPolygon(v, this.pB.x, this.pB.y);
    //}
    /**
     * 幾何データの保存
     * @param savenode		保存対象ノード
     * @author kawae
     * @since 2003/01/01
    **/
    save(savenode) {
        if (savenode == null)
            return;
        super.save(savenode);
        savenode.addNode("x1", this.pA.x);
        savenode.addNode("y1", this.pA.y);
        savenode.addNode("x2", this.pB.x);
        savenode.addNode("y2", this.pB.y);
    }
    /**
     * 線種の設定
     * @param ltype　線種
    **/
    setLType(ltype) {
        this.lineType = ltype;
    }
    getLType() {
        return this.lineType;
    }
    /**
     * 描画
     * @param d	描画インターフェース
     * @author kawae
     * @since 2003/01/01
    **/
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, this.mGeomColor, null);
    //}
    /**
     * ハイライト描画
     * @param d	描画インターフェース
     * @param c		幾何描画色
     * @author kawae
     * @since 2003/01/01
    **/
    drawHighLight(d, c, outline) {
        if (outline) {
            this.drawAbstDevice(d, c, c, null);
        }
        this.pA.drawHighLight(d, c, false);
        this.pB.drawHighLight(d, c, false);
    }
    drawGeom(d, fore, back) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, null);
    }
    drawAlias(d, fore, back, la) {
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    }
    /**
     * 最終描画
     * @param d	描画インターフェース
     * @param fore	前景色
     * @param back	背景色
     * @param la	描画座標
     * @author kawae
     * @since 2004/09/24
    **/
    drawAbstDevice(d, fore, back, la) {
        var x1;
        var y1;
        var x2;
        var y2;
        if (la != null) {
            x1 = la.getGlobalX(this.pA.x, this.pA.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            y1 = la.getGlobalY(this.pA.x, this.pA.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            x2 = la.getGlobalX(this.pB.x, this.pB.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            y2 = la.getGlobalY(this.pB.x, this.pB.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
        }
        else {
            x1 = this.pA.x;
            y1 = this.pA.y;
            x2 = this.pB.x;
            y2 = this.pB.y;
        }
        d.setColor(fore);
        d.drawLine(x1, y1, x2, y2, null);
    }
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    getNearControlPoint(x, y) {
        var min = Number.POSITIVE_INFINITY;
        var pt = null;
        for (var i = 0; i < 2; i++) {
            var p = i == 0 ? this.pA : this.pB;
            var len = p.getDistanceToPoint(x, y);
            if (len < min) {
                min = len;
                pt = p;
            }
        }
        return pt;
    }
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    moveControlPoint(cp, x, y) {
        if (cp == this.pA) {
            this.pA.x = x;
            this.pA.y = y;
        }
        else if (cp == this.pB) {
            this.pB.x = x;
            this.pB.y = y;
        }
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    flipx(x, ofsx) {
        this.pA.flipx(x, ofsx);
        this.pB.flipx(x, ofsx);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    flipy(y, ofsy) {
        this.pA.flipy(y, ofsy);
        this.pB.flipy(y, ofsy);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    rot(x, y, ofsx, ofsy) {
        this.pA.rot(x, y, ofsx, ofsy);
        this.pB.rot(x, y, ofsx, ofsy);
        this.updateShape();
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    getType() {
        return K2DFigureType.LINE;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getX1()
    **/
    getX1() {
        return this.pA.x;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getX2()
    **/
    getX2() {
        return this.pB.x;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getY1()
    **/
    getY1() {
        return this.pA.y;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#getY2()
    **/
    getY2() {
        return this.pB.y;
    }
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX1(double)
    **/
    setX1(x) {
        this.pA.setX(x);
    }
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX2(double)
    **/
    setX2(x) {
        this.pB.setX(x);
    }
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY1(double)
    **/
    setY1(y) {
        this.pA.setY(y);
    }
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY2(double)
    **/
    setY2(y) {
        this.pB.setY(y);
    }
}
GLine.GEOMNAME = "LINE";
//# sourceMappingURL=GLine.js.map