import { KColor } from 'kiteclib';
import { K2DFigureType } from 'kiteclib';
import { MathUtil } from 'kiteclib';
import { Geometry } from './Geometry';
import { AreaControl } from '../AreaControl';
import { GPoint2Df } from './GPoint2Df';
//import { ToolPolygon } from '../util/ToolPolygon'
//module nethome.geom.primitive
export class GCircle extends Geometry {
    /**
     * コンストラクタ
    **/
    //constructor() {
    //}
    /**
     * コンストラクタ**/
    constructor(cx = 0, cy = 0, r = 0, start = 0, end = Math.PI * 2) {
        //thisconstructor();
        super(GCircle.GEOMNAME);
        this._tmpP = new GPoint2Df();
        /**
         * 塗潰しモード
         **/
        this.mFill = false;
        this.mGeomColor = KColor.BLACK;
        this.mCp = new GPoint2Df(cx, cy);
        this._r = r;
        this._start = start;
        this._end = end;
        this.areaControl = new AreaControl();
        this.updateMaxPoints();
        this.area.maximize();
        this.updateMinMax(this.area);
    }
    getSnapNode(x1, y1, gx, gy, min, res, eps, limit) {
        return false;
    }
    getCenter(p) {
        p.x = this.mCp.x;
        p.y = this.mCp.y;
    }
    getSnapLoop(v) {
    }
    /**
     * TODO:実装**/
    getNearNodeOnLine(p1, p2, eps) {
        return null;
    }
    getNearLine(x, y, eps, pts) {
        return false;
    }
    getRotbasePoint() {
        return this._maxPts[0];
    }
    static isParallel(g1, g2) {
        if (g1 == null || g2 == null)
            return false;
        if (!(g1 instanceof GCircle) || !(g2 instanceof GCircle))
            return false;
        var c1 = (g1);
        var c2 = (g2);
        if (Math.abs(c1.getR() - c2.getR()) < MathUtil.EPS && MathUtil.getLength2D(c1.getX(), c1.getY(), c2.getX(), c2.getY()) < MathUtil.EPS) {
            if (Math.abs(c1.getStart() - c2.getEnd()) < MathUtil.EPS) {
                if (!MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getStart()))
                    return true;
            }
            else if (Math.abs(c1.getEnd() - c2.getStart()) < MathUtil.EPS) {
                if (!MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getEnd()))
                    return true;
            }
        }
        return false;
    }
    static marge(g1, g2) {
        if (GCircle.isParallel(g1, g2)) {
            var c1 = (g1);
            var c2 = (g2);
            if (Math.abs(c1.getStart() - c2.getEnd()) < MathUtil.EPS) {
                if (!MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getStart())) {
                    return new GCircle(c1.getX(), c1.getY(), c1.getR(), c2.getStart(), c1.getEnd());
                }
            }
            else if (Math.abs(c1.getEnd() - c2.getStart()) < MathUtil.EPS) {
                if (!MathUtil.isInnerAngl360(c1.getStart(), c1.getEnd(), c2.getEnd()))
                    return new GCircle(c1.getX(), c1.getY(), c1.getR(), c1.getStart(), c2.getEnd());
            }
        }
        return null;
    }
    getStart() {
        return this._start;
    }
    setStart(f) {
        this._start = f;
    }
    getEnd() {
        return this._end;
    }
    setEnd(f) {
        this._end = f;
    }
    getR() {
        return this._r;
    }
    setR(r) {
        this._r = r;
    }
    setX(f) {
        this.mCp.x = f;
    }
    setY(f) {
        this.mCp.y = f;
    }
    getX() {
        return this.mCp.x;
    }
    getY() {
        return this.mCp.y;
    }
    copy() {
        return this.copyTo(new GCircle());
    }
    copyTo(g) {
        if (g == null || !(g instanceof GCircle))
            return null;
        var gc = (g);
        super.copyTo(gc);
        gc.mCp = new GPoint2Df(this.mCp.x, this.mCp.y);
        gc._r = this._r;
        gc._start = this._start;
        gc._end = this._end;
        gc.setFillMode(this.mFill);
        gc.setFillColor(this.mFillColor);
        gc.areaControl = new AreaControl();
        gc.updateMaxPoints();
        gc.area.maximize();
        gc.updateMinMax(gc.area);
        return gc;
    }
    updateMinMax(area) {
        var s;
        var e;
        s = this._start;
        e = this._end;
        while (s > e)
            s = s - 360;
        if (s <= 0 && e >= 0)
            area.maxX = Math.max(this.mCp.x + this._r, area.maxX);
        if (s <= 90 && e >= 90)
            area.maxY = Math.max(this.mCp.y + this._r, area.maxY);
        if (s <= 180 && e >= 180)
            area.minX = Math.min(this.mCp.x - this._r, area.minX);
        if (s <= 270 && e >= 270)
            area.minY = Math.min(this.mCp.y - this._r, area.minY);
        if (this._start == this._end) {
            area.updateMinMax(this.mCp.x + this._r, this.mCp.y + this._r);
            area.updateMinMax(this.mCp.x - this._r, this.mCp.y - this._r);
        }
        else {
            var x1 = this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180));
            var y1 = this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180));
            var x2 = this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180));
            var y2 = this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180));
            area.updateMinMax(x1, y1);
            area.updateMinMax(x2, y2);
        }
    }
    updateMaxPoints() {
        var s;
        var e;
        s = this._start;
        e = this._end;
        while (s > e)
            s = s - 360;
        this._maxPts = [];
        if (s < 0 && e > 0 || this._start == this._end)
            this._maxPts.push(new GPoint2Df(this.mCp.x + this._r, this.mCp.y));
        if (s < 90 && e > 90 || this._start == this._end)
            this._maxPts.push(new GPoint2Df(this.mCp.x, this.mCp.y + this._r));
        if (s < 180 && e > 180 || this._start == this._end)
            this._maxPts.push(new GPoint2Df(this.mCp.x - this._r, this.mCp.y));
        if (s < 270 && e > 270 || this._start == this._end)
            this._maxPts.push(new GPoint2Df(this.mCp.x, this.mCp.y - this._r));
        if (this._start != this._end) {
            var p1 = new GPoint2Df(this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180)), this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180)));
            var p2 = new GPoint2Df(this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180)), this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180)));
            this._maxPts.push(p1);
            this._maxPts.push(p2);
        }
        this.areaControl.getPoints().length = 0;
        for (var i = 0; i < this._maxPts.length; i++)
            this.areaControl.getPoints().push(this._maxPts[i]);
    }
    getNearNode(x, y) {
        var min;
        var x1;
        var y1;
        this._tmpP.x = this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180));
        this._tmpP.y = this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180));
        min = MathUtil.getLength2D(x, y, this._tmpP.x, this._tmpP.y);
        x1 = this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180));
        y1 = this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180));
        if (min > MathUtil.getLength2D(x, y, x1, y1)) {
            this._tmpP.x = x1;
            this._tmpP.y = y1;
        }
        return this._tmpP;
    }
    getDistanceToPoint(x, y) {
        var angl = (MathUtil.getAngle2D(this.mCp.x, this.mCp.y, x, y) * 180 / Math.PI);
        var s = this._start;
        var e = this._end;
        e -= s;
        angl -= s;
        s = 0;
        e = MathUtil.getAngl360(e);
        angl = MathUtil.getAngl360(angl);
        if ((angl > s && angl < e) || s == e) {
            return Math.abs(this._r - MathUtil.getLength2D(this.mCp.x, this.mCp.y, x, y));
        }
        var min;
        var x1;
        var y1;
        x1 = this.mCp.x + (this._r * Math.cos(this._start * Math.PI / 180));
        y1 = this.mCp.y + (this._r * Math.sin(this._start * Math.PI / 180));
        min = MathUtil.getLength2D(x, y, x1, y1);
        x1 = this.mCp.x + (this._r * Math.cos(this._end * Math.PI / 180));
        y1 = this.mCp.y + (this._r * Math.sin(this._end * Math.PI / 180));
        min = Math.min(min, MathUtil.getLength2D(x, y, x1, y1));
        return min;
    }
    offset(x, y) {
        if (x == 0 && y == 0)
            return;
        this.mCp.x += x;
        this.mCp.y += y;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }
    rotate(xc, yc, angl) {
        if (angl == 0)
            return;
        this.mCp.rotate(xc, yc, angl);
        this._start += (angl * 180 / Math.PI);
        this._end += (angl * 180 / Math.PI);
        while (this._start >= 360)
            this._start -= 360;
        while (this._start < 0)
            this._start += 360;
        while (this._end >= 360)
            this._end -= 360;
        while (this._end < 0)
            this._end += 360;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }
    isInner(minx, miny, maxx, maxy) {
        for (var i = 0; i < this._maxPts.length; i++) {
            var p = this._maxPts[i];
            if (p.x < minx || p.x > maxx || p.y < miny || p.y > maxy)
                return false;
        }
        return true;
    }
    //isInner(v: RefList<GPoint2Df>): boolean {
    //    for (var i: number = 0; i < this._maxPts.length; i++) {
    //        var p: GPoint2Df = (this._maxPts.elementAt(i)) as GPoint2Df;
    //        if (!ToolPolygon.isInnerPolygon(v, p.x, p.y)) return false;
    //    }
    //    return true;
    //}
    /**
     * データの保存
     * @param savenode
    **/
    save(savenode) {
        if (savenode == null)
            return;
        super.save(savenode);
        savenode.addNode("cx", this.mCp.x);
        savenode.addNode("cy", this.mCp.y);
        savenode.addNode("r", this._r);
        savenode.addNode("start", this._start);
        savenode.addNode("end", this._end);
        savenode.addNode("fill", this.mFill);
        if (this.mFillColor != null)
            savenode.addNode("fillc", this.mFillColor.getRed() + "," + this.mFillColor.getGreen() + "," + this.mFillColor.getBlue());
    }
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, this.mGeomColor, null);
    //}
    drawGeom(d, fore, back) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, null);
    }
    drawAlias(d, fore, back, la) {
        if (back == null)
            back = this.mFillColor;
        if (fore == null)
            fore = this.mGeomColor;
        this.drawAbstDevice(d, fore, back, la);
    }
    drawAbstDevice(d, fore, back, la) {
        var x1 = this.mCp.x;
        var y1 = this.mCp.y;
        var s = this._start;
        var e = this._end;
        var r = this._r;
        if (la != null) {
            //if (false) {
            //    x1 = la.getGlobalX(this.mCp.x, this.mCp.y);
            //    y1 = la.getGlobalY(this.mCp.x, this.mCp.y);
            //}
            //else {
            x1 = la.getGlobalX(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            y1 = la.getGlobalY(this.mCp.x, this.mCp.y, this.mKeepAspect, this.scaleEnX, this.scaleEnY, this.scaleBaseX, this.scaleBaseY);
            //}
            s = (la.getGlobalAngl(this._start * Math.PI / 180) * 180 / Math.PI);
            e = (la.getGlobalAngl(this._end * Math.PI / 180) * 180 / Math.PI);
            r = la.getGlobalLength(this._r);
            while (s >= 360)
                s -= 360;
            while (s < 0)
                s += 360;
            while (e >= 360)
                e -= 360;
            while (e < 0)
                e += 360;
        }
        if (this.mFill && back != null) {
            d.setColor(back);
            d.drawFillCircle(x1, y1, r, s, e, null);
        }
        d.setColor(fore);
        d.drawCircle(x1, y1, r, s, e, null);
    }
    drawHighLight(d, c, outline) {
        if (outline) {
            var f = this.mFill;
            this.mFill = false;
            this.drawAbstDevice(d, c, c, null);
            this.mFill = f;
        }
        for (var i = 0; i < this._maxPts.length; i++)
            this._maxPts[i].drawHighLight(d, c, false);
    }
    getLocalMinMax(area) {
        var s;
        var s2;
        var e;
        s = s2 = (this._start * Math.PI / 180);
        e = (this._end * Math.PI / 180);
        var angl;
        if (s > e)
            angl = (Math.PI * 2 - (s - e));
        else
            angl = e - s;
        while (s2 >= Math.PI)
            s2 -= Math.PI * 2;
        var minx = Number.POSITIVE_INFINITY;
        var miny = Number.POSITIVE_INFINITY;
        var maxx = Number.NEGATIVE_INFINITY;
        var maxy = Number.NEGATIVE_INFINITY;
        if (Math.abs(s - e) < MathUtil.EPS) {
            minx = this.mCp.x - this._r;
            maxx = this.mCp.x + this._r;
            miny = this.mCp.y - this._r;
            maxy = this.mCp.y + this._r;
        }
        else {
            if (s <= 0 && s + angl >= 0)
                maxx = this.mCp.x + this._r;
            if (s <= Math.PI * 2 && s + angl >= Math.PI * 2)
                maxx = this.mCp.x + this._r;
            if (s <= (Math.PI / 2) && s + angl >= (Math.PI / 2))
                maxy = this.mCp.y + this._r;
            if (s <= (Math.PI / 2 + Math.PI * 2) && s + angl >= (Math.PI / 2 + Math.PI * 2))
                maxy = this.mCp.y + this._r;
            if (s <= Math.PI && s + angl >= Math.PI)
                minx = this.mCp.x - this._r;
            if (s <= Math.PI + Math.PI * 2 && s + angl >= Math.PI + Math.PI * 2)
                minx = this.mCp.x - this._r;
            if (s <= (Math.PI / 2) * 3 && s + angl >= (Math.PI / 2) * 3)
                miny = this.mCp.y - this._r;
            if (s <= (Math.PI / 2) * 3 + Math.PI * 2 && s + angl >= (Math.PI / 2) * 3 + Math.PI * 2)
                miny = this.mCp.y - this._r;
            minx = Math.min(minx, this.mCp.x + (this._r * Math.cos(s)));
            miny = Math.min(miny, this.mCp.y + (this._r * Math.sin(s)));
            maxx = Math.max(maxx, this.mCp.x + (this._r * Math.cos(e)));
            maxy = Math.max(maxy, this.mCp.y + (this._r * Math.sin(e)));
        }
        area.updateMinMax(minx, miny);
        area.updateMinMax(maxx, maxy);
    }
    /**
     * 一番近いコントロールポイントの取得
     * @return Object	一番近いコントロールポイント
    **/
    getNearControlPoint(x, y) {
        var min = Number.POSITIVE_INFINITY;
        var p = null;
        for (var i = 0; i < this._maxPts.length; i++) {
            let p1 = this._maxPts[i];
            let len = p1.getDistanceToPoint(x, y);
            if (len < min) {
                min = len;
                p = p1;
            }
        }
        return p;
    }
    /**
     * コントロールポイントの移動
     * @param cp　コントロールポイント
     * @param x	移動先ｘ
     * @param y	移動先ｙ
    **/
    moveControlPoint(cp, x, y) {
        var r = MathUtil.getLength2D(x, y, this.mCp.x, this.mCp.y);
        this._r = r;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }
    flipx(x, ofsx) {
        this.mCp.flipx(x, ofsx);
        this._start = MathUtil.getAngl360((180 - this._start));
        this._end = MathUtil.getAngl360((180 - this._end));
        var tmp = this._start;
        this._start = this._end;
        this._end = tmp;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }
    flipy(y, ofsy) {
        this.mCp.flipy(y, ofsy);
        this._start = MathUtil.getAngl360((-this._start));
        this._end = MathUtil.getAngl360((-this._end));
        var tmp = this._start;
        this._start = this._end;
        this._end = tmp;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }
    rot(x, y, ofsx, ofsy) {
        this.mCp.rot(x, y, ofsx, ofsy);
        this._start = MathUtil.getAngl360(this._start + 90);
        this._end = MathUtil.getAngl360(this._end + 90);
        if (Math.abs(this._start - this._end) < MathUtil.EPS)
            this._start = this._end = 0;
        while (this._start >= 360)
            this._start -= 360;
        while (this._start < 0)
            this._start += 360;
        while (this._end >= 360)
            this._end -= 360;
        while (this._end < 0)
            this._end += 360;
        this.area.maximize();
        this.updateMinMax(this.area);
        this.updateMaxPoints();
    }
    setFillMode(fill) {
        this.mFill = fill;
    }
    isFillMode() {
        return this.mFill;
    }
    /**
     * @return Returns the mFillColor.**/
    getFillColor() {
        return this.mFillColor;
    }
    /**
     * @param fillColor The mFillColor to set.**/
    setFillColor(fillColor) {
        this.mFillColor = fillColor;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getCX()
    **/
    getCX() {
        return this.mCp.getX();
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getCY()
    **/
    getCY() {
        return this.mCp.getY();
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#getRadius()
    **/
    getRadius() {
        return this._r;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#isCw()
    **/
    isCw() {
        return false;
    }
    /**
     * @param cw
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCw(boolean)
    **/
    setCw(cw) {
    }
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCX(double)
    **/
    setCX(x) {
        this.mCp.setX(x);
    }
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setCY(double)
    **/
    setCY(y) {
        this.mCp.setY(y);
    }
    /**
     * @param radius
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureArc#setRadius(double)
    **/
    setRadius(radius) {
        this._r = radius;
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getX1()
    **/
    getX1() {
        return this.mCp.x + this._r * Math.cos(this._start * MathUtil.D2R);
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getX2()
    **/
    getX2() {
        return this.mCp.x + this._r * Math.cos(this._end * MathUtil.D2R);
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getY1()
    **/
    getY1() {
        return this.mCp.y + this._r * Math.sin(this._start * MathUtil.D2R);
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/17
     * @see com.kt.geom.K2DPathFigureLine#getY2()
    **/
    getY2() {
        return this.mCp.y + this._r * Math.sin(this._end * MathUtil.D2R);
    }
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX1(double)
    **/
    setX1(x) {
    }
    /**
     * @param x
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setX2(double)
    **/
    setX2(x) {
    }
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY1(double)
    **/
    setY1(y) {
    }
    /**
     * @param y
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigureLine#setY2(double)
    **/
    setY2(y) {
    }
    /**
     * @return
     * @author kawae
     * @since 2006/01/18
     * @see com.kt.geom.K2DPathFigure#getType()
    **/
    getType() {
        return K2DFigureType.ARC_CCW;
    }
}
GCircle.GEOMNAME = "CIRCLE";
//# sourceMappingURL=GCircle.js.map