import { ObjectFolder } from 'kiteclib';
import { SymbolAttribute } from './SymbolAttribute';
//module nethome.geom
/**
 * シンボルの属性コレクション
 * @author kawae
**/
export class SymbolAttributeCollection {
    /**
     * コンストラクタ**/
    constructor() {
        this.mAttributes = new Array();
    }
    /**
     * コピーの取得
     * @return
    **/
    getCopy() {
        var sac = new SymbolAttributeCollection();
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            sac.mAttributes.push(sa.getCopy());
        }
        return sac;
    }
    addAttribute(key, val, copybuffer) {
        if (key instanceof SymbolAttribute) {
            this.mAttributes.push(key);
        }
        var a = new SymbolAttribute();
        a.mKey = key;
        a.mValue = val;
        a.mCopyBuffer = copybuffer;
        this.mAttributes.push(a);
    }
    /**
     * アトリビュートの取得
     * @param key
     * @return
    **/
    getAttributes() {
        return this.mAttributes;
    }
    /**
     * キーが存在するか
     * @param key
     * @return
    **/
    hasAttribute(key) {
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            if (sa.mKey.toLowerCase() === key.toLowerCase())
                return true;
        }
        return false;
    }
    /**
     * キーの削除
     * @param key
    **/
    getAttribute(key) {
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            if (sa.mKey.toLowerCase() == key.toLowerCase())
                return sa;
        }
        return null;
    }
    /**
     * キーの削除
     * @param key
    **/
    removeAttributeKey(key) {
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            if (sa.mKey.toLowerCase() == key.toLowerCase()) {
                this.mAttributes.splice(i, 1);
                i--;
            }
        }
    }
    /**
     * キーの削除
     * @param key
    **/
    removeAttribute(sa) {
        let i = this.mAttributes.indexOf(sa);
        if (i >= 0) {
            this.mAttributes.splice(i, 1);
        }
    }
    /**
     * 保存
     * @param w
     * @param space
     * @throws Exception
    **/
    save(savenode) {
        savenode.setName("SYMBOLATTRIBUTES");
        for (var i = 0; i < this.mAttributes.length; i++) {
            var sa = this.mAttributes[i];
            var of = new ObjectFolder("");
            sa.save(of);
            savenode.addChild(of, true);
        }
    }
}
//# sourceMappingURL=SymbolAttributeCollection.js.map