//module nethome.geom
/**
 * @author kawae
 **/
export class SymbolAttribute {
    constructor() {
        /**
         * コピー操作時に属性もバッファするかのフラグ **/
        this.mCopyBuffer = true;
    }
    static readData(of, version) {
        var sa = new SymbolAttribute();
        var on = null;
        if ((on = of.getNode("KEY")) != null)
            sa.mKey = on.getString();
        if ((on = of.getNode("VALUE")) != null)
            sa.mValue = on.getString();
        if ((on = of.getNode("COPYBUFFER")) != null)
            sa.mCopyBuffer = on.getInt() > 0;
        return sa;
    }
    getCopy() {
        var sa = new SymbolAttribute();
        sa.mCopyBuffer = this.mCopyBuffer;
        sa.mKey = this.mKey;
        sa.mValue = this.mValue;
        return sa;
    }
    /**
     * データの保存
     * @param savename
    **/
    save(savename) {
        if (savename == null)
            return;
        savename.setName("ATTRIBUTE");
        savename.addNode("KEY", this.mKey);
        savename.addNode("VALUE", this.mValue);
        savename.addNode("COPYBUFFER", this.mCopyBuffer);
    }
    isSetCopyBuffer() {
        return this.mCopyBuffer;
    }
}
//# sourceMappingURL=SymbolAttribute.js.map