///<reference path='../../typings/bundle.d.ts' />
import { ObjectFolder } from 'kiteclib';
import { LocalAxis2Df } from './LocalAxis2Df';
//module nethome.geom
function equal(expect, actual, eps) {
    QUnit.ok(Math.abs(expect - actual) <= eps);
}
QUnit.test("testLocalAxis2Df()", function () {
    var la = new LocalAxis2Df();
    QUnit.ok(true);
});
QUnit.test("testGetScaleX()", function () {
    var la = new LocalAxis2Df();
    equal(1, la.getScaleX(), 0);
});
QUnit.test("testGetScaleY()", function () {
    var la = new LocalAxis2Df();
    equal(1, la.getScaleY(), 0);
});
QUnit.test("testSetScaleX()", function () {
    var la = new LocalAxis2Df();
    la.setScaleX(10.0, true);
    equal(1.0, la.getScaleX(), 0);
    la.setScaleX(10.0, false);
    equal(1.0, la.getScaleX(), 0);
    la.setScaleEnable(false, true);
    la.setScaleX(10.0, true);
    equal(1.0, la.getScaleX(), 0);
    la.setScaleEnable(true, false);
    la.setScaleX(5.0, true);
    equal(5.0, la.getScaleX(), 0);
    equal(5.0, la.getScaleY(), 0);
    la.setScaleEnable(true, true);
    la.setScaleX(2.0, true);
    equal(2.0, la.getScaleX(), 0);
    equal(2.0, la.getScaleY(), 0);
    la.setScaleEnable(true, true);
    la.setScaleX(4.0, false);
    equal(4.0, la.getScaleX(), 0);
    equal(2.0, la.getScaleY(), 0);
});
QUnit.test("testSetScaleY()", function () {
    var la = new LocalAxis2Df();
    la.setScaleY(10.0, true);
    equal(1.0, la.getScaleY(), 0);
    la.setScaleY(10.0, false);
    equal(1.0, la.getScaleY(), 0);
    la.setScaleEnable(true, false);
    la.setScaleY(10.0, true);
    equal(1.0, la.getScaleY(), 0);
    la.setScaleEnable(false, true);
    la.setScaleY(5.0, true);
    equal(5.0, la.getScaleX(), 0);
    equal(5.0, la.getScaleY(), 0);
    la.setScaleEnable(true, true);
    la.setScaleY(2.0, true);
    equal(2.0, la.getScaleX(), 0);
    equal(2.0, la.getScaleY(), 0);
    la.setScaleEnable(true, true);
    la.setScaleY(4.0, false);
    equal(2.0, la.getScaleX(), 0);
    equal(4.0, la.getScaleY(), 0);
});
QUnit.test("testSetScale()", function () {
    var la = new LocalAxis2Df();
    la.setScaleEnable(true, true);
    la.setScale(2.0, 2.0);
    equal(2.0, la.getScaleX(), 0);
    equal(2.0, la.getScaleY(), 0);
    la.setScaleEnable(true, false);
    la.setScale(3.0, 3.0);
    equal(3.0, la.getScaleX(), 0);
    equal(3.0, la.getScaleY(), 0);
    la.setScaleEnable(false, true);
    la.setScale(4.0, 4.0);
    equal(4.0, la.getScaleX(), 0);
    equal(4.0, la.getScaleY(), 0);
    la.setScaleEnable(false, false);
    la.setScale(5.0, 5.0);
    equal(1.0, la.getScaleX(), 0);
    equal(1.0, la.getScaleY(), 0);
});
QUnit.test("testSetScaleEnable()", function () {
    var la = new LocalAxis2Df();
    la.setScaleEnable(true, true);
    la.setScale(2.0, 2.0);
    equal(2.0, la.getScaleX(), 0);
    equal(2.0, la.getScaleY(), 0);
    QUnit.equal(true, la.isScaleEnableX());
    QUnit.equal(true, la.isScaleEnableY());
    la.setScaleEnable(false, true);
    equal(2.0, la.getScaleX(), 0);
    equal(2.0, la.getScaleY(), 0);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(true, la.isScaleEnableY());
    la.setScaleEnable(true, false);
    QUnit.equal(true, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
    la.setScaleEnable(false, false);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
});
QUnit.test("testIsScaleEnableX()", function () {
    var la = new LocalAxis2Df();
    QUnit.equal(false, la.isScaleEnableX());
});
QUnit.test("testIsScaleEnableY()", function () {
    var la = new LocalAxis2Df();
    QUnit.equal(false, la.isScaleEnableY());
});
QUnit.test("testLocalAxis2DfFloatFloatFloatFloat()", function () {
    var la;
    la = new LocalAxis2Df(0, 0, 1, 0);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
    QUnit.equal(false, la.getFlipX());
    QUnit.equal(false, la.getFlipY());
    equal(0, la.mX, 0);
    equal(0, la.mY, 0);
    equal(0, la.mRot, 0.1);
    la = new LocalAxis2Df(100, 200, 100, 300);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
    equal(1, la.getScaleX(), 0);
    equal(1, la.getScaleY(), 0);
    QUnit.equal(false, la.getFlipX());
    QUnit.equal(false, la.getFlipY());
    equal(100, la.mX, 0);
    equal(200, la.mY, 0);
    equal(Math.PI / 2, la.mRot, 0.1);
    la = new LocalAxis2Df(100, 200, 100, 199);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
    equal(1, la.getScaleX(), 0);
    equal(1, la.getScaleY(), 0);
    QUnit.equal(false, la.getFlipX());
    QUnit.equal(false, la.getFlipY());
    equal(100, la.mX, 0);
    equal(200, la.mY, 0);
    equal(Math.PI * 1.5, la.mRot, 0.1);
});
QUnit.test("testLocalAxis2DfLocalAxis2Df()", function () {
    var la;
    var la2;
    la = new LocalAxis2Df(0, 0, 1, 0);
    la2 = new LocalAxis2Df(la);
    QUnit.ok(la.equals(la2));
    QUnit.equal(la.isScaleEnableX(), la2.isScaleEnableX());
    QUnit.equal(la.isScaleEnableY(), la2.isScaleEnableY());
    equal(la.getScaleX(), la2.getScaleX(), 0);
    equal(la.getScaleY(), la2.getScaleY(), 0);
    QUnit.equal(la.getFlipX(), la2.getFlipX());
    QUnit.equal(la.getFlipY(), la2.getFlipY());
    equal(la.mX, la2.mX, 0);
    equal(la.mY, la2.mY, 0);
    equal(la.mRot, la2.mRot, 0);
});
QUnit.test("testReadData()", function () {
    var la = new LocalAxis2Df(100, 200, 100, 205);
    var of = new ObjectFolder("");
    la.save(of);
    try {
        var la2 = LocalAxis2Df.readData(of);
        QUnit.ok(la.equals(la2));
    }
    catch (e) {
        QUnit.ok(false, e.getMessage());
    }
});
QUnit.test("testSave()", function () {
    var la = new LocalAxis2Df(100, 200, 100, 205);
    var of = new ObjectFolder("");
    la.save(of);
    QUnit.equal(false, of.getName().length == 0);
    QUnit.equal(true, of.getChildren().length > 0);
});
QUnit.test("testSetLocalCoordinatesFloatFloatFloatFloatBooleanBoolean()", function () {
    var la = new LocalAxis2Df();
    la.setLocalCoordinates(100, 200, 100, 300, false, false);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
    equal(1, la.getScaleX(), 0);
    equal(1, la.getScaleY(), 0);
    QUnit.equal(false, la.getFlipX());
    QUnit.equal(false, la.getFlipY());
    equal(100, la.mX, 0);
    equal(200, la.mY, 0);
    equal(Math.PI / 2, la.mRot, 0.1);
    la.setLocalCoordinates(100, 200, 100, 200, false, false);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
    equal(1, la.getScaleX(), 0);
    equal(1, la.getScaleY(), 0);
    QUnit.equal(false, la.getFlipX());
    QUnit.equal(false, la.getFlipY());
    equal(100, la.mX, 0);
    equal(200, la.mY, 0);
    QUnit.ok(isNaN(la.mRot));
});
QUnit.test("testSetLocalCoordinatesFloatFloatFloatBooleanBoolean()", function () {
    var la = new LocalAxis2Df();
    la.setLocalCoordinatesRot(-10.3, -1.5, Math.PI, true, true);
    QUnit.equal(false, la.isScaleEnableX());
    QUnit.equal(false, la.isScaleEnableY());
    equal(1, la.getScaleX(), 0);
    equal(1, la.getScaleY(), 0);
    QUnit.equal(true, la.getFlipX());
    QUnit.equal(true, la.getFlipY());
    equal(-10.3, la.mX, 0);
    equal(-1.5, la.mY, 0);
    equal(Math.PI, la.mRot, 0.1);
});
QUnit.test("testSetLocalCoordinatesLocalAxis2Df()", function () {
    var la = new LocalAxis2Df();
    la.setLocalCoordinatesRot(-10.3, -1.5, Math.PI, true, true);
    var la2 = new LocalAxis2Df();
    QUnit.equal(false, la.equals(la2));
    la2.setLocalCoordinatesLc(la);
    QUnit.equal(true, la.equals(la2));
});
QUnit.test("testGetFlipX()", function () {
    var la = new LocalAxis2Df();
    QUnit.equal(false, la.getFlipX());
    la.setFlipX(true);
    QUnit.equal(true, la.getFlipX());
    la.setFlipX(false);
    QUnit.equal(false, la.getFlipX());
});
QUnit.test("testSetFlipX()", function () {
    var la = new LocalAxis2Df();
    la.setFlipX(true);
    la.setFlipX(false);
    QUnit.ok(true);
});
QUnit.test("testGetFlipY()", function () {
    var la = new LocalAxis2Df();
    QUnit.equal(false, la.getFlipY());
    la.setFlipY(true);
    QUnit.equal(true, la.getFlipY());
    la.setFlipY(false);
    QUnit.equal(false, la.getFlipY());
});
QUnit.test("testSetFlipY()", function () {
    var la = new LocalAxis2Df();
    la.setFlipY(true);
    la.setFlipY(false);
    QUnit.ok(true);
});
QUnit.test("testGetGlobalXYFloat()", function () {
    var la;
    la = new LocalAxis2Df();
    equal(0, la.getGlobalX(0.0, 0.0), 0.1);
    equal(0, la.getGlobalY(0.0, 0.0), 0.1);
    equal(10, la.getGlobalX(10.0, 0.0), 0.1);
    equal(0, la.getGlobalY(10.0, 0.0), 0.1);
    equal(10, la.getGlobalX(10.0, 10.0), 0.1);
    equal(10, la.getGlobalY(10.0, 10.0), 0.1);
    la = new LocalAxis2Df(5, 15, 6, 15);
    equal(5, la.getGlobalX(0.0, 0.0), 0.1);
    equal(15, la.getGlobalY(0.0, 0.0), 0.1);
    equal(25, la.getGlobalX(20.0, 0.0), 0.1);
    equal(15, la.getGlobalY(20.0, 0.0), 0.1);
    equal(25, la.getGlobalX(20.0, 10.0), 0.1);
    equal(25, la.getGlobalY(20.0, 10.0), 0.1);
    la = new LocalAxis2Df(5, 15, 5, 20);
    equal(5, la.getGlobalX(0.0, 0.0), 0.1);
    equal(15, la.getGlobalY(0.0, 0.0), 0.1);
    equal(5, la.getGlobalX(10.0, 0.0), 0.1);
    equal(25, la.getGlobalY(10.0, 0.0), 0.1);
    equal(-5, la.getGlobalX(0.0, 10.0), 0.1);
    equal(15, la.getGlobalY(0.0, 10.0), 0.1);
    la = new LocalAxis2Df();
    la.setFlipX(true);
    equal(0, la.getGlobalX(0.0, 0.0), 0.1);
    equal(0, la.getGlobalY(0.0, 0.0), 0.1);
    equal(-10, la.getGlobalX(10.0, 0.0), 0.1);
    equal(0, la.getGlobalY(10.0, 0.0), 0.1);
    equal(0, la.getGlobalX(0.0, 10.0), 0.1);
    equal(10, la.getGlobalY(0.0, 10.0), 0.1);
    la = new LocalAxis2Df(0, 0, 0, 1);
    la.setFlipX(true);
    la.setFlipY(true);
    equal(0, la.getGlobalX(0.0, 0.0), 0.1);
    equal(0, la.getGlobalY(0.0, 0.0), 0.1);
    equal(0, la.getGlobalX(10.0, 0.0), 0.1);
    equal(-10, la.getGlobalY(10.0, 0.0), 0.1);
    equal(20, la.getGlobalX(0.0, 20.0), 0.1);
    equal(0, la.getGlobalY(0.0, 20.0), 0.1);
});
QUnit.test("testGetScaledXY()", function () {
    var la;
    la = new LocalAxis2Df();
    equal(0, la.getScaledX(0.0, 0.0, false, true, true, 0, 0), 0.1);
    equal(0, la.getScaledY(0.0, 0.0, false, true, true, 0, 0), 0.1);
    la = new LocalAxis2Df(5, 15, 5, 20);
    equal(0, la.getScaledX(0.0, 0.0, false, true, true, 0, 0), 0.1);
    equal(0, la.getScaledY(0.0, 0.0, false, true, true, 0, 0), 0.1);
});
QUnit.test("testGetGlobalXY()", function () {
    var la;
    la = new LocalAxis2Df();
    equal(0, la.getGlobalX(0.0, 0.0, false, true, true, 0, 0), 0.1);
    equal(0, la.getGlobalY(0.0, 0.0, false, true, true, 0, 0), 0.1);
    la = new LocalAxis2Df(5, 15, 5, 20);
    equal(5, la.getGlobalX(0.0, 0.0, false, true, true, 0, 0), 0.1);
    equal(15, la.getGlobalY(0.0, 0.0, false, true, true, 0, 0), 0.1);
    la = new LocalAxis2Df(5, 15, 5, 20);
    equal(1, la.getGlobalX(2.0, 4.0, false, true, true, 1, 0), 0.1);
    equal(17, la.getGlobalY(2.0, 4.0, false, true, true, 1, 0), 0.1);
});
QUnit.test("testGetGlobalLength()", function () {
    var la;
    la = new LocalAxis2Df();
    equal(10.0, la.getGlobalLength(10.0), 0.1);
    la.setScaleEnable(true, true);
    la.setScale(5, 3);
    equal(50.0, la.getGlobalLength(10.0), 0.1);
});
QUnit.test("testGetLocalXY()", function () {
    var la;
    la = new LocalAxis2Df();
    equal(0, la.getLocalX(0.0, 0.0), 0.1);
    equal(0, la.getLocalY(0.0, 0.0), 0.1);
    la = new LocalAxis2Df(5, 15, 5, 20);
    equal(0, la.getLocalX(5.0, 15.0), 0.1);
    equal(0, la.getLocalY(5.0, 15.0), 0.1);
    la = new LocalAxis2Df(5, 15, 5, 20);
    equal(0, la.getLocalX(5.0, 15.0), 0.1);
    equal(0, la.getLocalY(5.0, 15.0), 0.1);
    equal(10, la.getLocalX(5.0, 25.0), 0.1);
    equal(0, la.getLocalY(5.0, 25.0), 0.1);
    equal(0, la.getLocalX(-5.0, 15.0), 0.1);
    equal(10, la.getLocalY(-5.0, 15.0), 0.1);
});
QUnit.test("testGetGlobalAngl()", function () {
    var la;
    la = new LocalAxis2Df();
    equal(0, la.getGlobalAngl(0.0), 0.1);
    equal(Math.PI, la.getGlobalAngl(Math.PI), 0.1);
    la.setLocalCoordinatesRot(0, 0, 1, false, false);
    equal(1, la.getGlobalAngl(0.0), 0.1);
    equal(2, la.getGlobalAngl(1.0), 0.1);
});
//QUnit.test("testHashCode()", function () {
//    var la: LocalAxis2Df = new LocalAxis2Df(0, 0, 1, 0);
//    var la2: LocalAxis2Df = new LocalAxis2Df(0, 0, 1, 0);
//    QUnit.equal(la.hashCode(), la2.hashCode());
//});
QUnit.test("testEquals()", function () {
    var la;
    var la2;
    var la3;
    la = new LocalAxis2Df(0, 0, 1, 0);
    la2 = new LocalAxis2Df(0, 0, 1, 0);
    la3 = new LocalAxis2Df(10, 10, 0, 10);
    QUnit.equal(la.isScaleEnableX(), la2.isScaleEnableX());
    QUnit.equal(la.isScaleEnableY(), la2.isScaleEnableY());
    equal(la.getScaleX(), la2.getScaleX(), 0);
    equal(la.getScaleY(), la2.getScaleY(), 0);
    QUnit.equal(la.getFlipX(), la2.getFlipX());
    QUnit.equal(la.getFlipY(), la2.getFlipY());
    equal(la.mX, la2.mX, 0);
    equal(la.mY, la2.mY, 0);
    equal(la.mRot, la2.mRot, 0);
    QUnit.equal(true, la.equals(la2));
    QUnit.equal(true, la.equals(la));
    QUnit.equal(false, la.equals(null));
    QUnit.equal(false, la.equals(la3));
});
//# sourceMappingURL=LocalAxis2DfTest.js.map