import { MathUtil } from 'kiteclib';
//module nethome.geom
/**
 * ローカル座標系**/
export class LocalAxis2Df {
    //{
    //    this.setLocalCoordinates(lc.mX, lc.mY, lc.mRot, lc.mFlipX, lc.mFlipY);
    //    this.setScale(lc.mScaleX, lc.mScaleY);
    //    this.setScaleEnable(lc.scaleEnableX, lc.scaleEnableY);
    //}
    constructor(x1OrLc, y1, x2, y2) {
        /**
         * XY軸の反転 **/
        this.mFlipX = false;
        this.mFlipY = false;
        /**
         * 横方向変形可能フラグ **/
        this.scaleEnableX = false;
        /**
         * 縦方向変形可能フラグ **/
        this.scaleEnableY = false;
        /**
         * 拡大率 **/
        this.mScaleX = 1.0;
        this.mScaleY = 1.0;
        if (x1OrLc === undefined) {
            this.mX = 0;
            this.mY = 0;
            this.mRot = 0;
            this.mFlipX = this.mFlipY = false;
        }
        else if (typeof x1OrLc === "number") {
            var x1 = x1OrLc;
            this.mFlipX = this.mFlipY = false;
            this.scaleEnableX = this.scaleEnableY = false;
            this.setLocalCoordinates(x1, y1, x2, y2, this.mFlipX, this.mFlipY);
        }
        else {
            var lc = x1OrLc;
            this.setLocalCoordinatesLc(lc);
        }
    }
    /**
     * 横方向のサイズの取得
     * @return
    **/
    getScaleX() {
        return this.mScaleX;
    }
    /**
     * 縦方向のサイズの取得
     * @return
    **/
    getScaleY() {
        return this.mScaleY;
    }
    setScaleX(x, aspect) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleX = this.mScaleY = 1.0;
            return;
        }
        else if (!this.scaleEnableX) {
            this.mScaleX = 1.0;
            return;
        }
        this.mScaleX = x;
        if (aspect)
            this.mScaleY = x;
    }
    setScaleY(y, aspect) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleX = this.mScaleY = 1.0;
            return;
        }
        else if (!this.scaleEnableY) {
            this.mScaleY = 1.0;
            return;
        }
        this.mScaleY = y;
        if (aspect)
            this.mScaleX = y;
    }
    setScale(x, y) {
        if (!this.scaleEnableX && !this.scaleEnableY) {
            this.mScaleX = this.mScaleY = 1.0;
            return;
        }
        this.mScaleX = x;
        this.mScaleY = y;
    }
    setScaleEnable(x, y) {
        this.scaleEnableX = x;
        this.scaleEnableY = y;
    }
    isScaleEnableX() {
        return this.scaleEnableX;
    }
    isScaleEnableY() {
        return this.scaleEnableY;
    }
    /**
     * 読み込み(2005/06/09追加)
     * @param of
     * @param version
     * @return
     * @throws Exception
     * @author kawae
     * @since 2005/06/09
    **/
    static readData(of) {
        var cx = 0;
        var cy = 0;
        var angl = 0;
        var scalex = 1;
        var scaley = 1;
        var fx = false;
        var fy = false;
        var on = null;
        if ((on = of.getNode("cx")) != null)
            cx = on.getDouble();
        if ((on = of.getNode("cy")) != null)
            cy = on.getDouble();
        if ((on = of.getNode("angl")) != null)
            angl = on.getDouble();
        if ((on = of.getNode("fx")) != null)
            fx = on.getString() == "true";
        if ((on = of.getNode("fy")) != null)
            fy = on.getString() == "true";
        if ((on = of.getNode("scalex")) != null)
            scalex = on.getDouble();
        if ((on = of.getNode("scaley")) != null)
            scaley = on.getDouble();
        var la = new LocalAxis2Df();
        la.mX = cx;
        la.mY = cy;
        la.mRot = angl;
        la.mFlipX = fx;
        la.mFlipY = fy;
        la.mScaleX = scalex;
        la.mScaleY = scaley;
        return la;
    }
    /**
     * データの保存
     * @param parent
    **/
    save(parent) {
        if (parent == null)
            return;
        parent.setName("AXIS");
        parent.addNode("cx", this.mX);
        parent.addNode("cy", this.mY);
        parent.addNode("angl", this.mRot);
        parent.addNode("fx", this.mFlipX.toString());
        parent.addNode("fy", this.mFlipY.toString());
        parent.addNode("scalex", this.mScaleX);
        parent.addNode("scaley", this.mScaleY);
    }
    setLocalCoordinates(x1, y1, x2, y2, fx, fy) {
        this.setLocalCoordinatesRot(x1, y1, MathUtil.getAngle2D(x1, y1, x2, y2), fx, fy);
    }
    setLocalCoordinatesRot(x, y, rot, fx, fy) {
        this.mX = x;
        this.mY = y;
        this.mRot = rot;
        this.mFlipX = fx;
        this.mFlipY = fy;
    }
    setLocalCoordinatesLc(lc) {
        this.mX = lc.mX;
        this.mY = lc.mY;
        this.mRot = lc.mRot;
        this.mFlipX = lc.mFlipX;
        this.mFlipY = lc.mFlipY;
        this.mScaleX = lc.mScaleX;
        this.mScaleY = lc.mScaleY;
        this.scaleEnableX = lc.scaleEnableX;
        this.scaleEnableY = lc.scaleEnableY;
    }
    getFlipX() {
        return this.mFlipX;
    }
    setFlipX(f) {
        this.mFlipX = f;
    }
    getFlipY() {
        return this.mFlipY;
    }
    setFlipY(f) {
        this.mFlipY = f;
    }
    ///**
    // * ローカル座標->Xグローバル座標**/
    //getGlobalX(x : number, y : number) : number {
    //    if (this.mFlipX) x = -x;
    //    if (this.mFlipY) y = -y;
    //    var val : number = x * Math.cos(this.mRot) - y * Math.sin(this.mRot) + this.mX;
    //    return val;
    //}
    ///**
    // * ローカル座標->Yグローバル座標**/
    //getGlobalY(x : number, y : number) : number {
    //    if (this.mFlipX) x = -x;
    //    if (this.mFlipY) y = -y;
    //    var val : number = x * Math.sin(this.mRot) + y * Math.cos(this.mRot) + this.mY;
    //    return val;
    //}
    getScaledX(x, y, keepaspect, sx, sy, bx, by) {
        var scalex;
        if (keepaspect) {
            if (!this.scaleEnableX && !this.scaleEnableY)
                scalex = 1.0;
            else if (this.scaleEnableX && this.scaleEnableY)
                scalex = Math.max(this.mScaleX, this.mScaleY);
            else if (this.scaleEnableX)
                scalex = this.mScaleX;
            else
                scalex = this.mScaleY;
        }
        else {
            scalex = sx ? this.mScaleX : 1.0;
        }
        var xx = (x - bx) * scalex;
        var val = (xx + bx);
        return val;
    }
    getScaledY(x, y, keepaspect, sx, sy, bx, by) {
        var scaley;
        if (keepaspect) {
            if (!this.scaleEnableX && !this.scaleEnableY)
                scaley = 1.0;
            else if (this.scaleEnableX && this.scaleEnableY)
                scaley = Math.max(this.mScaleX, this.mScaleY);
            else if (this.scaleEnableX)
                scaley = this.mScaleX;
            else
                scaley = this.mScaleY;
        }
        else {
            scaley = sy ? this.mScaleY : 1.0;
        }
        var yy = (y - by) * scaley;
        var val = (yy + by);
        return val;
    }
    /**
     * ローカル座標->Xグローバル座標(拡大縮小フラグ有り)**/
    getGlobalX(x, y, keepaspect = false, sx = false, sy = false, bx = 0, by = 0) {
        var scalex;
        var scaley;
        if (keepaspect) {
            if (!this.scaleEnableX && !this.scaleEnableY)
                scalex = scaley = 1.0;
            else if (this.scaleEnableX && this.scaleEnableY)
                scalex = scaley = Math.max(this.mScaleX, this.mScaleY);
            else if (this.scaleEnableX)
                scalex = scaley = this.mScaleX;
            else
                scalex = scaley = this.mScaleY;
        }
        else {
            scalex = sx ? this.mScaleX : 1.0;
            scaley = sy ? this.mScaleY : 1.0;
        }
        var xx = (x - bx) * scalex;
        var yy = (y - by) * scaley;
        if (this.mFlipX) {
            xx = -xx;
            bx = -bx;
        }
        if (this.mFlipY) {
            yy = -yy;
            by = -by;
        }
        var val = (xx + bx) * Math.cos(this.mRot) - (yy + by) * Math.sin(this.mRot) + this.mX;
        return val;
    }
    /**
     * ローカル座標->Yグローバル座標(拡大縮小フラグ有り)**/
    getGlobalY(x, y, keepaspect = false, sx = false, sy = false, bx = 0, by = 0) {
        var scalex;
        var scaley;
        if (keepaspect) {
            if (!this.scaleEnableX && !this.scaleEnableY)
                scalex = scaley = 1.0;
            else if (this.scaleEnableX && this.scaleEnableY)
                scalex = scaley = Math.max(this.mScaleX, this.mScaleY);
            else if (this.scaleEnableX)
                scalex = scaley = this.mScaleX;
            else
                scalex = scaley = this.mScaleY;
        }
        else {
            scalex = sx ? this.mScaleX : 1.0;
            scaley = sy ? this.mScaleY : 1.0;
        }
        var xx = (x - bx) * scalex;
        var yy = (y - by) * scaley;
        if (this.mFlipX) {
            xx = -xx;
            bx = -bx;
        }
        if (this.mFlipY) {
            yy = -yy;
            by = -by;
        }
        var val = (xx + bx) * Math.sin(this.mRot) + (yy + by) * Math.cos(this.mRot) + this.mY;
        return val;
    }
    getGlobalLength(len) {
        return len * this.mScaleX;
    }
    /**
     * グローバル座標->Xローカル座標**/
    getLocalX(x, y) {
        var val = (x - this.mX) * Math.cos(-this.mRot) - (y - this.mY) * Math.sin(-this.mRot);
        if (this.mFlipX)
            val = -val;
        return val;
    }
    /**
     * グローバル座標->Xローカル座標**/
    getLocalY(x, y) {
        var val = (x - this.mX) * Math.sin(-this.mRot) + (y - this.mY) * Math.cos(-this.mRot);
        if (this.mFlipY)
            val = -val;
        return val;
    }
    getGlobalAngl(rad) {
        rad += this.mRot;
        if (this.mFlipX)
            rad = Math.PI - rad;
        if (this.mFlipY)
            rad = -rad;
        return MathUtil.getAngl2PI(rad);
    }
    //hashCode(): number {
    //    var prime: number = 31;
    //    var result: number = 1;
    //    result = prime * result + (this.mFlipX ? 1231 : 1237);
    //    result = prime * result + (this.mFlipY ? 1231 : 1237);
    //    result = prime * result + HashUtil.hashCode(this.mRot);
    //    result = prime * result + HashUtil.hashCode(this.mScaleX);
    //    result = prime * result + HashUtil.hashCode(this.mScaleY);
    //    result = prime * result + HashUtil.hashCode(this.mX);
    //    result = prime * result + HashUtil.hashCode(this.mY);
    //    result = prime * result + (this.scaleEnableX ? 1231 : 1237);
    //    result = prime * result + (this.scaleEnableY ? 1231 : 1237);
    //    return result;
    //}
    equals(obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        //if (this.getClass() != obj.getClass()) return false;
        var other = (obj);
        if (this.mFlipX !== other.mFlipX)
            return false;
        if (this.mFlipY !== other.mFlipY)
            return false;
        if (this.mRot !== other.mRot)
            return false;
        if (this.mScaleX !== other.mScaleX)
            return false;
        if (this.mScaleY !== other.mScaleY)
            return false;
        if (this.mX !== other.mX)
            return false;
        if (this.mY !== other.mY)
            return false;
        if (this.scaleEnableX != other.scaleEnableX)
            return false;
        if (this.scaleEnableY != other.scaleEnableY)
            return false;
        return true;
    }
}
//# sourceMappingURL=LocalAxis2Df.js.map