/**
 * リンク先オブジェクトインターフェース
 * @author kawae
**/
export interface ILinkTarget {
    /**
     * 特定の点からリンク先への距離の取得**/
    getLinkDistance(x: number, y: number): number;
    /**
     * リンク先の点座標の取得
     * @param px
     * @param py
     * @param rx
     * @param ry
     * @param linktype	リンクするタイプ
     * @param resp		結果座標
     * @return
     * @author kawae
     * @since 2004/10/08
    **/
    getLinkPoint(px: number, py: number, rx: number, ry: number, linktype: number, resp: number[]): boolean;
    /**
     * 点の法線の取得**/
    getNormal(x: number, y: number, resv: number[]): void;
}
