import { MathUtil } from 'kiteclib';
import { NethomeCoreResource } from '../NethomeCoreResource';
import { Geometry } from './primitive/Geometry';
import { GPoint2Df } from './primitive/GPoint2Df';
import { GText } from './primitive/GText';
//module nethome.geom
export class GTextGroup extends Geometry {
    /**
     * コンストラクタ
     * @param p1
     * @param scaleFontLabel
     * @param angl
     * @param size
    **/
    constructor(p1, scaleFontLabel, angl, size) {
        super();
        /**
         * 描画方向 (true:横) **/
        this.mDir = true;
        this.mBackFill = false;
        this.mCp = new GPoint2Df(p1.x, p1.y);
        this.mAngl = angl;
        this.mScaleFont = scaleFontLabel;
        this.mTexts = new Array();
        this.mSize = size;
    }
    /**
     * 描画方向の設定**/
    setDir(dir) {
        this.mDir = dir;
    }
    setBackColor(fill, c) {
        this.mBackFill = fill;
        this.mFillColor = c;
    }
    /**
     * テキストの個数の取得**/
    getTextSize() {
        return this.mTexts.length;
    }
    update() {
        for (let gt of this.mTexts) {
            gt.setFillMode(this.mBackFill, this.mFillColor);
        }
        if (this.mDir) {
            var toth = 0;
            for (let gt of this.mTexts) {
                gt.update();
                toth += (gt.mMaxy - gt.mMiny);
            }
            var y = 0;
            for (let i = 0; i < this.mTexts.length; i++) {
                let gt = this.mTexts[i];
                if (i == 0)
                    y = this.mCp.y + toth / 2;
                gt.mAngl = this.mAngl;
                gt.mCp.x = this.mCp.x;
                gt.mCp.y = y - (gt.mMaxy - gt.mMiny) / 2;
                y = y - (gt.mMaxy - gt.mMiny);
            }
        }
        else {
            var totw = 0;
            for (let i = 0; i < this.mTexts.length; i++) {
                let gt = this.mTexts[i];
                gt.setDir(this.mDir);
                gt.update();
                totw += (gt.mMaxx - gt.mMinx);
            }
            var x = 0;
            for (let i = 0; i < this.mTexts.length; i++) {
                let gt = this.mTexts[i];
                gt.mAngl = this.mAngl;
                gt.mCp.y = this.mCp.y;
                if (NethomeCoreResource.TATEGAKI_DIR) {
                    if (i == 0)
                        x = this.mCp.x - totw / 2;
                    gt.mCp.x = x + (gt.mMaxx - gt.mMinx) / 2;
                    x = x + (gt.mMaxx - gt.mMinx);
                }
                else {
                    if (i == 0)
                        x = this.mCp.x + totw / 2;
                    gt.mCp.x = x - (gt.mMaxx - gt.mMinx) / 2;
                    x = x - (gt.mMaxx - gt.mMinx);
                }
            }
        }
    }
    addText(s, size, bold) {
        if (s == null || s.length == 0)
            return;
        var gt = new GText(new GPoint2Df(), this.mScaleFont, s, 0, size, bold);
        this.mTexts.push(gt);
        this.update();
    }
    /**
     * 全テキストの削除**/
    removeAll() {
        this.mTexts.length = 0;
    }
    getDistanceToPoint(x, y) {
        return MathUtil.getLength2D(x, y, this.mCp.x, this.mCp.y);
    }
    offset(x, y) {
        this.mCp.x += x;
        this.mCp.y += y;
    }
    /**
     * 横反転**/
    flipx(x, ofsx) {
    }
    /**
     * 縦反転**/
    flipy(y, ofsy) {
    }
    //static readData(r: AbstFile, version: number): Object /*Exception*/ {
    //    return null;
    //}
    //drawGeom(d: IRichGraphics): void {
    //    this.drawGeom(d, KColor.BLACK, null);
    //}
    drawGeom(d, fore, back) {
        for (var i = 0; i < this.mTexts.length; i++) {
            var gt = this.mTexts[i];
            gt.drawGeom(d, fore, back);
        }
    }
}
//# sourceMappingURL=GTextGroup.js.map