import { IRichGraphicsConst } from 'kiteclib';
import { GLine } from './primitive/GLine';
import { NethomeCoreLookAndFeel } from '../NethomeCoreLookAndFeel';
import { NethomeCoreResource } from '../NethomeCoreResource';
//module nethome.geom
/**
 * 領域コントロールクラス
 * @author kawae
**/
export class AreaControl {
    /**
     * コンストラクタ**/
    constructor() {
        /**
         * エリアのクローズオプション **/
        this.mClose = true;
        this._points = [];
        this._lines = [];
    }
    /**
     * 初期化**/
    init() {
        this._points.length = 0;
        this._lines.length = 0;
    }
    setCloseMode(f) {
        this.mClose = f;
    }
    getCloseMode() {
        return this.mClose;
    }
    /**
     * 線群の作成**/
    close() {
        var ofs = this.mClose ? 0 : 1;
        this._lines.length = 0;
        for (var i = 0; i < this._points.length - ofs; i++) {
            var p1 = this._points[(i + this._points.length) % this._points.length];
            var p2 = this._points[(i + 1) % this._points.length];
            this._lines.push(new GLine(p1, p2));
        }
    }
    /**
     * 点群の取得
     * @return
    **/
    getPoints() {
        return this._points;
    }
    /**
     * 線群の取得**/
    getLines() {
        return this._lines;
    }
    /**
     * エリアのセット**/
    setArea(a) {
        this._points = [];
        for (var i = 0; i < a.length; i++)
            this._points.push(a[i]);
        this.close();
    }
    drawGeomHilight(d) {
        if (this._points.length || !this.mClose) {
            var ofs = this.mClose ? 0 : 1;
            d.setColor(NethomeCoreLookAndFeel.SELECT_SYMBOL_COLOR);
            for (let i = 0; i < this._points.length - ofs; i++) {
                var p1 = this._points[(i + this._points.length) % this._points.length];
                var p2 = this._points[(i + 1) % this._points.length];
                d.drawLine(p1.x, p1.y, p2.x, p2.y, IRichGraphicsConst.LINE_DASH_1);
            }
            for (let i = 0; i < this._points.length; i++) {
                var pt = this._points[i];
                d.setColor(NethomeCoreLookAndFeel.SELECT_SYMBOL_COLOR);
                d.drawMark(pt.x, pt.y, NethomeCoreResource.MARKER_SIZE, IRichGraphicsConst.MARK_REC_FILL);
                d.setColor(NethomeCoreLookAndFeel.SELECT_SYMBOL_MARK_FRAME_COLOR);
                d.drawMark(pt.x, pt.y, NethomeCoreResource.MARKER_SIZE, IRichGraphicsConst.MARK_REC);
            }
        }
    }
}
//# sourceMappingURL=AreaControl.js.map