import { History } from 'kiteclib';
import { ObjectFolderHistoryDataConverter } from './ObjectFolderHistoryDataConverter';
//module nethome.doc
export class ObjectFolderProjectHistoryManager {
    /**
     * コンストラクタ**/
    constructor(histnum, factory) {
        this.mHistory = new History(histnum, new ObjectFolderHistoryDataConverter(new ObjectFolderProjectProvider(factory), factory));
    }
    setProject(project) {
        this.mProject = project;
    }
    flushHistory() {
        this.mHistory.flushHistory();
    }
    setHistoryObject(o) {
        var hisObj = this.mHistory.getConverter().readHistory(o);
        if (hisObj == null)
            return;
        else {
            this.copyProject(hisObj);
        }
    }
    getLastHistory() {
        return this.mHistory.getLastHistory();
    }
    getCurrentHistory() {
        return this.mHistory.getCurrentHistory();
    }
    undo() {
        var flag = false;
        var hisObj = this.mHistory.undo();
        if (hisObj == null)
            flag = false;
        else {
            this.copyProject(hisObj);
            flag = true;
        }
        if (flag)
            this.mProject.setSaved(false);
        return flag;
    }
    redo() {
        var flag = false;
        var hisObj = this.mHistory.redo();
        if (hisObj == null)
            flag = false;
        else {
            this.copyProject(hisObj);
            flag = true;
        }
        if (flag)
            this.mProject.setSaved(false);
        return flag;
    }
    copyProject(src) {
        var currentIndex = src.getLayers().indexOf(src.getCurrentLayer());
        this.mProject.getLayers().length = 0;
        src.getLayers().forEach(l => this.mProject.getLayers().push(l));
        this.mProject.setCurrentLayer(currentIndex);
    }
    addHistory() {
        this.mProject.getLayers().forEach(l => {
            l.renumberID();
        });
        this.mHistory.addHistory(this.mProject);
        this.mProject.setSaved(false);
    }
    hasUndo() {
        return this.mHistory.hasUndo();
    }
    hasRedo() {
        return this.mHistory.hasRedo();
    }
    setMaxHistory(num) {
        this.mHistory.setMaxHistory(num);
    }
}
class ObjectFolderProjectProvider {
    constructor(factory) {
        this.factory = factory;
    }
    getProject() {
        return this.factory.createNewProject();
    }
}
class ObjectFolderProjectHistoryManager_ProjectProvider {
    constructor(factory) {
        this.factory = factory;
    }
    getProject() {
        return this.factory.createNewProject();
    }
}
//# sourceMappingURL=ObjectFolderProjectHistoryManager.js.map