import { ObjectFolder } from 'kiteclib';
//module nethome.doc
export class ObjectFolderHistoryDataConverter {
    constructor(provider, factory) {
        this.mProvider = provider;
        this.mFactory = factory;
    }
    readHistory(h) {
        try {
            var prj = this.mProvider.getProject();
            prj.load(h, this.mFactory);
            return prj;
        }
        catch (e) {
            //ObjectFolderHistoryDataConverter.log.severe("load error " + e);
            console.log(e);
            return null;
        }
    }
    writeHistory(prj) {
        var of = new ObjectFolder("hist");
        of.addChild(prj.save());
        return of;
    }
}
//# sourceMappingURL=ObjectFolderHistoryDataConverter.js.map