import { DocumentEvent } from './DocumentEvent';
//module nethome.doc
/**
 * ライブラリ用のドキュメントなど、各種ドキュメントを管理する
 * ドキュメント管理クラス。
 * @since 　2003/03/12
 * @author　Kawae
 * @version 2003/03/12
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
export class Document {
    /**
     * すべてのドキュメントを空として、新たな Document を構築する。
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    constructor() {
        this.mProject = null;
        this.mProjects = [];
        this.mListeners = [];
    }
    /**
     * この Document が管理する NetHomeドキュメントを返す。
     * @return NetHomeドキュメント
     * @see #setNh3Doc(DocumentNh3)
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    getProject() {
        return this.mProject;
    }
    /**
     * 指定されたプロジェクトを、この Document が管理する
     * NetHome ドキュメントとして設定する。
     * @param prj	NetHome ドキュメント
     * @see #getProject()
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    setProject(prj) {
        if (this.mProjects.indexOf(prj) < 0)
            this.addProject(prj);
        this.mProject = prj;
    }
    /**
     * 指定されたプロジェクトを、この Document が管理するプロジェクトに追加する。
     * @param prj
    **/
    addProject(prj) {
        this.mProjects.push(prj);
        prj.addProjectListener(this);
    }
    /**
     * 指定されたプロジェクトを、この Document が管理するプロジェクトから削除する。
     * @param prj
    **/
    removeProject(prj) {
        var i = this.mProjects.indexOf(prj);
        if (i >= 0)
            this.mProjects.splice(i, 1);
    }
    /**
     * この Document が管理するプロジェクトのリストを返す。**/
    getProjects() {
        return this.mProjects.slice();
    }
    /**
     * この Document が管理するすべてのドキュメントをリフレッシュする。
     * @since   2003/03/12
     * @author  Kawae
     * @version 2003/03/12
    **/
    refreshDocument() {
        this.mProjects.forEach(prj => prj.documentRefresh());
    }
    addDocumentListener(l) {
        if (l == null)
            return;
        if (this.mListeners.indexOf(l) >= 0)
            return;
        this.mListeners.push(l);
    }
    removeDocumentListener(l) {
        var i = this.mListeners.indexOf(l);
        if (i >= 0)
            this.mListeners.splice(i, 1);
    }
    fireDocumentChanged(source) {
        var e = new DocumentEvent(source, this);
        var size = this.mListeners.length;
        for (var i = size - 1; i >= 0; i--) {
            this.mListeners[i].documentChanged(e);
        }
    }
    projectChanged(e) {
        this.fireDocumentChanged(e.source);
    }
}
//# sourceMappingURL=Document.js.map