import { ObjectFolder } from 'kiteclib';
import { ProjectEvent } from './ProjectEvent';
//module nethome.doc
/**
 * プロジェクトの基本単位
 * @author kawae
**/
export class DefaultProject {
    /**
     * コンストラクタ**/
    constructor(history) {
        this.mLayers = [];
        this.mProjectInfo = new Map();
        this.mHistoryManager = history;
        this.mHistoryManager.setProject(this);
        this.mListeners = [];
        this.setSaved(true);
    }
    /**
     * データの保存
     * @return
    **/
    save() {
        var of = new ObjectFolder("DATA");
        this.saveProjectInformation(of);
        this.getLayers().forEach(l => {
            var lf = new ObjectFolder("");
            lf.addNode("NAME", l.getName());
            l.save(lf);
            of.addChild(lf, true);
        });
        return of;
    }
    load(rootf, docFactory) {
        var tmp = rootf.getNode("DATA");
        if (tmp != null && tmp instanceof ObjectFolder) {
            var of = (tmp);
            this.loadProjectInformation(of);
            var v = of.getNamedElement("LAYER");
            v.forEach(on => {
                var lm = this.loadLayer(on, docFactory);
                this.addLayer(lm);
            });
        }
    }
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/10/07
    **/
    //loadLayer(layerf: ObjectFolder, docFactory: DocumentFactory): Layer {
    //    return this.loadLayer(layerf, docFactory, true);
    //}
    /**
     * レイヤーノードの読み込み
     * @param layerf
     * @param docFactory
     * @author kawae
     * @since 2005/11/02
    **/
    loadLayer(layerf, docFactory, recover = true) {
        var layerName = (layerf.getNode("NAME").getObject());
        var l = this.createLoadLayer(docFactory, layerName);
        layerf.getChildren().forEach(o => {
            if (o instanceof ObjectFolder) {
                var geom = o;
                var ng = docFactory.getGeomParser().getGeometry(geom);
                this.addGeomToLayer(l, ng);
            }
        });
        if (recover)
            this.recoverAfterLoad(l);
        return l;
    }
    /**
     * ロード時のLayer
     * @param app
     * @param layerName
     * @return
     * @author kawae
     * @since 2004/12/13
    **/
    createLoadLayer(app, layerName) {
        var lm = app.createLayer(this, layerName);
        return lm;
    }
    /**
     * プロジェクト情報の書き込み
     * @param savenode
     * @author kawae
     * @since 2004/11/06
    **/
    saveProjectInformation(savenode) {
    }
    /**
     * プロジェクト情報の読み込み
     * @param savenode
     * @author kawae
     * @since 2004/11/28
    **/
    loadProjectInformation(node) {
    }
    /**
     * 読み込んだ幾何をレイヤーに追加
     * @param l
     * @param g
     * @author kawae
     * @since 2004/11/06
    **/
    addGeomToLayer(l, g) {
        if (g != null)
            l.addPrimitive(g);
    }
    /**
     * レイヤー単位で読み込み完了後に必要な処理の実行
     * @param l
     * @author kawae
     * @since 2004/11/06
    **/
    recoverAfterLoad(l) {
        for (var j = 0; j < l.getPrims().length; j++) {
            var o = l.getPrims()[j];
            //if (o instanceof ILinkLine) {
            if (typeof o.recoverLink === "function") {
                o.recoverLink(l.getPrims());
            }
        }
    }
    /**
     * プロジェクト情報の取得
     * @return
    **/
    getProjectInfoMap() {
        return this.mProjectInfo;
    }
    /**
     * プロジェクト情報の特定のオブジェクトの取得
     * @param key
     * @return
    **/
    getProjectInfo(key) {
        if (this.mProjectInfo == null)
            return null;
        return this.mProjectInfo.get(key);
    }
    /**
     * レイヤーの追加
     * @param lm
    **/
    addLayer(l) {
        this.mLayers.push(l);
    }
    setCurrentLayer(t) {
        if (typeof t === "number") {
            var i = t;
            if (i >= 0 && i < this.mLayers.length)
                this.mActiveLayer = this.mLayers[i];
        }
        if (typeof t === "string") {
            var s = t;
            for (var i = 0; i < this.mLayers.length; i++) {
                var l = this.mLayers[i];
                var ss = l.getName();
                if (ss != null && ss === s) {
                    this.mActiveLayer = l;
                    return;
                }
            }
        }
    }
    getLayers() {
        return this.mLayers;
    }
    setSaved(changed) {
        this.mSaved = changed;
    }
    isSaved() {
        return this.mSaved;
    }
    /**
     * 現在のアクティブレイヤーの取得
     * @return アクティブなレイヤー
    **/
    getCurrentLayer() {
        return this.mActiveLayer;
    }
    /**
     * ドキュメントのクリア**/
    documentRefresh() {
        this.mActiveLayer = null;
        for (var i = 0; i < this.mLayers.length; i++) {
            var l = this.mLayers[i];
            l.deleteAll();
            l.clearSelectBuffer();
        }
        this.mLayers.length = 0;
        this.mHistoryManager.flushHistory();
    }
    /**
     * ヒストリのクリア
     * @param o
    **/
    flushHistory() {
        this.mHistoryManager.flushHistory();
    }
    /**
     * ヒストリに設定
     * @param o
    **/
    setHistoryObject(o) {
        this.mHistoryManager.setHistoryObject(o);
    }
    /**
     * カレントフロアの最後のヒストリの取得
     * @return
    **/
    getLastHistory() {
        return this.mHistoryManager.getLastHistory();
    }
    /**
     * カレントフロアの現在のヒストリの取得
     * @return
    **/
    getCurrentHistory() {
        return this.mHistoryManager.getCurrentHistory();
    }
    /**
     * アンドゥ**/
    undo() {
        return this.mHistoryManager.undo();
    }
    /**
     * リドゥ**/
    redo() {
        return this.mHistoryManager.redo();
    }
    /**
     * ヒストリに追加
     * @author kawae
     * @since 2004/09/22
    **/
    addHistory() {
        this.mHistoryManager.addHistory();
    }
    /**
     * UNDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasUndo() {
        return this.mHistoryManager.hasUndo();
    }
    /**
     * REDOヒストリを持つか確認
     * @return
     * @author kawae
     * @since 2004/11/23
    **/
    hasRedo() {
        return this.mHistoryManager.hasRedo();
    }
    /**
     * 指定された数の履歴を保存する新たな履歴を構築する。
     * @param num
    **/
    setMaxHistory(num) {
        this.mHistoryManager.setMaxHistory(num);
    }
    addProjectListener(l) {
        if (l == null)
            return;
        if (this.mListeners.indexOf(l) >= 0)
            return;
        this.mListeners.push(l);
    }
    removeProjectListener(l) {
        var i = this.mListeners.indexOf(l);
        if (i >= 0)
            this.mListeners.splice(i, 1);
    }
    fireProjectChanged(source) {
        var e = new ProjectEvent(source, this);
        var size = this.mListeners.length;
        for (var i = size - 1; i >= 0; i--) {
            this.mListeners[i].projectChanged(e);
        }
    }
}
//# sourceMappingURL=DefaultProject.js.map