import { KFont } from 'kiteclib';
/**
 * リソースを表すクラス
 * @author $Author: tanaka $
 * @version $Revision: 446 $ $Date:: 2010-03-19 20:38:08 +0900#$
**/
export declare module NethomeCoreResource {
    var TEXT_CONFIRM: string;
    /**
     * ライブラリフォルダ **/
    var LIB_DIR: string;
    /**
     * 拡張子群 **/
    var LIB_TYPES: string[];
    /**
     * 縦書き文字列 **/
    var TATE_STRING: string;
    /**
     * マウスオペレーションの閾値（ドットサイズ）**/
    var EPS_DOT_LEN: number;
    /**
     * スケーリング用フォントサイズ **/
    var SCALEFONTSIZE: number;
    /**
     * 基本フォント **/
    var DEF_FONT_NAME: string;
    var mDefFont: KFont;
    /**
     * 部屋名表記用のスケールフォント **/
    var SCALEFONT_DEF_NAME: string;
    var mScaleFont: KFont;
    var SCALEFONT_DEF_FONTNAME: string;
    var SCALEFONT_DEF_FONTTYPE: number;
    /**
     * 部屋名表記用のフォント **/
    var SCALEFONT_ROOM_NAME: string;
    var mRoomNameScaleFont: KFont;
    var SCALEFONT_ROOM_FONTNAME: string;
    var SCALEFONT_ROOM_FONTTYPE: number;
    /**
     * グリッド分割数 **/
    var GRID_DIVS: number[];
    /**
     * テキストの縦書きの場合の方向 左から右が true **/
    var TATEGAKI_DIR: boolean;
    /**
     * マーカのサイズ（ドット） **/
    var MARKER_SIZE: number;
    /**
     * 会社名(バージョンに記述される) **/
    var CORP: string;
    /**
     * テキストプロパティファイル名 **/
    var mTextPropertyFile: string;
    /**
     * ページ最大数 **/
    var MAX_PAGE_NUMBER: number;
    /**
     * アプレットモード(true:アプレット false:アプリケーション) **/
    var mAppletMode: boolean;
    /**
     * NethomeRuntimeの実装クラス名 **/
    var RUNTIME_NAME: string;
    /**
     * スケールフォントの取得
     * @param s
     * @return Font
    **/
    function getScaleFont(s: string): KFont;
    /**
     * propertyファイルからリソースファイルを取得
     * @param s
     * @return
    **/
    function getTextResource(s: string): string;
}
