import * as kwt from '../kwt';
import { KLocalAxis } from '../geom/KLocalAxis';
export declare class WRichGraphics extends kwt.AbstractRichGraphics {
    ctx: CanvasRenderingContext2D;
    private quality;
    private fillRule;
    constructor();
    setColor(color: kwt.KFill): void;
    private setStroke(lt);
    setQuality(quality: boolean): void;
    getQuality(): boolean;
    setClipArea(x1: number, y1: number, x2: number, y2: number): void;
    releaseClipArea(): void;
    drawCircle(xc1: number, yc1: number, ra: number, ss: number, ee: number, lt: kwt.KLineType): void;
    drawEllipse(xc1: number, yc1: number, v: number, h: number, ss: number, ee: number, lt: kwt.KLineType): void;
    drawFillCircle(xc1: number, yc1: number, ra: number, ss: number, ee: number, lt: kwt.KLineType): void;
    drawFillEllipse(x1: number, y1: number, x2: number, y2: number, p4: number, p5: number, lt: kwt.KLineType): void;
    drawFillRect(x1: number, y1: number, x2: number, y2: number, lt: kwt.KLineType): void;
    drawFillRoundRect(x1: number, y1: number, x2: number, y2: number, p4: number, lt: kwt.KLineType): void;
    drawImageId(img: kwt.KImage, id: string, x1: number, y1: number, x2: number, y2: number): void;
    drawImagePrefixId(img: kwt.KImage, prefix: string, id: string, x1: number, y1: number, x2: number, y2: number): void;
    drawImagePosition(img: kwt.KImage, x1: number, y1: number, x2: number, y2: number): void;
    drawImageRect(img: kwt.KImage, cx: number, cy: number, width: number, height: number, angle: number): void;
    drawLine(x1: number, y1: number, x2: number, y2: number, lt: kwt.KLineType): void;
    drawMark(x: number, y: number, r: number, type: number): void;
    drawRect(x1: number, y1: number, x2: number, y2: number, lt: kwt.KLineType): void;
    drawRoundRect(x1: number, y1: number, x2: number, y2: number, p4: number, lt: kwt.KLineType): void;
    drawText(text: string, x: number, y: number, fontname: string, fonttype: number, size: number, angle: number): void;
    fillPath(lt: kwt.KLineType): void;
    drawPath(lt: kwt.KLineType): void;
    pathClear(): void;
    pathClose(): void;
    pathInit(w: number): void;
    pathLineTo(x: number, y: number, la: KLocalAxis): void;
    pathMoveTo(x: number, y: number, la: KLocalAxis): void;
    pathQuadTo(x1: number, y1: number, x2: number, y2: number, la: KLocalAxis): void;
    pathCurveTo(x1: number, y1: number, x2: number, y2: number, x3: number, y3: number, la: KLocalAxis): void;
}
export declare function applyFont(ctx: CanvasRenderingContext2D, fontname: string, fonttype: number, size: number): void;
