//import { error } from '../../common'
var emutils = require('emutils');
var ObjectNode_1 = require('../tree/ObjectNode');
var ObjectFolder_1 = require('../tree/ObjectFolder');
var Base64Encoder_1 = require('../../io/Base64Encoder');
var XMLManager_1 = require('./XMLManager');
//module jp.kitec.lib.util.xml
/**
 * @author kawae
 * XMLWriterを例外をcatchしないように修正したもの
 **/
var XMLWriter = (function () {
    function XMLWriter() {
    }
    /**
     * ライト
     * @param f
     * @param space
     * @param w
     * @throws Exception
    **/
    XMLWriter.write = function (f, space) {
        var s = [""];
        XMLWriter.write_(f, space, s);
        return s[0];
    };
    //static write(f: ObjectNode, space: string, o: Writer): void /*IOException*/ {
    //    XMLWriter.write_(f, space, o);
    //}
    /**
     * @param f
     * @param space
     * @param o
     * @throws Exception
     * @author kawae
     * @since 2005/12/09
    **/
    XMLWriter.write_ = function (f, space, o) {
        if (f instanceof ObjectFolder_1.ObjectFolder) {
            var of = f;
            var hasFolder = false;
            var hasNode = false;
            for (var i = 0; i < of.getChildren().length; i++) {
                if (of.getChildren()[i] instanceof ObjectFolder_1.ObjectFolder) {
                    hasFolder = true;
                }
                else if (of.getChildren()[i] instanceof ObjectNode_1.ObjectNode) {
                    hasNode = true;
                }
            }
            if (hasNode)
                XMLWriter.print(o, space + "<" + of.getName());
            else {
                if (of.getChildren() == null || of.getChildren().length == 0) {
                    XMLWriter.println(o, space + "<" + of.getName() + "/>");
                    return;
                }
                XMLWriter.println(o, space + "<" + of.getName() + ">");
            }
            for (var i = 0; i < of.getChildren().length; i++) {
                if (!(of.getChildren()[i] instanceof ObjectFolder_1.ObjectFolder))
                    XMLWriter.write_(of.getChildren()[i], space + " ", o);
            }
            if (hasNode && !hasFolder)
                XMLWriter.println(o, "/>");
            else if (hasNode)
                XMLWriter.println(o, ">");
            for (var i = 0; i < of.getChildren().length; i++) {
                if (of.getChildren()[i] instanceof ObjectFolder_1.ObjectFolder)
                    XMLWriter.write_(of.getChildren()[i], space + " ", o);
            }
            if (hasFolder)
                XMLWriter.println(o, space + "</" + of.getName() + ">");
        }
        else {
            var on = f;
            if (on.getObject() != null) {
                var str = on.getString();
                var enc64 = false;
                for (var _i = 0, _a = XMLManager_1.XMLManager.ENC_64_CHARS; _i < _a.length; _i++) {
                    var element = _a[_i];
                    if (str.indexOf(element) >= 0) {
                        enc64 = true;
                        break;
                    }
                }
                if (enc64) {
                    var bytes = new Array(emutils.lengthBytesUTF8(str));
                    var len = emutils.stringToUTF8Array(str, bytes, 0, bytes.length);
                    bytes.length = len;
                    str = XMLManager_1.XMLManager.BASE64_TAG_BRGIN + Base64Encoder_1.Base64Encoder.encode(bytes) + XMLManager_1.XMLManager.BASE64_TAG_END;
                }
                XMLWriter.print(o, " " + on.getName() + "=\"" + str + "\"");
            }
            else {
                XMLWriter.print(o, " " + on.getName() + "=\"" + on.getObject() + "\"");
            }
        }
    };
    /**
     * @param target
     * @param message
     * @author kawae
     * @since 2005/12/09
    **/
    XMLWriter.print = function (target, message) {
        target[0] += message;
    };
    /**
     * @param target
     * @param message
     * @author kawae
     * @since 2005/12/09
    **/
    XMLWriter.println = function (target, message) {
        target[0] += message + "\n";
    };
    return XMLWriter;
})();
exports.XMLWriter = XMLWriter;
//# sourceMappingURL=XMLWriter.js.map