var XMLReader_1 = require('./XMLReader');
//module jp.kitec.lib.util
function equal(expect, actual, eps) {
    QUnit.ok(Math.abs(expect - actual) <= eps);
}
/**
 * コメントを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXML01()", function () {
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <!-- \u30B3\u30E1\u30F3\u30C8\u306E\u307F\u306E\u884C  -->\n  <bbb value=\"a\" />\n  <!-- \u884C\u982D\u306E\u30B3\u30E1\u30F3\u30C8  --><bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" /><!-- \u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C8 -->\n  <bbb value=\"e\" />\n  <!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C81  --><bbb value=\"f\" /><!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C82  -->\n  <bbb value=\"g\" />\n</aaa>";
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    for (var i = 0; i < 14; i++)
        console.log(i + ":" + testXMLreader.readLine());
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"e\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"f\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"g\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 連続したコメントを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXML02()", function () {
    //String testFilePath = XML_PATH_02;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <!-- \u30B3\u30E1\u30F3\u30C8\u306E\u307F\u306E\u884C1  -->  <!-- \u30B3\u30E1\u30F3\u30C8\u306E\u307F\u306E\u884C2  -->  <!-- \u30B3\u30E1\u30F3\u30C8\u306E\u307F\u306E\u884C3  -->\n  <bbb value=\"a\" />\n  <!-- \u884C\u982D\u306E\u30B3\u30E1\u30F3\u30C81  --><!-- \u884C\u982D\u306E\u30B3\u30E1\u30F3\u30C82  --><!-- \u884C\u982D\u306E\u30B3\u30E1\u30F3\u30C83  --><bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" /><!-- \u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C81 --><!-- \u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C82 --><!-- \u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C83 -->\n  <bbb value=\"e\" />\n  <!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C81  --><!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C82  --><!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C83  --><bbb value=\"f\" /><!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C84  --><!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C85  --><!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C86  -->\n  <bbb value=\"g\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"e\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"f\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"g\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 改行を含むコメントを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXML03()", function () {
    //String testFilePath = XML_PATH_03;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <!-- \u30B3\u30E1\u30F3\u30C8\u306E\u307F\u306E\u884C1\n   \u30B3\u30E1\u30F3\u30C8\u306E\u307F\u306E\u884C2\n   \u30B3\u30E1\u30F3\u30C8\u306E\u307F\u306E\u884C3 -->\n  <bbb value=\"a\" />\n  <!-- \u884C\u982D\u306E\u30B3\u30E1\u30F3\u30C81\n    \u884C\u982D\u306E\u30B3\u30E1\u30F3\u30C82\n    \u884C\u982D\u306E\u30B3\u30E1\u30F3\u30C83 --><bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" /><!-- \u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C81\n  \u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C82\n  \u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C83 -->\n  <bbb value=\"e\" />\n  <!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C81\n  \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C82\n  \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C83 --><bbb value=\"f\" /><!-- \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C84\n  \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C85\n  \u884C\u982D\u3068\u884C\u672B\u306E\u30B3\u30E1\u30F3\u30C86 -->\n  <bbb value=\"g\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"e\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"f\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"g\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 1行に開始タグと終了タグがあるXMLの読み込み<br/>
 */
QUnit.test("testReadXML04()", function () {
    //String testFilePath = XML_PATH_04;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb> value=\"c\" </bbb>\n  <bbb value=\"d\" />\n  <bbb value=\"e\" />\n  <bbb value=\"f\" />\n  <bbb value=\"g\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb> value=\"c\" </bbb>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"e\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"f\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"g\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 1行に終了タグが複数存在するXMLの読み込みテスト<br/>
 * 読み込みに失敗する<br/>
 * 現状としては、この動作を許容している<br/>
 */
QUnit.test("testReadXML05()", function () {
    //String testFilePath = XML_PATH_05;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb> value=\"c\" </bbb><bbb> value=\"d\" </bbb>\n  <bbb value=\"e\" />\n  <bbb value=\"f\" />\n  <bbb value=\"g\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb> value=\"c\" </bbb><bbb> value=\"d\" </bbb>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"e\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"f\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"g\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 1行に空要素タグが複数存在するXMLの読み込みテスト<br/>
 * 読み込みに失敗する<br/>
 * 現状としては、この動作を許容している<br/>
 */
QUnit.test("testReadXML06()", function () {
    //String testFilePath = XML_PATH_06;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" /><bbb value=\"d\" />\n  <bbb value=\"e\" />\n  <bbb value=\"f\" />\n  <bbb value=\"g\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\" /><bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"e\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"f\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"g\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 左側括弧が欠落したコメントの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid01()", function () {
    //String testFilePath = XML_PATH_INVALID_01;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  !-- \u5DE6\u5074\u62EC\u5F27\u304C\u6B20\u843D\u3057\u305F\u30B3\u30E1\u30F3\u30C8-->\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa>", testXMLreader.readXML());
    QUnit.notEqual(null, testXMLreader.readXML());
});
/**
 * 左側ハイフンが欠落したコメントの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid02()", function () {
    //String testFilePath = XML_PATH_INVALID_02;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <!- \u5DE6\u5074\u30CF\u30A4\u30D5\u30F3\u304C\u6B20\u843D\u3057\u305F\u30B3\u30E1\u30F3\u30C8 -->\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa>", testXMLreader.readXML());
    QUnit.notEqual(null, testXMLreader.readXML());
});
/**
 * 右側括弧が欠落したコメントの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid03()", function () {
    //String testFilePath = XML_PATH_INVALID_03;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <!-- \u53F3\u5074\u62EC\u5F27\u304C\u6B20\u843D\u3057\u305F\u30B3\u30E1\u30F3\u30C8 --\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 右側ハイフンが欠落したコメントの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid04()", function () {
    //String testFilePath = XML_PATH_INVALID_04;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <!-- \u53F3\u5074\u30CF\u30A4\u30D5\u30F3\u304C\u6B20\u843D\u3057\u305F\u30B3\u30E1\u30F3\u30C8 ->\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 右側にスラッシュを誤記したコメントの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid05()", function () {
    //String testFilePath = XML_PATH_INVALID_05;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <!-- \u53F3\u5074\u306B\u30B9\u30E9\u30C3\u30B7\u30E5\u3092\u8AA4\u8A18\u3057\u305F\u30B3\u30E1\u30F3\u30C8 --/>\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 開始タグの欠落したXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid06()", function () {
    //String testFilePath = XML_PATH_INVALID_06;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 開始タグの左側括弧が欠落したXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid07()", function () {
    //String testFilePath = XML_PATH_INVALID_07;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\naaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 開始タグの右側括弧が欠落したXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid08()", function () {
    //String testFilePath = XML_PATH_INVALID_08;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.notEqual("<aaa", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 終了タグが欠落したXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid09()", function () {
    //String testFilePath = XML_PATH_INVALID_09;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 左側括弧が欠落した終了タグを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid10()", function () {
    //String testFilePath = XML_PATH_INVALID_10;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n/aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("/aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 右側括弧が欠落した終了タグを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid11()", function () {
    //String testFilePath = XML_PATH_INVALID_11;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 開始タグと終了タグが一致しないXMLの読み込みテスト<br/>
 * 開始タグ名のObjectFolderが生成される<br/>
 */
QUnit.test("testReadXMLInvalid12()", function () {
    //String testFilePath = XML_PATH_INVALID_12;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</ccc>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("</ccc>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 左側括弧が欠落した空要素タグを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid13()", function () {
    //String testFilePath = XML_PATH_INVALID_13;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  bbb value=\"b\" />\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("bbb value=\"b\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * 右側括弧が欠落した空要素タグを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid14()", function () {
    //String testFilePath = XML_PATH_INVALID_14;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" /\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"b\"  /", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.notEqual("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.notEqual("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
/**
 * スラッシュが欠落した空要素タグを含むXMLの読み込みテスト<br/>
 */
QUnit.test("testReadXMLInvalid15()", function () {
    //String testFilePath = XML_PATH_INVALID_15;
    var content = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<aaa>\n  <bbb value=\"a\" />\n  <bbb value=\"b\" >\n  <bbb value=\"c\" />\n  <bbb value=\"d\" />\n</aaa>";
    //log.debug("testFilePath[" + testFilePath + "]");
    var testXMLreader = new XMLReader_1.XMLReader(content);
    testXMLreader.open();
    QUnit.equal("<aaa>", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"a\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"b\">", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"c\"  />", testXMLreader.readXML());
    QUnit.equal("<bbb value=\"d\"  />", testXMLreader.readXML());
    QUnit.equal("</aaa>", testXMLreader.readXML());
    QUnit.equal(null, testXMLreader.readXML());
});
//QUnit.test("testRead()", function () {
//    const content =
//        `<?xml version="1.0" encoding="UTF-8" ?>
//<aaa>
//  <!-- コメントのみの行  -->
//  <bbb value="a" />
//  <!-- 行頭のコメント  --><bbb value="b" />
//  <bbb value="c" />
//  <bbb value="d" /><!-- 行末のコメント -->
//  <bbb value="e" />
//  <!-- 行頭と行末のコメント1  --><bbb value="f" /><!-- 行頭と行末のコメント2  -->
//  <bbb value="g" />
//</aaa>`;
//    var testXMLreader = new XMLReader(content);
//    var of = testXMLreader.read();
//    console.log(JSON.stringify(of));
//    QUnit.ok(of);
//}); 
//# sourceMappingURL=XMLReaderTest.js.map