var ObjectNode_1 = require('../tree/ObjectNode');
var ObjectFolder_1 = require('../tree/ObjectFolder');
//import { UnsupportedEncodingException } from '../../../../java/io/UnsupportedEncodingException'
//import { BufferedReader } from '../../../../java/io/BufferedReader'
//import { StringTokenizer } from '../../../../java/util/StringTokenizer'
//import { IOException } from '../../../../java/io/IOException'
//module jp.kitec.lib.util.xml
/**
 * XML 形式データの読み込みを行う。
 * @since		2004/05/06
 * @author		fujita
 * @version	2004/05/06
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
var XMLReader = (function () {
    /**
     * 指定されたストリームを、データの読み込み元とする
     * 新たな XMLReader を作成する。
     * @param input	入力ストリーム
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    function XMLReader(input) {
        /**
         * 読み込み途中の残データ
         **/
        this.mRemain = "";
        this.mCanRead = this.setFile(input, "");
    }
    /**
     * 指定されたオブジェクトを、データの読み込み元とする
     * 新たな XMLReader を作成する。
     * @param input	入力ストリーム読み込み用オブジェクト
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    //public constructor(input: AbstFile) {
    //    if (input != null) {
    //        this.mInput = input;
    //        this.mCanRead = true;
    //    }
    //}
    /**
     * 指定されたストリーム、およびファイル名をもとに
     * データ読み込みオブジェクトを設定する。<BR>
     * @param input	入力ストリーム
     * @param file	ファイル名
     * @return		データ読み込みオブジェクトが正常に
     * 設定された場合、true。
     * そうでない場合は、false
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.setFile = function (input, file) {
        if (input == null)
            return false;
        this.mInput = input;
        //this.mInput.read(input, file);
        return true;
    };
    /**
     * @param code
     * @return
     * @author kawae
     * @since 2005/12/09
    **/
    //public read(code: string): ObjectFolder {
    //    if (code == null) return this.read();
    //    if (!this.open(code)) {
    //        return null;
    //    }
    //    let of = null;
    //    try {
    //        of = this.parseXML(code);
    //    }
    //    catch (e: UnsupportedEncodingException) {
    //    }
    //    this.close();
    //    if (of == null || of.getChildren().size() < 1) {
    //        return null;
    //    }
    //    return of;
    //}
    /**
     * XML 形式データ読み込み、そのデータを表現するツリー構造を
     * 持つオブジェクトを作成し、返す。
     * @return		データの読み込み、およびその内容が正常な場合、
     * ツリー構造を持つデータオブジェクト。
     * そうでない場合は、null
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.read = function () {
        if (!this.open()) {
            return null;
        }
        var of = null;
        try {
            of = this.parseXML(null);
        }
        catch (e) {
            console.log(e);
        }
        this.close();
        if (of == null || of.getChildren().length === 0) {
            return null;
        }
        return of;
    };
    /**
     * @param code
     * @return
     * @author kawae
     * @since 2005/12/09
    **/
    //open(code: string): boolean {
    //    if (code == null) return this.open();
    //    if (this.mCanRead) {
    //        try {
    //            this.mBr = this.mInput.openBufferedReader(code);
    //        }
    //        catch (e: UnsupportedEncodingException) {
    //            return false;
    //        }
    //        this.mEOF = false;
    //        return true;
    //    }
    //    else {
    //        return false;
    //    }
    //}
    /**
     * データ読み込みの前処理として、読み込み先ストリームをオープンする。
     * @return		正しくオープンできた場合、true。
     * そうでない場合は、false
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.open = function () {
        if (this.mCanRead) {
            this.mRemain = "";
            this.mBr = 0; //this.mInput.openBufferedReader();
            this.mEOF = false;
            return true;
        }
        else {
            return false;
        }
    };
    /**
     * データ読み込みの後処理として、読み込み先ストリームをクローズする。
     * @return		正しくクローズできた場合、true。
     * そうでない場合は、false
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.close = function () {
        //try {
        //    this.mBr.close();
        //}
        //catch (e: IOException) {
        //    return false;
        //}
        return true;
    };
    /**
     * XML データを読み込み解析する。そして、そのデータを
     * 表現するツリー構造を持つオブジェクトを作成し、返す。
     * @return		データの読み込み、およびその内容が正常な場合、
     * ツリー構造を持つデータオブジェクト。
     * そうでない場合は、null
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
     * @throws UnsupportedEncodingException
    **/
    XMLReader.prototype.parseXML = function (code) {
        var of = new ObjectFolder_1.ObjectFolder("");
        var topf = of;
        var line;
        var pos;
        while (true) {
            line = this.readXML();
            if (line == null) {
                break;
            }
            for (var i = 0; i < line.length - 1; i++) {
                pos = this.indexOfDelimiter(line, i);
                of = this.parseElement(line.substring(i, pos).trim(), of, code);
                i = pos - 1;
            }
        }
        return topf;
    };
    /**
     * 指定されたデータにおいて、指定されたインデックスから
     * 検索を開始し、引用符内を除き、区切り文字が最初に出現
     * したインデックスを返す。
     * @param line	検索を行うデータ
     * @param st		検索を開始するインデックス
     * @return		区切り文字が、指定されたインデックスと同じか
     * これより大きいインデックス位置にある場合は、
     * 最初に出現した位置のインデックス。
     * 区切り文字がない場合は、line の文字列の長さ
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.indexOfDelimiter = function (line, st) {
        var equal = false;
        var quote = 0;
        var i;
        var c;
        for (i = st + 1; i < line.length; i++) {
            c = line.charAt(i);
            if (quote == 0 && c == '=') {
                equal = true;
            }
            else if (equal && c == '\"') {
                quote++;
            }
            else if (c == ' ') {
                if (quote != 1) {
                    break;
                }
            }
        }
        return i;
    };
    /**
     * 指定された要素を解析し、指定されたツリーオブジェクトへ
     * その要素が定義するデータを追加する。
     * @param elem	解析する要素
     * @param of		ツリーオブジェクト
     * @return		データ追加後の新しいツリーオブジェクト
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
     * @throws UnsupportedEncodingException
    **/
    XMLReader.prototype.parseElement = function (elem, of, code) {
        var tag = null;
        var val = null;
        var q1;
        var q2;
        if (elem != null && elem.length > 0) {
            var deli = elem.indexOf('=');
            if (deli >= 0) {
                tag = elem.substring(0, deli);
                val = elem.substring(deli + 1, elem.length);
                q1 = val.indexOf('\"');
                q2 = val.lastIndexOf('\"');
                if (q1 >= 0 && q2 >= 0 && q2 > q1) {
                    val = val.substring(q1 + 1, q2);
                }
                if (val != null)
                    val = this.getValue(val, code);
            }
            else {
                tag = elem;
            }
        }
        if (tag != null && tag.length > 0) {
            var st = tag.split(/[<> ]/).filter(function (s) { return s.length > 0; });
            tag = st[0];
            if (val == null) {
                if (tag.charAt(0) == '/' || tag == "/") {
                    of = of.getParent();
                }
                else {
                    var w = new ObjectFolder_1.ObjectFolder(tag);
                    of.addChild(w, true);
                    of = w;
                }
            }
            else {
                try {
                    of.addChild(new ObjectNode_1.ObjectNode(tag, val), true);
                }
                catch (e) {
                    console.log(e);
                }
            }
        }
        return of;
    };
    /**
     * Base64タグが存在するか確認し、存在すればタグを外した文字列を得る
     * @param val
     * @return
     * @author kawae
     * @since 2005/08/11
    **/
    XMLReader.prototype.getValue = function (val, code) {
        //TODO
        //var indexStart: number = val.indexOf(XMLManager.BASE64_TAG_BRGIN);
        //var indexEnd: number = val.indexOf(XMLManager.BASE64_TAG_END);
        //if (indexStart == 0 && indexEnd > 0) {
        //    let str = val.substring(XMLManager.BASE64_TAG_BRGIN.length, indexEnd);
        //    val = new string(Base64Decoder.decode(str), code);
        //}
        return val;
    };
    /**
     * 1 件分のXML データ（"<" から ">" まで）を読み込む。<BR>
     * #parseXML() で解析しやすいようデータの整形を主に行う。
     * @return		読み込まれた XML データ。
     * ストリームの終わりに達した場合は、null
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.readXML = function () {
        if (this.mEOF) {
            return null;
        }
        var sb = this.mRemain;
        this.mRemain = "";
        var line = this.readLineWithoutComment();
        if (line == null) {
            return null;
        }
        var pos;
        var len;
        while (line != null) {
            pos = line.lastIndexOf("/>");
            len = line.length;
            if (pos < 0) {
                pos = line.lastIndexOf(">");
                if (pos < 0) {
                    sb += line + "\n";
                    line = this.readLineWithoutComment();
                    continue;
                }
                else {
                    sb += line.substring(0, pos).trim();
                    sb += ">";
                    if (pos + 1 != len) {
                        this.mRemain = line.substring(pos + 1, len);
                    }
                    break;
                }
            }
            else {
                if (pos + 2 != len) {
                    this.mRemain = line.substring(pos + 2, len);
                }
                sb += line.substring(0, pos);
                sb += " />";
                break;
            }
        }
        if (line == null) {
            this.mEOF = true;
        }
        if (sb.length > 0) {
            return sb;
        }
        else {
            return null;
        }
    };
    /**
     * XML 形式データでのコメントを除く、1 行分のデータを読み込み。<BR>
     * 次のデータはコメントとして取り扱う。<BR>
     * (1)<!-- xxx --><BR>
     * (2)<? xxxxxx ?><BR>
     * @return		読み込まれたデータ。
     * ストリームの終わりに達した場合は、null
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.readLineWithoutComment = function () {
        var _this = this;
        var line = this.readLine();
        var trimed;
        while (line != null) {
            if (line.length == 0) {
                line = "";
            }
            trimed = false;
            XMLReader.COMMENT.forEach(function (element) {
                if (line.indexOf(element[0]) >= 0) {
                    line = _this.trimComment(line, element[0], element[1]);
                    trimed = true;
                }
            });
            if (!trimed) {
                break;
            }
        }
        return line;
    };
    /**
     * 指定された行データを解析し、コメントを除くデータを返す。
     * @param line	解析を開始する行（データ）
     * @param start	コメントの開始文字
     * @param end		コメントの終了文字
     * @return		コメントを除くデータ。
     * ストリームの終わりに達した場合は、null
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.trimComment = function (line, start, end) {
        if (line == null) {
            return null;
        }
        var startPos = line.indexOf(start);
        if (startPos < 0) {
            return line;
        }
        var sb = line.substring(0, startPos).trim();
        var endPos;
        var sz = end.length;
        while (true) {
            endPos = line.indexOf(end);
            if (endPos >= 0) {
                break;
            }
            line = this.readLine();
            if (line == null) {
                return null;
            }
        }
        var len = line.length;
        if (endPos + sz != len) {
            line = line.substring(endPos + sz, len).trim();
            sb += line;
        }
        else if (startPos === 0) {
            line = this.readLine();
            sb += line;
        }
        return sb;
    };
    /**
     * 1 行分のデータを読み込む。
     * @return		前後の空白を除いた読み込んだデータ。
     * ストリームの終わりに達した場合は、null
     * @since		2004/05/06
     * @author		fujita
     * @version	2004/05/06
    **/
    XMLReader.prototype.readLine = function () {
        if (this.mBr >= this.mInput.length)
            return null;
        var start = this.mBr;
        var end = this.mBr;
        var c;
        while (end < this.mInput.length) {
            c = this.mInput.charAt(end);
            if (c === "\n" || c === "\r")
                break;
            end++;
        }
        this.mBr = end;
        if (this.mInput.charAt(this.mBr) === "\r")
            this.mBr++;
        if (this.mInput.charAt(this.mBr) === "\n")
            this.mBr++;
        var line = this.mInput.substring(start, end);
        if (line != null) {
            return line.trim();
        }
        else {
            return null;
        }
    };
    /**
     * コメントの開始／終了文字群
     **/
    XMLReader.COMMENT = [["<?", "?>"], ["<!--", "-->"]];
    return XMLReader;
})();
exports.XMLReader = XMLReader;
//# sourceMappingURL=XMLReader.js.map