import { ObjectFolder } from '../tree/ObjectFolder';
/**
 * XML 解析クラス。<BR>
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
export declare class XMLParser {
    /**
     * 指定された in から XML データを読み込む。
     * @param in	XML データ入力オブジェクト
     * @return		XML データを正しく読み込めた場合、
     * そのデータを表す木構造オブジェクトtrue。
     * そうでない場合は、null
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    load(in_: string): ObjectFolder;
    loadIntArray(data: number[] | Uint8Array, encode?: string): ObjectFolder;
    /**
     * 指定された in から XML データを読み込む。
     * @param in	 XML データ入力オブジェクト
     * @return		 XML データを正しく読み込めた場合、そのデータを持つ
     * データオブジェクト。そうでない場合は、null
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
    **/
    private read(in_);
}
