var XMLParser_1 = require('./XMLParser');
var XMLWriter_1 = require('./XMLWriter');
//module jp.kitec.lib.util.xml
/**
 * XML 管理クラス。
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
var XMLManager;
(function (XMLManager) {
    XMLManager.ENC_64_CHARS = ["<", ">", "\""];
    XMLManager.BASE64_TAG_BRGIN = "__BEGIN_BASE64ENCODED__";
    XMLManager.BASE64_TAG_END = "__END_BASE64ENCODED__";
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML 文字列
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
     **/
    function load(data) {
        var xml = new XMLParser_1.XMLParser();
        var objFolder = xml.load(data);
        return objFolder;
    }
    XMLManager.load = load;
    function loadFromIntArray(data) {
        var xml = new XMLParser_1.XMLParser();
        var objFolder = xml.loadIntArray(data);
        return objFolder;
    }
    XMLManager.loadFromIntArray = loadFromIntArray;
    function save(of) {
        return XMLWriter_1.XMLWriter.write(of, "");
    }
    XMLManager.save = save;
})(XMLManager = exports.XMLManager || (exports.XMLManager = {}));
//# sourceMappingURL=XMLManager.js.map