import { ObjectFolder } from '../tree/ObjectFolder';
/**
 * XML 管理クラス。
 * @since		2004/05/18
 * @author		fujita
 * @version	2004/05/18
 * Copyright (c) 2004 KITec Inc,.. All rights reserved.
**/
export declare namespace XMLManager {
    const ENC_64_CHARS: string[];
    const BASE64_TAG_BRGIN: string;
    const BASE64_TAG_END: string;
    /**
     * 指定された in からXML データを読み込む。
     * @param in	XML 文字列
     * @return		XML データを正しく読み込めた場合、true。
     * そうでない場合は、false
     * @since		2004/05/19
     * @author		fujita
     * @version	2004/05/19
     **/
    function load(data: string): ObjectFolder;
    function loadFromIntArray(data: number[] | Uint8Array): ObjectFolder;
    function save(of: ObjectFolder): string;
}
