import { ObjectFolder } from './ObjectFolder';
/**
 * ツリーなどの階層構造におけるノード。<BR>
 * @since 　2002/12/20
 * @author　Kawae
 * @version 2002/12/20
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
export declare class ObjectNode {
    /**
     * ノード名 **/
    private mName;
    /**
     * ノードに対応するデータ **/
    private mObject;
    /**
     * このノードの親 **/
    private mParent;
    /**
     * 指定された名前、親、およびデータを持つ新たなノードを構築する。
     * @param name		このノードの名前
     * @param parent	このノードの親
     * @param o		このノードに対応するデータ
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    constructor(name?: string, o?: Object);
    /**
     * このノードの名前を返す。
     * @return ノードの名前
     * @see #setName(String)
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getName(): string;
    /**
     * 指定された名前を、このノードの名前として設定する。
     * @param ノードの名前
     * @see #getName()
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    setName(name: string): void;
    /**
     * このノードに対応するデータを返す。
     * @return このノードに対応するデータ
     * @see #setObject(Object)
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getObject(): Object;
    /**
     * 指定されたデータを、このノードに対応するデータとして設定する。
     * @param このノードに対応するデータ
     * @see #getObject()
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    setObject(o: Object): void;
    /**
     * このノードの親を返す。
     * @return ノードの親
     * @see #setParent(ObjectFolder)
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getParent(): ObjectFolder;
    /**
     * 指定された ObjectFolder を、このノードの親として設定する。
     * @param ノードの親とする ObjectFolder
     * @see #getParent()
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    setParent(f: ObjectFolder): void;
    /**
     * Stringの取得
     * 存在しない場合はnullを返す
     * @param defalutValue
    **/
    getString(defalutValue?: string): string;
    /**
     * int値の取得
     * 存在しない場合はdefaultValueを返す
     * @param defaultValue
    **/
    getInt(defaultValue?: number): number;
    /**
     * float値の取得
     * 存在しない場合はdefaultValueを返す
     * @param defaultValue
    **/
    getFloat(defaultValue?: number): number;
    /**
     * double値の取得
     * 存在しない場合はdefaultValueを返す**/
    getDouble(defaultValue?: number): number;
    /**
     * boolの取得
     * 存在しない場合はdefaultValueを返す
     * @param defaultValue
    **/
    getBool(defaultValue?: boolean): boolean;
    /**
     * ノードオブジェクトがStringか確認
     * @return
    **/
    isStringObject(): boolean;
    /**
     * ノードオブジェクトがintか確認
     * @return
    **/
    isIntObject(): boolean;
    /**
     * オブジェクトがBooleanか確認
     * 文字列かつ"1"or"0"か確認
     * @return
    **/
    isBoolObject(): boolean;
    /**
     * ノードオブジェクトがfloatか確認
     * @return
    **/
    isFloatObject(): boolean;
    /**
     * ノードオブジェクトがdoubleか確認
     * @return
    **/
    isDoubleObject(): boolean;
    /**
     * Stringの取得
     * 存在しない場合はnullを返す
     * @param on
    **/
    static getNodeString(on: ObjectNode): string;
    /**
     * int値の取得
     * @param on
    **/
    static getNodeInt(on: ObjectNode): number;
    /**
     * float値の取得
     * @param on
    **/
    static getNodeFloat(on: ObjectNode): number;
    /**
     * boolの取得
     * 存在しない場合は0を返す
     * @param on
    **/
    static getNodeBool(on: ObjectNode): boolean;
    /**
     * ノードオブジェクトがStringか確認
     * @param on
     * @return
     * @author kawae
     * @since 2004/11/05
    **/
    static isStringObject(on: ObjectNode): boolean;
    static isIntObject(on: ObjectNode): boolean;
    /**
     * オブジェクトがBooleanか確認
     * 文字列かつ"1"or"0"か確認
     * @param on
     * @return
     * @author kawae
     * @since 2004/11/05
     */
    static isBoolObject(on: ObjectNode): boolean;
    /**
     * ノードオブジェクトがfloatか確認
     * @param on
     * @return
     * @author kawae
     * @since 2004/11/05
     **/
    static isFloatObject(on: ObjectNode): boolean;
}
