var ObjectFolder_1 = require('./ObjectFolder');
var ObjectNode_1 = require('./ObjectNode');
//module jp.kitec.lib.util.tree
QUnit.test("testObjectFolder()", function () {
    new ObjectFolder_1.ObjectFolder("folder");
    QUnit.ok(true);
});
QUnit.test("testRemoveAllElements()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var of2 = new ObjectFolder_1.ObjectFolder("folder2");
    of2.addChild(new ObjectNode_1.ObjectNode("b", "B"));
    of.addChild(of2);
    of.addChild(new ObjectNode_1.ObjectNode("a", "A"));
    var of3 = new ObjectFolder_1.ObjectFolder("folder3");
    of3.addChild(new ObjectNode_1.ObjectNode("b", "B"));
    of.addChild(of3);
    QUnit.ok(of.getChildren().length > 0);
    QUnit.ok(of2.getChildren().length > 0);
    of.removeAllElements();
    QUnit.ok(of.getChildren().length == 0);
    QUnit.ok(of2.getChildren().length == 0);
    QUnit.ok(of3.getChildren().length == 0);
});
QUnit.test("testAddFolderFromPath()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var oc = of.addFolderFromPath("/a/b/c");
    QUnit.ok(oc);
    QUnit.equal("c", oc.getName());
    var ob = oc.getParent();
    QUnit.equal("b", ob.getName());
    var oa = ob.getParent();
    QUnit.equal("a", oa.getName());
    QUnit.equal(of, oa.getParent());
    var od = of.addFolderFromPath("/a/b/c/d");
    QUnit.equal("d", od.getName());
    QUnit.equal(oc, od.getParent());
});
QUnit.test("testGetNodeString()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var oc = of.addFolderFromPath("/a/b/c");
    of.addChild(new ObjectNode_1.ObjectNode("a", "A"), true);
    var on = of.getNode("a");
    QUnit.ok(on);
    QUnit.ok(on instanceof ObjectFolder_1.ObjectFolder);
    QUnit.equal("a", on.getName());
    var onA = of.getNode("A");
    QUnit.ok(onA);
    QUnit.equal(true, onA instanceof ObjectFolder_1.ObjectFolder);
    QUnit.equal("a", onA.getName());
    QUnit.equal(null, of.getNode("b"));
});
QUnit.test("testGetNodeStringBoolean()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var oc = of.addFolderFromPath("/a/b/c");
    of.addChild(new ObjectNode_1.ObjectNode("a", "A"), true);
    var on = of.getNode("a", false);
    QUnit.ok(on);
    QUnit.equal(false, on instanceof ObjectFolder_1.ObjectFolder);
    QUnit.equal("a", on.getName());
    var onA = of.getNode("A", false);
    QUnit.ok(onA);
    QUnit.equal(true, onA instanceof ObjectNode_1.ObjectNode);
    QUnit.equal(false, onA instanceof ObjectFolder_1.ObjectFolder);
    QUnit.equal("a", onA.getName());
    QUnit.equal(null, of.getNode("b", false));
});
QUnit.test("testSortFolder()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var of1 = new ObjectFolder_1.ObjectFolder("c");
    of.addChild(of1);
    of.addChild(new ObjectNode_1.ObjectNode("z", "1"), true);
    var of2 = new ObjectFolder_1.ObjectFolder("a");
    of.addChild(of2);
    of2.addChild(new ObjectNode_1.ObjectNode("a1", "1"), true);
    of2.addChild(new ObjectFolder_1.ObjectFolder("b1"), true);
    of.addChild(new ObjectNode_1.ObjectNode("b", "1"), true);
    of.addChild(new ObjectNode_1.ObjectNode("c", "1"), true);
    of.sortFolder();
    QUnit.equal(5, of.getChildren().length);
    //QUnit.equal(ObjectFolder, (of.getChildren()[0]).getClass());//TODO
    //QUnit.equal(ObjectFolder, (of.getChildren()[1]).getClass());
    //QUnit.equal(ObjectNode, (of.getChildren()[2]).getClass());
    //QUnit.equal(ObjectNode, (of.getChildren()[3]).getClass());
    //QUnit.equal(ObjectNode, (of.getChildren().get(4)) as ObjectNode.getClass());
    var of3 = of.getChildren()[1];
    QUnit.equal(2, of3.getChildren().length);
    //QUnit.equal(ObjectFolder, (of3.getChildren()[0]).getClass());
    //QUnit.equal(ObjectNode, (of3.getChildren()[1]).getClass());
});
QUnit.test("testGetChildren()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var of1 = new ObjectFolder_1.ObjectFolder("c");
    of.addChild(of1);
    var on1 = new ObjectNode_1.ObjectNode("z", "1");
    of.addChild(on1, true);
    var of2 = new ObjectFolder_1.ObjectFolder("a");
    of.addChild(of2);
    var children = of.getChildren();
    QUnit.equal(3, children.length);
    QUnit.equal(of1, children[0]);
    QUnit.equal(on1, children[1]);
    QUnit.equal(of2, children[2]);
});
QUnit.test("testAddChildObjectNode()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var of1 = new ObjectFolder_1.ObjectFolder("a");
    of.addChild(of1);
    of.addChild(of1);
    var on1 = new ObjectNode_1.ObjectNode("z", "1");
    of.addChild(on1);
    var of2 = new ObjectFolder_1.ObjectFolder("a");
    of.addChild(of2);
    var children = of.getChildren();
    QUnit.equal(2, children.length);
    QUnit.equal(of1, children[0]);
    QUnit.equal(on1, children[1]);
    QUnit.equal(of, of1.getParent());
    QUnit.equal(of, on1.getParent());
    QUnit.equal(null, of2.getParent());
});
QUnit.test("testAddChildObjectNodeBoolean()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var of1 = new ObjectFolder_1.ObjectFolder("a");
    of.addChild(of1, true);
    of.addChild(of1, true);
    var on1 = new ObjectNode_1.ObjectNode("z", "1");
    of.addChild(on1, true);
    var of2 = new ObjectFolder_1.ObjectFolder("a");
    of.addChild(of2, true);
    var children = of.getChildren();
    QUnit.equal(3, children.length);
    QUnit.equal(of1, (children[0]));
    QUnit.equal(on1, (children[1]));
    QUnit.equal(of2, (children[2]));
    QUnit.equal(of, of1.getParent());
    QUnit.equal(of, on1.getParent());
    QUnit.equal(of, of2.getParent());
});
QUnit.test("testGetNamedElement()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var of1 = new ObjectFolder_1.ObjectFolder("abc");
    of.addChild(of1, true);
    var on1 = new ObjectNode_1.ObjectNode("a", "1");
    of.addChild(on1, true);
    var of2 = new ObjectFolder_1.ObjectFolder("bc");
    of.addChild(of2, true);
    of2.addFolderFromPath("aa");
    var namedElements = of.getNamedElement("a");
    QUnit.equal(1, namedElements.length);
    QUnit.equal(on1, (namedElements[0]));
    QUnit.equal(0, of.getNamedElement("d"));
});
QUnit.test("testFindNode()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var ofax = of.addFolderFromPath("/a/x");
    var ofabc = of.addFolderFromPath("/a/b/c");
    var ofab = of.addFolderFromPath("/a/b");
    var onz = new ObjectNode_1.ObjectNode("z", "--");
    ofabc.addChild(onz);
    var ona = new ObjectNode_1.ObjectNode("a", "---");
    of.addChild(ona, true);
    var ondB = new ObjectNode_1.ObjectNode("d", "--");
    ofab.addChild(ondB);
    var ondC = new ObjectNode_1.ObjectNode("d", "---");
    ofabc.addChild(ondC);
    var oneC = new ObjectNode_1.ObjectNode("e", "---");
    ofabc.addChild(oneC);
    var oneX = new ObjectNode_1.ObjectNode("e", "---");
    ofax.addChild(oneX);
    var f;
    f = of.findNode("Z");
    QUnit.equal(onz, f);
    f = of.findNode("c");
    QUnit.equal(null, f);
    f = of.findNode("a");
    //QUnit.equal(ObjectNode, f.getClass());
    QUnit.equal("a", f.getName());
    QUnit.equal(ona, f);
    f = of.findNode("d");
    QUnit.equal("d", f.getName());
    QUnit.equal(ondB, f);
    f = of.findNode("e");
    QUnit.equal("e", f.getName());
    QUnit.equal(oneX, f);
});
QUnit.test("testGetAllChildNode2()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var oc = of.addFolderFromPath("/a/b/c");
    var ony = new ObjectNode_1.ObjectNode("y", "Y");
    oc.addChild(ony);
    var onz = new ObjectNode_1.ObjectNode("z", "Z");
    oc.addChild(onz);
    var ona = new ObjectNode_1.ObjectNode("a", "A");
    of.addChild(ona, true);
    var v = new Array();
    of.getAllChildNode(v);
    QUnit.equal(3, v.length);
});
QUnit.test("testAddNodeString()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var on;
    ObjectFolder_1.ObjectFolder.addNodeString(of, "a", "abc");
    QUnit.equal(1, of.getChildren().length);
    on = (of.getChildren()[0]);
    QUnit.equal(true, on.isStringObject());
    QUnit.equal("abc", on.getString());
    ObjectFolder_1.ObjectFolder.addNodeString(of, "a", "bcd");
    QUnit.equal(2, of.getChildren().length);
    on = (of.getChildren()[1]);
    QUnit.equal(true, on.isStringObject());
    QUnit.equal("bcd", on.getString());
    ObjectFolder_1.ObjectFolder.addNodeString(of, "a", null);
    QUnit.equal(2, of.getChildren().length);
});
QUnit.test("testAddNodeInt()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var on;
    ObjectFolder_1.ObjectFolder.addNodeInt(of, "a", 10);
    QUnit.equal(1, of.getChildren().length);
    on = (of.getChildren()[0]);
    QUnit.equal(true, on.isIntObject());
    QUnit.equal(10, on.getInt());
    ObjectFolder_1.ObjectFolder.addNodeInt(of, "a", 20);
    QUnit.equal(2, of.getChildren().length);
    on = (of.getChildren()[1]);
    QUnit.equal(true, on.isIntObject());
    QUnit.equal(20, on.getInt());
});
QUnit.test("testAddNodeFloat()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var on;
    ObjectFolder_1.ObjectFolder.addNodeFloat(of, "a", 10.0);
    QUnit.equal(1, of.getChildren().length);
    on = (of.getChildren()[0]);
    QUnit.equal(true, on.isFloatObject());
    QUnit.equal(10.0, on.getFloat());
    ObjectFolder_1.ObjectFolder.addNodeFloat(of, "a", Number.MAX_VALUE);
    QUnit.equal(2, of.getChildren().length);
    on = (of.getChildren()[1]);
    QUnit.equal(true, on.isFloatObject());
    QUnit.equal(Number.MAX_VALUE, on.getFloat());
});
QUnit.test("testAddNodeDouble()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var on;
    ObjectFolder_1.ObjectFolder.addNodeDouble(of, "a", 10.0);
    QUnit.equal(1, of.getChildren().length);
    on = (of.getChildren()[0]);
    QUnit.equal(true, on.isDoubleObject());
    QUnit.equal(10.0, on.getDouble());
    ObjectFolder_1.ObjectFolder.addNodeDouble(of, "a", Number.MAX_VALUE);
    QUnit.equal(2, of.getChildren().length);
    on = (of.getChildren()[1]);
    QUnit.equal(true, on.isDoubleObject());
    QUnit.equal(Number.MAX_VALUE, on.getDouble());
});
QUnit.test("testAddNodeBool()", function () {
    var of = new ObjectFolder_1.ObjectFolder("folder");
    var on;
    ObjectFolder_1.ObjectFolder.addNodeBool(of, "a", true);
    QUnit.equal(1, of.getChildren().length);
    on = (of.getChildren()[0]);
    QUnit.equal(true, on.isBoolObject());
    QUnit.equal(true, on.getBool());
    ObjectFolder_1.ObjectFolder.addNodeBool(of, "a", false);
    QUnit.equal(2, of.getChildren().length);
    on = (of.getChildren()[1]);
    QUnit.equal(true, on.isBoolObject());
    QUnit.equal(false, on.getBool());
});
//# sourceMappingURL=ObjectFolderTest.js.map