var UtilString_1 = require('./UtilString');
//module jp.kitec.lib.util
QUnit.test("testTab2space()", function () {
    QUnit.equal(null, UtilString_1.UtilString.tab2space(null));
    QUnit.equal("        a", UtilString_1.UtilString.tab2space("\ta"));
    QUnit.equal("        a", UtilString_1.UtilString.tab2space("  \ta"));
    QUnit.equal("        a", UtilString_1.UtilString.tab2space("       \ta"));
    QUnit.equal("        a       z", UtilString_1.UtilString.tab2space("       \ta\tz"));
    QUnit.equal("        あいう  z", UtilString_1.UtilString.tab2space("       \tあいう\tz"));
});
//QUnit.test("testGetMd5()", function () {
//    QUnit.equal("d41d8cd98f00b204e9800998ecf8427e", UtilString.getMd5(""));
//    QUnit.equal("d2490f048dc3b77a457e3e450ab4eb38", UtilString.getMd5("012"));
//    QUnit.equal("e4d909c290d0fb1ca068ffaddf22cbd0", UtilString.getMd5("The quick brown fox jumps over the lazy dog."));
//    QUnit.equal(null, UtilString.getMd5(null));
//});
QUnit.test("testGetZenkakuNumberExPeriod()", function () {
    QUnit.equal("０１２", UtilString_1.UtilString.getZenkakuNumberExPeriod("012"));
    QUnit.equal("５９４", UtilString_1.UtilString.getZenkakuNumberExPeriod("594"));
    QUnit.equal("abc", UtilString_1.UtilString.getZenkakuNumberExPeriod("abc"));
    QUnit.equal("５９４zいろは", UtilString_1.UtilString.getZenkakuNumberExPeriod("594zいろは"));
    QUnit.equal("", UtilString_1.UtilString.getZenkakuNumberExPeriod(""));
    try {
        UtilString_1.UtilString.getZenkakuNumberExPeriod(null);
        QUnit.ok(false);
    }
    catch (e) {
    }
});
QUnit.test("testIsHankaku()", function () {
    QUnit.equal(true, UtilString_1.UtilString.isHankaku('A'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankaku('4'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankaku('+'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankaku('~'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankaku('ｱ'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankaku('ﾝ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankaku('ア'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankaku('ソ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankaku('あ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankaku('ゑ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankaku('字'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankaku('！'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankaku('Ω'.charCodeAt(0)));
});
QUnit.test("testIsHankakuKana()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('A'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('4'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('+'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('~'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankakuKana('ｱ'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankakuKana('ﾝ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('ア'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('ソ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('あ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('ゑ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('字'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('！'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuKana('Ω'.charCodeAt(0)));
});
QUnit.test("testIsZenkakuKana()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('A'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('4'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('+'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('~'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('ｱ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('ﾝ'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isZenkakuKana('ア'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isZenkakuKana('ソ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('あ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('ゑ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('字'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('！'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuKana('Ω'.charCodeAt(0)));
});
QUnit.test("testIsFullHiraKana()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('A'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('4'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('+'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('~'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('ｱ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('ﾝ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('ア'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('ソ'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isFullHiraKana('あ'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isFullHiraKana('ゑ'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('字'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('！'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isFullHiraKana('Ω'.charCodeAt(0)));
});
QUnit.test("testIsHankakuSuuji()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isHankakuSuuji('A'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankakuSuuji('0'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isHankakuSuuji('9'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuSuuji('+'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuSuuji('０'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isHankakuSuuji('９'.charCodeAt(0)));
});
QUnit.test("testIsZenkakuSuuji()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuSuuji('A'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuSuuji('0'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuSuuji('9'.charCodeAt(0)));
    QUnit.equal(false, UtilString_1.UtilString.isZenkakuSuuji('+'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isZenkakuSuuji('０'.charCodeAt(0)));
    QUnit.equal(true, UtilString_1.UtilString.isZenkakuSuuji('９'.charCodeAt(0)));
});
//QUnit.test("testIsEnableEncCharCharString()", function () {
//    QUnit.equal(true, UtilString.isEnableEncChar('a'.charCodeAt(0), "ASCII"));
//    QUnit.equal(false, UtilString.isEnableEncChar('あ'.charCodeAt(0), "ASCII"));
//    QUnit.equal(true, UtilString.isEnableEncChar('あ'.charCodeAt(0), "EUC-JP"));
//    QUnit.equal(true, UtilString.isEnableEncChar('ア'.charCodeAt(0), "EUC-JP"));
//    QUnit.equal(false, UtilString.isEnableEncChar('①'.charCodeAt(0), "EUC-JP"));
//});
//QUnit.test("testIsEnableEncCharStringString()", function () {
//    QUnit.equal(true, UtilString.isEnableEncChar("Aa", "ASCII"));
//    QUnit.equal(false, UtilString.isEnableEncChar("Aあ", "ASCII"));
//    QUnit.equal(true, UtilString.isEnableEncChar("Aあ", "EUC-JP"));
//    QUnit.equal(true, UtilString.isEnableEncChar("Aア", "EUC-JP"));
//    QUnit.equal(false, UtilString.isEnableEncChar("①", "EUC-JP"));
//});
QUnit.test("testIsDiffStringString()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isDiff((null), (null)));
    QUnit.equal(true, UtilString_1.UtilString.isDiff(null, "ABC"));
    QUnit.equal(true, UtilString_1.UtilString.isDiff("ABC", null));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("", ""));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("ABC", "ABC"));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("Abc", "abc"));
});
QUnit.test("testIsDiffStringStringBoolean()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isDiff((null), (null), true));
    QUnit.equal(true, UtilString_1.UtilString.isDiff(null, "ABC", true));
    QUnit.equal(true, UtilString_1.UtilString.isDiff("ABC", null, true));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("", "", true));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("ABC", "ABC", true));
    QUnit.equal(true, UtilString_1.UtilString.isDiff("Abc", "abc", true));
    QUnit.equal(false, UtilString_1.UtilString.isDiff((null), (null), false));
    QUnit.equal(true, UtilString_1.UtilString.isDiff(null, "ABC", false));
    QUnit.equal(true, UtilString_1.UtilString.isDiff("ABC", null, false));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("", "", false));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("ABC", "ABC", false));
    QUnit.equal(false, UtilString_1.UtilString.isDiff("Abc", "abc", false));
});
QUnit.test("testIsDiffArray()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray((null), (null)));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(null, ["ABC"]));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC"], null));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray([], []));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray(["ABC", "DEFG"], ["ABC", "DEFG"]));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC", "DE"], ["ABC"]));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC"], ["ABC", "DEFG"]));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray(["abc", "defg"], ["abc", "DEFG"]));
});
QUnit.test("testisDiffArrayCase()", function () {
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray((null), (null), true));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(null, ["ABC"], true));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC"], null, true));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray([], [], true));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray(["ABC", "DEFG"], ["ABC", "DEFG"], true));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC", "DE"], ["ABC"], true));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC"], ["ABC", "DEFG"], true));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["abc", "defg"], ["abc", "DEFG"], true));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray((null), (null), false));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(null, ["ABC"], false));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC"], null, false));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray([], [], false));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray(["ABC", "DEFG"], ["ABC", "DEFG"], false));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC", "DE"], ["ABC"], false));
    QUnit.equal(true, UtilString_1.UtilString.isDiffArray(["ABC"], ["ABC", "DEFG"], false));
    QUnit.equal(false, UtilString_1.UtilString.isDiffArray(["abc", "defg"], ["abc", "DEFG"], false));
});
QUnit.test("testBin2dec()", function () {
    QUnit.equal(0, UtilString_1.UtilString.bin2dec("0"));
    QUnit.equal(1, UtilString_1.UtilString.bin2dec("1"));
    QUnit.equal(2, UtilString_1.UtilString.bin2dec("10"));
    QUnit.equal(3, UtilString_1.UtilString.bin2dec("11"));
    QUnit.equal(0x7fffffff, UtilString_1.UtilString.bin2dec("1111111111111111111111111111111"));
    QUnit.equal(0x40000000, UtilString_1.UtilString.bin2dec("1000000000000000000000000000000"));
    QUnit.equal(0x80000000 | 0, UtilString_1.UtilString.bin2dec("10000000000000000000000000000000"));
    QUnit.equal(0xffffffff | 0, UtilString_1.UtilString.bin2dec("11111111111111111111111111111111"));
});
//# sourceMappingURL=UtilStringTest.js.map