//import { MessageDigest } from '../../../java/security/MessageDigest'
//import { NoSuchAlgorithmException } from '../../../java/security/NoSuchAlgorithmException'
//import { UnsupportedEncodingException } from '../../../java/io/UnsupportedEncodingException'
//module jp.kitec.lib.util
/**
 * String関係のユーティリティ
 * @author kawae
 * @since 2005/03/16
**/
var UtilString;
(function (UtilString) {
    /**
     * タブをスペースに変更
     * @param s
     * @return
     * @author kawae
     * @since 2005/03/16
    **/
    function tab2space(s) {
        if (s == null)
            return s;
        while (s.indexOf('\t') >= 0) {
            var index = s.indexOf('\t');
            var length_1 = s.length;
            var s1 = s.substring(0, index);
            var s2 = (index + 1) >= length_1 ? "" : s.substring(index + 1);
            var s1length = 0;
            s1length = s1.length;
            for (var i__0 = 0; i__0 < s1.length; i__0++) {
                var c = s1.charCodeAt(i__0);
                if (!UtilString.isHankaku(c))
                    s1length += 1;
            }
            var spacecount = 8 - s1length % 8;
            var sb = "";
            sb += s1;
            for (var i__1 = 0; i__1 < spacecount; i__1++)
                sb += " ";
            sb += s2;
            s = sb;
        }
        return s;
    }
    UtilString.tab2space = tab2space;
    /**
     * メッセージダイジェストの取得
     * @param s
     * @return
     * @author kawae
     * @since 2005/09/05
    **/
    //staticexport function getMd5(s: string): string {
    //    if (s == null) return null;
    //    let str = null;
    //    try {
    //        let sb = new StringBuffer();
    //        let md = MessageDigest.getInstance("MD5");
    //        var dat: number[] = s.getBytes();
    //        md.update(dat, 0, dat.length);
    //        var ddata: number[] = md.digest();
    //        ddata.forEach(element => {
    //            let r = (element >= 0) ? element : (256 + element);
    //            if (r < 0x10) sb.append("0");
    //            sb.append(Integer.toHexString(r));
    //        }
    //        );
    //        str = sb.toString();
    //    }
    //    catch (e: NoSuchAlgorithmException) {
    //        throw new RuntimeException("MD5がサポートされていない", e);
    //    }
    //    return str;
    //}
    /**
     * 変換用の全角数字
     **/
    var ZENKAKU_TABLE;
    /**
     * 指定された半角数字の文字列を、全角数字の文字列へ変換する。
     * 数字以外の場合、全角へは変換されず、もとの文字が設定される。
     * @param str	半角数字の文字列
     * @return 全角数字の文字列
     * @since   2003/02/13
     * @author  Kawae
     * @version 2003/02/13
    **/
    function getZenkakuNumberExPeriod(str) {
        if (!ZENKAKU_TABLE) {
            ZENKAKU_TABLE = new Map();
            for (var _i = 0, _a = [['０', '0'],
                ['１', '1'],
                ['２', '2'],
                ['３', '3'],
                ['４', '4'],
                ['５', '5'],
                ['６', '6'],
                ['７', '7'],
                ['８', '8'],
                ['９', '9']]; _i < _a.length; _i++) {
                var k = _a[_i];
                ZENKAKU_TABLE.set(k[0], k[1]);
            }
        }
        var c = "";
        for (var i = 0; i < str.length; i++) {
            var cc = str.charAt(i);
            var z = cc;
            ZENKAKU_TABLE.forEach(function (e, k) {
                if (e === cc) {
                    z = k;
                }
            });
            c += z;
        }
        return c;
    }
    UtilString.getZenkakuNumberExPeriod = getZenkakuNumberExPeriod;
    /**
     * 半角か確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    function isHankaku(c) {
        if (isHankakuKana(c))
            return true;
        else if (c < 0x7F)
            return true;
        return false;
    }
    UtilString.isHankaku = isHankaku;
    /**
     * 半角カナか確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    function isHankakuKana(c) {
        return (c > 0xff60 && c <= 0xff9f);
    }
    UtilString.isHankakuKana = isHankakuKana;
    /**
     * 全角カナか確認
     * @author kawae
     * @since 2005/01/06
    **/
    function isZenkakuKana(c) {
        return (c > 0x30a0 && c <= 0x30f4);
    }
    UtilString.isZenkakuKana = isZenkakuKana;
    /**
     * 全角ひらがなか確認
     * @author kawae
     * @since 2005/01/06
    **/
    function isFullHiraKana(c) {
        return (c > 0x3040 && c <= 0x3094);
    }
    UtilString.isFullHiraKana = isFullHiraKana;
    /**
     * 半角数字か確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    function isHankakuSuuji(c) {
        return c >= '0'.charCodeAt(0) && c <= '9'.charCodeAt(0);
    }
    UtilString.isHankakuSuuji = isHankakuSuuji;
    /**
     * 全角数字か確認
     * @param c
     * @return
     * @author kawae
     * @since 2005/01/06
    **/
    function isZenkakuSuuji(c) {
        return c >= '０'.charCodeAt(0) && c <= '９'.charCodeAt(0);
    }
    UtilString.isZenkakuSuuji = isZenkakuSuuji;
    /**
     * 特定のエンコーディングで利用出来る文字か確認
     * @param s
     * @return
     * @author kawae
     * @since 2006/01/12
    **/
    //export function isEnableEncChar(s: number, enc: string): boolean {
    //    return UtilString.isEnableEncChar(Character.toString(s), enc);
    //}
    /**
     * 特定のエンコーディングで利用出来る文字か確認
     * @param s
     * @return
     * @author kawae
     * @since 2006/01/12
    **/
    //export function isEnableEncChar(s: string, enc: string): boolean {
    //    try {
    //        let sjis = new string(s.getBytes(enc), enc);
    //        return s.equalsIgnoreCase(sjis);
    //    }
    //    catch (expected: UnsupportedEncodingException) {
    //    }
    //    return false;
    //}
    /**
     * 文字列が異なるか確認
     * @param s1
     * @param s2
     * @return
     * @author kawae
     * @since 2004/09/26
    **/
    //export function isDiff(s1: string, s2: string): boolean {
    //    return UtilString.isDiff(s1, s2, false);
    //}
    function isDiff(s1, s2, compareUpperLower) {
        if (compareUpperLower === void 0) { compareUpperLower = false; }
        if ((s1 == null) != (s2 == null))
            return true;
        if (s1 == null)
            return false;
        if (compareUpperLower)
            return s1 !== s2;
        else
            return s1.toLowerCase() !== s2.toLowerCase();
    }
    UtilString.isDiff = isDiff;
    /**
     * 文字配列が異なるか確認
     * @param s1
     * @param s2
     * @return
     * @author kawae
     * @since 2004/09/26
    **/
    //export function isDiffArray(s1: string[], s2: string[]): boolean {
    //    return UtilString.isDiff(s1, s2, false);
    //}
    function isDiffArray(s1, s2, compareUpperLower) {
        if (compareUpperLower === void 0) { compareUpperLower = false; }
        if ((s1 == null) != (s2 == null))
            return true;
        if (s1 == null)
            return false;
        if (s1.length != s2.length)
            return true;
        for (var i = 0; i < s1.length; i++) {
            if (UtilString.isDiff(s1[i], s2[i], compareUpperLower))
                return true;
        }
        return false;
    }
    UtilString.isDiffArray = isDiffArray;
    function bin2dec(s) {
        var result = 0;
        for (var i = 0; i < s.length; i++) {
            var c = s.charCodeAt(s.length - i - 1);
            if (c === '1'.charCodeAt(0))
                result |= 1 << i;
        }
        return result;
    }
    UtilString.bin2dec = bin2dec;
})(UtilString = exports.UtilString || (exports.UtilString = {}));
//# sourceMappingURL=UtilString.js.map