var common_1 = require('../common');
var Item_1 = require('./Item');
var RefList_1 = require('./RefList');
//module jp.kitec.lib.util
QUnit.test("testRefList()", function () {
    new RefList_1.RefList();
    QUnit.ok(true);
});
//QUnit.test("testRefListString()", function () {
//    new RefList<string>("hoge");
//});
QUnit.test("testSetHead()", function () {
    var l = createList(3);
    l.setHead(l.itemAt(1));
    QUnit.equal("1", (l.firstElement()));
});
QUnit.test("testFirstElement()", function () {
    var l = new RefList_1.RefList();
    QUnit.equal(null, l.firstElement());
    l.addElement(0);
    l.addElement(1);
    l.addElement(2);
    QUnit.equal(0, l.firstElement());
});
QUnit.test("testLastElement()", function () {
    var l = new RefList_1.RefList();
    QUnit.equal(null, l.lastElement());
    l.addElement(0);
    QUnit.equal(0, l.lastElement());
    l.addElement(1);
    QUnit.equal(1, l.lastElement());
    l.addElement(2);
    QUnit.equal(2, l.lastElement());
});
QUnit.test("testElementAt()", function () {
    var l = new RefList_1.RefList();
    l.addElement("0");
    l.addElement("1");
    l.addElement("2");
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("1", (l.elementAt(1)));
    QUnit.equal("2", (l.elementAt(2)));
    QUnit.equal("0", (l.elementAt(3)));
    QUnit.equal("1", (l.elementAt(4)));
    QUnit.equal("2", (l.elementAt(5)));
    QUnit.equal("0", (l.elementAt(30)));
    QUnit.equal("2", (l.elementAt(-1)));
    QUnit.equal("1", (l.elementAt(-2)));
    QUnit.equal("0", (l.elementAt(-3)));
    var l2 = new RefList_1.RefList();
    try {
        QUnit.equal(null, (l2.elementAt(0)));
        QUnit.ok(false);
    }
    catch (e) {
        QUnit.ok(e instanceof common_1.error.lang.IndexOutOfBoundsException);
    }
});
QUnit.test("testItemAtInt()", function () {
    var l = new RefList_1.RefList();
    l.addElement("0");
    l.addElement("1");
    l.addElement("2");
    QUnit.equal("0", (l.itemAt(0).getObject()));
    QUnit.equal("1", (l.itemAt(1).getObject()));
    QUnit.equal("2", (l.itemAt(2).getObject()));
    QUnit.equal("0", (l.itemAt(3).getObject()));
    QUnit.equal("1", (l.itemAt(4).getObject()));
    QUnit.equal("2", (l.itemAt(5).getObject()));
    QUnit.equal("0", (l.itemAt(30).getObject()));
    QUnit.equal("2", (l.itemAt(-1).getObject()));
    QUnit.equal("1", (l.itemAt(-2).getObject()));
    QUnit.equal("0", (l.itemAt(-3).getObject()));
    var l2 = new RefList_1.RefList();
    try {
        QUnit.equal(null, l2.itemAt(0));
        QUnit.ok(false);
    }
    catch (e) {
        //    QUnit.ok(false, );
        //}
        //     catch (e__1: IndexOutOfBoundsException) {
        QUnit.ok(e instanceof common_1.error.lang.IndexOutOfBoundsException);
    }
});
QUnit.test("testItemAtObject()", function () {
    var l = new RefList_1.RefList();
    QUnit.equal(null, l.itemOf("0"));
    l.addElement("0");
    l.addElement("1");
    l.addElement("2");
    QUnit.equal("0", (l.itemOf("0").getObject()));
    QUnit.equal("1", (l.itemOf("1").getObject()));
    QUnit.equal("2", (l.itemOf("2").getObject()));
    QUnit.equal(null, l.itemOf(new String("2")));
    QUnit.equal(null, l.itemOf("3"));
});
QUnit.test("testSize()", function () {
    var l = new RefList_1.RefList();
    QUnit.equal(null, l.itemOf("0"));
    QUnit.equal(0, l.size());
    l.addElement("0");
    QUnit.equal(1, l.size());
    l.addElement("1");
    QUnit.equal(2, l.size());
    l.addElement("2");
    QUnit.equal(3, l.size());
});
QUnit.test("testAddElement()", function () {
    var l = new RefList_1.RefList();
    QUnit.equal(null, l.itemOf("0"));
    QUnit.equal(0, l.size());
    QUnit.equal(true, l.addElement("0"));
    QUnit.equal(1, l.size());
    QUnit.equal(true, l.addElement("1"));
    QUnit.equal(2, l.size());
    QUnit.equal(true, l.addElement("2"));
    QUnit.equal(3, l.size());
    QUnit.equal(false, l.addElement(null));
    QUnit.equal(3, l.size());
});
QUnit.test("testRemoveAllElements()", function () {
    var l = createList(3);
    QUnit.equal(3, l.size());
    l.removeAllElements();
    QUnit.equal(0, l.size());
});
QUnit.test("testRemoveElement()", function () {
    var l = new RefList_1.RefList();
    l.addElement("0");
    l.addElement("1");
    l.addElement("2");
    l.addElement("0");
    l.addElement("a");
    var elm;
    elm = l.removeElement("0");
    QUnit.equal("a", (elm.getObject()));
    QUnit.equal(4, l.size());
    QUnit.equal("1", (l.elementAt(0)));
    QUnit.equal("2", (l.elementAt(1)));
    QUnit.equal("0", (l.elementAt(2)));
    QUnit.equal("a", (l.elementAt(3)));
    elm = l.removeElement("0");
    QUnit.equal("2", (elm.getObject()));
    QUnit.equal(3, l.size());
    QUnit.equal("1", (l.elementAt(0)));
    QUnit.equal("2", (l.elementAt(1)));
    QUnit.equal("a", (l.elementAt(2)));
    elm = l.removeElement("0");
    QUnit.equal(null, elm);
    QUnit.equal(3, l.size());
    QUnit.equal("1", (l.elementAt(0)));
    QUnit.equal("2", (l.elementAt(1)));
    QUnit.equal("a", (l.elementAt(2)));
});
QUnit.test("testRemoveItemAt()", function () {
    var l = new RefList_1.RefList();
    l.addElement("0");
    l.addElement("1");
    l.addElement("a");
    var elm;
    elm = l.removeItemAt(null);
    QUnit.equal(null, elm);
    elm = l.removeItemAt(l.itemAt(0));
    QUnit.equal("a", (elm.getObject()));
    QUnit.equal(2, l.size());
    elm = l.removeItemAt(l.itemAt(0));
    QUnit.equal("a", (elm.getObject()));
    QUnit.equal(1, l.size());
    elm = l.removeItemAt(l.itemAt(0));
    QUnit.equal(null, elm);
    QUnit.equal(0, l.size());
});
QUnit.test("testContains()", function () {
    var l = new RefList_1.RefList();
    l.addElement("0");
    l.addElement("1");
    l.addElement("2");
    l.addElement("0");
    QUnit.equal(true, l.contains("0"));
    QUnit.equal(true, l.contains("1"));
    QUnit.equal(false, l.contains("A"));
    QUnit.equal(false, l.contains(new String("0")));
});
QUnit.test("testInsertElementAtEInt()", function () {
    var l = createList(3);
    QUnit.equal(null, l.insertElementAt(null, 0));
    QUnit.equal(null, l.insertElementAt("0", 5));
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("1", (l.elementAt(1)));
    QUnit.equal("2", (l.elementAt(2)));
    QUnit.ok(l.insertElementAt("a", 0));
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("a", (l.elementAt(1)));
    QUnit.equal("1", (l.elementAt(2)));
    QUnit.equal("2", (l.elementAt(3)));
    QUnit.ok(l.insertElementAt("b", 2));
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("a", (l.elementAt(1)));
    QUnit.equal("1", (l.elementAt(2)));
    QUnit.equal("b", (l.elementAt(3)));
    QUnit.equal("2", (l.elementAt(4)));
    QUnit.ok(l.insertElementAt("c", 4));
    QUnit.equal("2", (l.elementAt(4)));
    QUnit.equal("c", (l.elementAt(5)));
    QUnit.equal(6, l.size());
    QUnit.equal(null, l.insertElementAt("b", 6));
    QUnit.equal(null, l.insertElementAt("b", -1));
});
QUnit.test("testInsertElementAtEItemOfE()", function () {
    var l = new RefList_1.RefList();
    l.insertElementAt(null, null);
    QUnit.equal(0, l.size());
    l.insertElementItemAt(null, new Item_1.Item("z"));
    QUnit.equal(0, l.size());
    l.addElement("0");
    l.addElement("1");
    l.addElement("2");
    l.insertElementAt(null, null);
    QUnit.equal(3, l.size());
    l.insertElementItemAt(null, new Item_1.Item("z"));
    QUnit.equal(3, l.size());
    l.insertElementItemAt("a", l.itemAt(0));
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("a", (l.elementAt(1)));
    QUnit.equal("1", (l.elementAt(2)));
    QUnit.equal("2", (l.elementAt(3)));
    l.insertElementItemAt("b", l.itemAt(2));
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("a", (l.elementAt(1)));
    QUnit.equal("1", (l.elementAt(2)));
    QUnit.equal("b", (l.elementAt(3)));
    QUnit.equal("2", (l.elementAt(4)));
});
QUnit.test("testGetCopy()", function () {
    var l = new RefList_1.RefList();
    var l2 = l.getCopy();
    QUnit.equal(l.size(), l2.size());
    l.addElement("0");
    l.addElement("1");
    l.addElement("2");
    var l3 = l.getCopy();
    QUnit.equal(l.size(), l3.size());
    for (var i = 0; i < 3; i++) {
        QUnit.equal((l.elementAt(i)), (l3.elementAt(i)));
    }
});
QUnit.test("testSwap()", function () {
    var l = createList(3);
    l.swap(l.itemAt(0), l.itemAt(1));
    QUnit.equal("1", (l.elementAt(0)));
    QUnit.equal("0", (l.elementAt(1)));
    QUnit.equal("2", (l.elementAt(2)));
    l.swap(l.itemAt(2), l.itemAt(1));
    QUnit.equal("1", (l.elementAt(0)));
    QUnit.equal("2", (l.elementAt(1)));
    QUnit.equal("0", (l.elementAt(2)));
});
QUnit.test("testDeleteAtoB()", function () {
    var l;
    l = createList(6);
    l.deleteAtoB(l.itemAt(1), l.itemAt(3), true);
    QUnit.equal(3, l.size());
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("4", (l.elementAt(1)));
    QUnit.equal("5", (l.elementAt(2)));
    l = createList(6);
    l.deleteAtoB(l.itemAt(1), l.itemAt(4), false);
    QUnit.equal(2, l.size());
    QUnit.equal("2", (l.elementAt(0)));
    QUnit.equal("3", (l.elementAt(1)));
    l = createList(6);
    l.deleteAtoB(l.itemAt(3), l.itemAt(1), true);
    QUnit.equal(1, l.size());
    QUnit.equal("2", (l.elementAt(0)));
    l = createList(6);
    l.deleteAtoB(l.itemAt(3), l.itemAt(1), false);
    QUnit.equal(3, l.size());
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("4", (l.elementAt(1)));
    QUnit.equal("5", (l.elementAt(2)));
});
QUnit.test("testFlip()", function () {
    var l = createList(4);
    l.flip();
    QUnit.equal(4, l.size());
    QUnit.equal("0", (l.elementAt(0)));
    QUnit.equal("3", (l.elementAt(1)));
    QUnit.equal("2", (l.elementAt(2)));
    QUnit.equal("1", (l.elementAt(3)));
});
//QUnit.test("testHashCode()", function () {
//    var l: RefList<string> = createList(4);
//    l.hashCode();
//});
QUnit.test("testEquals()", function () {
    var l = createList(0);
    var l1 = createList(3);
    var l2 = createList(3);
    QUnit.equal(true, l.equals(l));
    QUnit.equal(false, l.equals(null));
    QUnit.equal(false, l.equals(l1));
    QUnit.equal(false, l.equals(l2));
    QUnit.equal(true, l1.equals(l1));
    QUnit.equal(true, l1.equals(l2));
    QUnit.equal(false, l1.equals(l));
});
function createList(num) {
    var l = new RefList_1.RefList();
    for (var i = 0; i < num; i++) {
        l.addElement("" + i);
    }
    return l;
}
//# sourceMappingURL=RefListTest.js.map