import { Item } from './Item';
/**
 * 要素へのアクセスが、昇順／降順の双方向に可能な循環リスト。<BR>
 * また、すべての要素は、輪となって繋がっている。<BR>
 * Itemを直接操作する場合、整合性チェックのためO(n)のチェックが入るので注意が必要。<BR>
 * 比較する時にオブジェクトの同一性ではなくリファレンスの同一性を使用する。<BR>
 * visibility public<BR>
 * package    jp.kitec.lib.util<BR>
 * name       RefList<BR>
 * implements Serializable<BR>
 * @since 　2002/12/20
 * @author　fujita
 * @version 2002/12/20
 * TODO implement java.util.List<E>
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
export declare class RefList<T> {
    /**
     * リスト上の先頭となるアイテム **/
    private head;
    /**
     * 登録されているアイテム数 **/
    private regCount;
    /**
     * アイテム数 0 の、空の RefList を構築する。
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    constructor();
    /**
     * 指定されたアイテムを、この RefList の先頭を指す要素として設定する。
     * 指定されたアイテムが、この RefList の要素に含まれない場合、
     * 先頭へは設定されない。
     * @param it 先頭の要素として設定するアイテム
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    setHead(it: Item<T>): void;
    /**
     * この RefList の先頭の要素を返す。
     * @return 先頭の要素
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    firstElement(): T;
    /**
     * この RefList の最後の要素を返す。
     * @return 最後の要素
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    lastElement(): T;
    /**
     * 現在の先頭の要素を基点として、
     * 指定されたインデックス位置の要素を返す。
     * @param c インデックス
     * @return 指定されたインデックス位置にある要素
     * @see #itemAt(int)
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    elementAt(c: number): T;
    /**
     * 現在の先頭の要素を基点として、
     * 指定されたインデックス位置のアイテムを返す。
     * @param c インデックス
     * @return 指定されたインデックス位置にあるアイテム
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    itemAt(c: number): Item<T>;
    /**
     * 指定されたデータを持つ要素を返す。
     * @param o 要素
     * @return 指定された要素を持つアイテム
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    itemOf(o: Object): Item<Object>;
    /**
     * 現在の RefList の要素数を返す。
     * @return  RefList の要素数
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    size(): number;
    /**
     * 指定された要素を RefList 最後に追加し、サイズを 1 つ増やす。
     * @param o 新たに追加する要素
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    addElement(o: T): boolean;
    /**
     * この RefList が保持するすべての要素を削除する。
     * 削除後、 RefList のサイズは 0 となる。
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    removeAllElements(): void;
    /**
     * 指定された要素を RefList から検索し、最初に見つかった要素を削除する。
     * @param o	削除する要素
     * @return	該当する要素が見つからなければ、null。
     * 見つかれば削除された要素の前のアイテム
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    removeElement(o: Object): Item<T>;
    /**
     * 指定されたアイテムを RefList から検索し、最初に見つかったアイテムを削除する。
     * @param ref		削除するアイテム
     * @return	該当するアイテムが見つからなければnull
     * 見つかれば削除されたアイテムの前のアイテム
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    removeItemAt(ref: Item<T>): Item<T>;
    /**
     * 指定されたオブジェクトが要素かどうかを判定する。
     * @param o	オブジェクト
     * @return 指定されたオブジェクトが equals メソッドによって
     * RefList 内の要素と同じと確認された場合にだけ true、
     * そうでない場合は false
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    contains(o: Object): boolean;
    /**
     * 指定されたアイテムが要素かどうかを判定する。
     * @param ptr	アイテム
     * @return 指定されたアイテムが equals メソッドによって
     * RefList 内の要素と同じと確認された場合にだけ true、
     * そうでない場合は false
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    private containsItem(ptr);
    /**
     * 指定されたオブジェクトを新たな要素として
     * RefList の指定された位置(指定されたindexの直後)へ挿入する。
     * @param ptr		挿入される要素
     * @param index	新しい要素を挿入する位置
     * @return	要素が追加された場合、追加されたアイテム。
     * インデックスが不正な場合など、
     * 追加されなかった場合は、null
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    insertElementAt(data: T, index: number): Item<Object>;
    /**
     * 指定されたオブジェクトを新たな要素として
     * RefList の指定されたアイテムの直後に挿入する。
     * TODO:注意！！！　insertの順番が間違っている可能性あり。
     * @param data	挿入される要素
     * @param ptr		新しい要素を挿入する直前のアイテム
     * @return	要素が追加された場合、追加されたアイテム。
     * インデックスが不正な場合など、
     * 追加されなかった場合は、null
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    insertElementItemAt(data: T, ptr: Item<T>): Item<Object>;
    /**
     * この RefList の要素を共有する新たな RefList を構築し、返す。
     * @return	要素を共有する新たな RefLsit
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    getCopy(): RefList<T>;
    /**
     * 指定された 2 つのアイテムが示す要素を入れ替える。
     * @param i1 要素入れ替えるアイテム 1
     * @param i2 要素入れ替えるアイテム 2
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    swap(i1: Item<Object>, i2: Item<Object>): void;
    /**
     * it1 ～ it2 の範囲に含まれるすべての要素をこの RefList から削除する。
     * @param i1	削除する最初の要素
     * @param i2	削除する最後の要素
     * @param dir	削除を行う方向。true の場合、i1 から順（後方）に i2 まで
     * の要素を削除する。false の場合、i1 から逆順（前方）に要素
     * を削除する。
     * @return 指定された範囲の要素が削除された場合、true。指定された要素が
     * RefList に含まれない場合など削除がされなかった場合、false
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    deleteAtoB(it1: Item<T>, it2: Item<T>, dir: boolean): boolean;
    /**
     * この RefList が保持する要素の順番を反転する。
     * 例）	処理前：[A][B][C][D][E]
     * 処理後：[A][E][D][C][B]
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    flip(): void;
    equals(o: Object): boolean;
    /**
     * {@inheritDoc}**/
    get(index: number): T;
    /**
     * {@inheritDoc}**/
    set(index: number, element: T): T;
    /**
     * {@inheritDoc}**/
    add(index: number, element: T): void;
    /**
     * {@inheritDoc}**/
    remove(index: number): T;
}
