//module jp.kitec.lib.util
/**
 * リスト中のアイテム。<BR>
 * 自身の前後のアイテムを保持する。<BR>
 * @since 　2002/12/20
 * @author　Kawae
 * @version 2002/12/20
 * Copyright (c) 2002 KITec Inc,.. All rights reserved.
**/
var Item = (function () {
    /**
     * 指定されたデータを持ち、前後のアイテムのない（=null）の
     * 新たなアイテムを作成する。
     * @param i	データ
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    function Item(i) {
        this.setObject(i);
        this.nextItem = this.prevItem = null;
    }
    /**
     * このアイテムが保持するデータ返す。
     * @return	データ
     * @see #setObject(Object)
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    Item.prototype.getObject = function () {
        return this._object;
    };
    /**
     * 指定されたデータを、このアイテムのデータとして設定する。
     * @param o	データ
     * @see #getObject()
     * @since   2002/12/20
     * @author  Kawae
     * @version 2002/12/20
    **/
    Item.prototype.setObject = function (o) {
        this._object = o;
    };
    return Item;
})();
exports.Item = Item;
//# sourceMappingURL=Item.js.map